/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import javax.management.ObjectName;
import org.apache.hadoop.hbase.metrics.MetricsMBeanBase;
import org.apache.hadoop.hbase.metrics.MetricsString;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class HBaseInfo {
    protected final MetricsRecord mr;
    protected final HBaseInfoMBean mbean;
    protected MetricsRegistry registry = new MetricsRegistry();
    private static HBaseInfo theInstance = null;
    private MetricsString date = new MetricsString("date", this.registry, VersionInfo.getDate());
    private MetricsString revision = new MetricsString("revision", this.registry, VersionInfo.getRevision());
    private MetricsString url = new MetricsString("url", this.registry, VersionInfo.getUrl());
    private MetricsString user = new MetricsString("user", this.registry, VersionInfo.getUser());
    private MetricsString version = new MetricsString("version", this.registry, VersionInfo.getVersion());
    private MetricsString hdfsDate = new MetricsString("hdfsDate", this.registry, org.apache.hadoop.util.VersionInfo.getDate());
    private MetricsString hdfsRev = new MetricsString("hdfsRevision", this.registry, org.apache.hadoop.util.VersionInfo.getRevision());
    private MetricsString hdfsUrl = new MetricsString("hdfsUrl", this.registry, org.apache.hadoop.util.VersionInfo.getUrl());
    private MetricsString hdfsUser = new MetricsString("hdfsUser", this.registry, org.apache.hadoop.util.VersionInfo.getUser());
    private MetricsString hdfsVer = new MetricsString("hdfsVersion", this.registry, org.apache.hadoop.util.VersionInfo.getVersion());

    public static synchronized HBaseInfo init() {
        if (theInstance == null) {
            theInstance = new HBaseInfo();
        }
        return theInstance;
    }

    protected HBaseInfo() {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.mr = MetricsUtil.createRecord((MetricsContext)context, (String)"info");
        String name = Thread.currentThread().getName();
        this.mr.setTag("Info", name);
        this.mbean = new HBaseInfoMBean(this.registry, name);
    }

    protected static class HBaseInfoMBean
    extends MetricsMBeanBase {
        private final ObjectName mbeanName = MBeanUtil.registerMBean((String)"HBase", (String)"Info", (Object)((Object)this));

        public HBaseInfoMBean(MetricsRegistry registry, String rsName) {
            super(registry, "HBase cluster information");
        }

        public void shutdown() {
            if (this.mbeanName != null) {
                MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
            }
        }
    }
}

