/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class Compactor
extends Configured {
    private static final Log LOG = LogFactory.getLog(Compactor.class);
    private CompactionProgress progress;

    Compactor(Configuration c) {
        super(c);
    }

    public StoreFile.Writer compactForTesting(Store store, Configuration conf, Collection<StoreFile> filesToCompact, boolean isMajor, long maxId) throws IOException {
        return this.compact(CompactionRequest.getRequestForTesting(store, conf, filesToCompact, isMajor), maxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreFile.Writer compact(CompactionRequest request, long maxId) throws IOException {
        int maxKeyCount = 0;
        long earliestPutTs = Long.MAX_VALUE;
        Store store = request.getStore();
        boolean majorCompaction = request.isMajor();
        List<StoreFile> filesToCompact = request.getFiles();
        for (StoreFile file : filesToCompact) {
            StoreFile.Reader r = file.getReader();
            if (r == null) {
                LOG.warn((Object)("Null reader for " + file.getPath()));
                continue;
            }
            long keyCount = r.getBloomFilterType() == store.getFamily().getBloomFilterType() ? r.getFilterEntries() : r.getEntries();
            maxKeyCount = (int)((long)maxKeyCount + keyCount);
            if (majorCompaction) {
                byte[] tmp = r.loadFileInfo().get(StoreFile.EARLIEST_PUT_TS);
                earliestPutTs = tmp == null ? Long.MIN_VALUE : Math.min(earliestPutTs, Bytes.toLong(tmp));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Compacting " + file + ", keycount=" + keyCount + ", bloomtype=" + r.getBloomFilterType().toString() + ", size=" + StringUtils.humanReadableInt((long)r.length()) + ", encoding=" + (Object)((Object)r.getHFileReader().getEncodingOnDisk()) + (majorCompaction ? ", earliestPutTs=" + earliestPutTs : "")));
        }
        this.progress = new CompactionProgress(maxKeyCount);
        int compactionKVMax = this.getConf().getInt("hbase.hstore.compaction.kv.max", 10);
        Compression.Algorithm compression = store.getFamily().getCompression();
        Compression.Algorithm compactionCompression = store.getFamily().getCompactionCompression() != Compression.Algorithm.NONE ? store.getFamily().getCompactionCompression() : compression;
        List<StoreFileScanner> scanners = StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, false, true);
        StoreFile.Writer writer = null;
        long smallestReadPoint = store.getHRegion().getSmallestReadPoint();
        MultiVersionConsistencyControl.setThreadReadPoint(smallestReadPoint);
        try {
            InternalScanner scanner = null;
            try {
                boolean hasMore;
                if (store.getHRegion().getCoprocessorHost() != null) {
                    scanner = store.getHRegion().getCoprocessorHost().preCompactScannerOpen(store, scanners, majorCompaction ? ScanType.MAJOR_COMPACT : ScanType.MINOR_COMPACT, earliestPutTs, request);
                }
                if (scanner == null) {
                    Scan scan = new Scan();
                    scan.setMaxVersions(store.getFamily().getMaxVersions());
                    scanner = new StoreScanner(store, store.getScanInfo(), scan, scanners, majorCompaction ? ScanType.MAJOR_COMPACT : ScanType.MINOR_COMPACT, smallestReadPoint, earliestPutTs);
                }
                if (store.getHRegion().getCoprocessorHost() != null) {
                    InternalScanner cpScanner = store.getHRegion().getCoprocessorHost().preCompact(store, scanner, request);
                    if (cpScanner == null) {
                        StoreFile.Writer writer2 = null;
                        return writer2;
                    }
                    scanner = cpScanner;
                }
                int bytesWritten = 0;
                ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                do {
                    hasMore = scanner.next(kvs, compactionKVMax);
                    if (writer == null && !kvs.isEmpty()) {
                        writer = store.createWriterInTmp(maxKeyCount, compactionCompression, true);
                    }
                    if (writer != null) {
                        for (KeyValue kv : kvs) {
                            if (kv.getMemstoreTS() <= smallestReadPoint) {
                                kv.setMemstoreTS(0L);
                            }
                            writer.append(kv);
                            ++this.progress.currentCompactedKVs;
                            if (Store.closeCheckInterval <= 0 || (bytesWritten += kv.getLength()) <= Store.closeCheckInterval) continue;
                            bytesWritten = 0;
                            this.isInterrupted(store, writer);
                        }
                    }
                    kvs.clear();
                } while (hasMore);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.appendMetadata(maxId, majorCompaction);
                writer.close();
            }
        }
        return writer;
    }

    void isInterrupted(Store store, StoreFile.Writer writer) throws IOException {
        if (store.getHRegion().areWritesEnabled()) {
            return;
        }
        writer.close();
        store.getFileSystem().delete(writer.getPath(), false);
        throw new InterruptedIOException("Aborting compaction of store " + store + " in region " + store.getHRegion() + " because user requested stop.");
    }

    CompactionProgress getProgress() {
        return this.progress;
    }
}

