/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.UnexpectedException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

public class MemStore
implements HeapSize {
    private static final Log LOG = LogFactory.getLog(MemStore.class);
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    private static final boolean USEMSLAB_DEFAULT = true;
    private Configuration conf;
    volatile KeyValueSkipListSet kvset;
    volatile KeyValueSkipListSet snapshot;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final KeyValue.KVComparator comparator;
    final KeyValue.KVComparator comparatorIgnoreType;
    final KeyValue.KVComparator comparatorIgnoreTimestamp;
    final AtomicLong size;
    TimeRangeTracker timeRangeTracker;
    TimeRangeTracker snapshotTimeRangeTracker;
    MemStoreLAB allocator;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 11 * ClassSize.REFERENCE);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.ATOMIC_LONG + (long)ClassSize.COPYONWRITE_ARRAYSET + (long)ClassSize.COPYONWRITE_ARRAYLIST + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP));
    public static final boolean NO_PERSISTENT_TS = false;

    public MemStore() {
        this(HBaseConfiguration.create(), KeyValue.COMPARATOR);
    }

    public MemStore(Configuration conf, KeyValue.KVComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.comparatorIgnoreTimestamp = this.comparator.getComparatorIgnoringTimestamps();
        this.comparatorIgnoreType = this.comparator.getComparatorIgnoringType();
        this.kvset = new KeyValueSkipListSet(c);
        this.snapshot = new KeyValueSkipListSet(c);
        this.timeRangeTracker = new TimeRangeTracker();
        this.snapshotTimeRangeTracker = new TimeRangeTracker();
        this.size = new AtomicLong(DEEP_OVERHEAD);
        this.allocator = conf.getBoolean(USEMSLAB_KEY, true) ? new MemStoreLAB(conf) : null;
    }

    void dump() {
        for (KeyValue kv : this.kvset) {
            LOG.info((Object)kv);
        }
        for (KeyValue kv : this.snapshot) {
            LOG.info((Object)kv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() {
        this.lock.writeLock().lock();
        try {
            if (!this.snapshot.isEmpty()) {
                LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
            } else if (!this.kvset.isEmpty()) {
                this.snapshot = this.kvset;
                this.kvset = new KeyValueSkipListSet(this.comparator);
                this.snapshotTimeRangeTracker = this.timeRangeTracker;
                this.timeRangeTracker = new TimeRangeTracker();
                this.size.set(DEEP_OVERHEAD);
                if (this.allocator != null) {
                    this.allocator = new MemStoreLAB(this.conf);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    KeyValueSkipListSet getSnapshot() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSnapshot(SortedSet<KeyValue> ss) throws UnexpectedException {
        this.lock.writeLock().lock();
        try {
            if (this.snapshot != ss) {
                throw new UnexpectedException("Current snapshot is " + this.snapshot + ", was passed " + ss);
            }
            if (!ss.isEmpty()) {
                this.snapshot = new KeyValueSkipListSet(this.comparator);
                this.snapshotTimeRangeTracker = new TimeRangeTracker();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long add(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            KeyValue toAdd = this.maybeCloneWithAllocator(kv);
            long l = this.internalAdd(toAdd);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private long internalAdd(KeyValue toAdd) {
        long s = this.heapSizeChange(toAdd, this.kvset.add(toAdd));
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s);
        return s;
    }

    private KeyValue maybeCloneWithAllocator(KeyValue kv) {
        if (this.allocator == null) {
            return kv;
        }
        int len = kv.getLength();
        MemStoreLAB.Allocation alloc = this.allocator.allocateBytes(len);
        if (alloc == null) {
            return kv;
        }
        assert (alloc != null && alloc.getData() != null);
        System.arraycopy(kv.getBuffer(), kv.getOffset(), alloc.getData(), alloc.getOffset(), len);
        KeyValue newKv = new KeyValue(alloc.getData(), alloc.getOffset(), len);
        newKv.setMemstoreTS(kv.getMemstoreTS());
        return newKv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            KeyValue found = this.snapshot.get(kv);
            if (found != null && found.getMemstoreTS() == kv.getMemstoreTS()) {
                this.snapshot.remove(kv);
            }
            if ((found = this.kvset.get(kv)) != null && found.getMemstoreTS() == kv.getMemstoreTS()) {
                this.kvset.remove(kv);
                long s = this.heapSizeChange(kv, true);
                this.size.addAndGet(-s);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long delete(KeyValue delete) {
        KeyValue toAdd;
        long s = 0L;
        this.lock.readLock().lock();
        try {
            toAdd = this.maybeCloneWithAllocator(delete);
            this.timeRangeTracker.includeTimestamp(toAdd);
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.size.addAndGet(s += this.heapSizeChange(toAdd, this.kvset.add(toAdd)));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValue getNextRow(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            KeyValue keyValue = this.getLowest(this.getNextRow(kv, this.kvset), this.getNextRow(kv, this.snapshot));
            return keyValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private KeyValue getLowest(KeyValue a, KeyValue b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private KeyValue getNextRow(KeyValue key, NavigableSet<KeyValue> set) {
        KeyValue result = null;
        NavigableSet<KeyValue> tail = key == null ? set : set.tailSet(key);
        for (KeyValue kv : tail) {
            if (this.comparator.compareRows(kv, key) <= 0) continue;
            result = kv;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.lock.readLock().lock();
        try {
            this.getRowKeyAtOrBefore(this.kvset, state);
            this.getRowKeyAtOrBefore(this.snapshot, state);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void getRowKeyAtOrBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<KeyValue> set, KeyValue firstOnRow, GetClosestRowBeforeTracker state) {
        KeyValue kv;
        boolean foundCandidate = false;
        SortedSet<KeyValue> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (KeyValue)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, firstOnRow);
        while (p != null && state.isTargetTable(p.kv) && state.isBetterCandidate(p.kv) && !this.walkForwardInSingleRow(p.set, firstOnRow = new KeyValue(p.kv.getRow(), Long.MAX_VALUE), state)) {
            p = this.memberOfPreviousRow(p.set, state, firstOnRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        this.lock.readLock().lock();
        try {
            KeyValue kv;
            KeyValue snKv;
            KeyValue firstKv = KeyValue.createFirstOnRow(row, family, qualifier);
            SortedSet<KeyValue> snSs = this.snapshot.tailSet(firstKv);
            if (!snSs.isEmpty() && (snKv = snSs.first()).matchingRow(firstKv) && snKv.matchingQualifier(firstKv) && snKv.getTimestamp() == now) {
                ++now;
            }
            SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
            Iterator it = ss.iterator();
            while (it.hasNext() && (kv = (KeyValue)it.next()).matchingColumn(family, qualifier) && kv.matchingRow(firstKv)) {
                if (kv.getType() != KeyValue.Type.Put.getCode() || kv.getTimestamp() <= now || !firstKv.matchingQualifier(kv)) continue;
                now = kv.getTimestamp();
            }
            long l = this.upsert(Arrays.asList(new KeyValue(row, family, qualifier, now, Bytes.toBytes(newValue))));
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long upsert(List<KeyValue> kvs) {
        this.lock.readLock().lock();
        try {
            long size = 0L;
            for (KeyValue kv : kvs) {
                kv.setMemstoreTS(0L);
                size += this.upsert(kv);
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private long upsert(KeyValue kv) {
        long addedSize = this.internalAdd(kv);
        KeyValue firstKv = KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
        Iterator it = ss.iterator();
        while (it.hasNext()) {
            KeyValue cur = (KeyValue)it.next();
            if (kv == cur) continue;
            if (!kv.matchingRow(cur) || !kv.matchingQualifier(cur)) break;
            if (kv.getType() != KeyValue.Type.Put.getCode() || kv.getMemstoreTS() != 0L) continue;
            long delta = this.heapSizeChange(cur, true);
            addedSize -= delta;
            this.size.addAndGet(-delta);
            it.remove();
        }
        return addedSize;
    }

    private Member memberOfPreviousRow(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state, KeyValue firstOnRow) {
        NavigableSet<KeyValue> head = set.headSet(firstOnRow, false);
        if (head.isEmpty()) {
            return null;
        }
        Iterator<KeyValue> i = head.descendingIterator();
        while (i.hasNext()) {
            KeyValue found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head, found);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<KeyValueScanner> getScanners() {
        this.lock.readLock().lock();
        try {
            List<KeyValueScanner> list = Collections.singletonList(new MemStoreScanner());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean shouldSeek(Scan scan, long oldestUnexpiredTS) {
        return (this.timeRangeTracker.includesTimeRange(scan.getTimeRange()) || this.snapshotTimeRangeTracker.includesTimeRange(scan.getTimeRange())) && Math.max(this.timeRangeTracker.getMaximumTimestamp(), this.snapshotTimeRangeTracker.getMaximumTimestamp()) >= oldestUnexpiredTS;
    }

    public TimeRangeTracker getSnapshotTimeRangeTracker() {
        return this.snapshotTimeRangeTracker;
    }

    long heapSizeChange(KeyValue kv, boolean notpresent) {
        return notpresent ? ClassSize.align((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()) : 0L;
    }

    @Override
    public long heapSize() {
        return this.size.get();
    }

    public long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        MemStore memstore1 = new MemStore();
        long size = 0L;
        int count = 10000;
        byte[] fam = Bytes.toBytes("col");
        byte[] qf = Bytes.toBytes("umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        MemStore memstore2 = new MemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size += memstore2.add(new KeyValue(Bytes.toBytes(i2), fam, qf, (long)i2, new byte[i2]));
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info((Object)"Exiting.");
    }

    protected class MemStoreScanner
    extends NonLazyKeyValueScanner {
        private KeyValue kvsetNextRow = null;
        private KeyValue snapshotNextRow = null;
        private KeyValue kvsetItRow = null;
        private KeyValue snapshotItRow = null;
        private Iterator<KeyValue> kvsetIt;
        private Iterator<KeyValue> snapshotIt;
        volatile KeyValueSkipListSet kvsetAtCreation;
        volatile KeyValueSkipListSet snapshotAtCreation;
        private KeyValue theNext;

        MemStoreScanner() {
            this.kvsetAtCreation = MemStore.this.kvset;
            this.snapshotAtCreation = MemStore.this.snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyValue getNext(Iterator<KeyValue> it) {
            long readPoint = MultiVersionConsistencyControl.getThreadReadPoint();
            KeyValue v = null;
            try {
                while (it.hasNext()) {
                    v = it.next();
                    if (v.getMemstoreTS() > readPoint) continue;
                    KeyValue keyValue = v;
                    return keyValue;
                }
                KeyValue keyValue = null;
                return keyValue;
            }
            finally {
                if (v != null) {
                    if (it == this.snapshotIt) {
                        this.snapshotItRow = v;
                    } else {
                        this.kvsetItRow = v;
                    }
                }
            }
        }

        @Override
        public synchronized boolean seek(KeyValue key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.kvsetIt = this.kvsetAtCreation.tailSet(key).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(key).iterator();
            this.kvsetItRow = null;
            this.snapshotItRow = null;
            return this.seekInSubLists(key);
        }

        private synchronized boolean seekInSubLists(KeyValue key) {
            this.kvsetNextRow = this.getNext(this.kvsetIt);
            this.snapshotNextRow = this.getNext(this.snapshotIt);
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return this.theNext != null;
        }

        @Override
        public synchronized boolean reseek(KeyValue key) {
            this.kvsetIt = this.kvsetAtCreation.tailSet(this.getHighest(key, this.kvsetItRow)).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(this.getHighest(key, this.snapshotItRow)).iterator();
            return this.seekInSubLists(key);
        }

        @Override
        public synchronized KeyValue peek() {
            return this.theNext;
        }

        @Override
        public synchronized KeyValue next() {
            if (this.theNext == null) {
                return null;
            }
            KeyValue ret = this.theNext;
            if (this.theNext == this.kvsetNextRow) {
                this.kvsetNextRow = this.getNext(this.kvsetIt);
            } else {
                this.snapshotNextRow = this.getNext(this.snapshotIt);
            }
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return ret;
        }

        private KeyValue getLowest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = MemStore.this.comparator.compare(first, second);
                return compare <= 0 ? first : second;
            }
            return first != null ? first : second;
        }

        private KeyValue getHighest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = MemStore.this.comparator.compare(first, second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized void close() {
            this.kvsetNextRow = null;
            this.snapshotNextRow = null;
            this.kvsetIt = null;
            this.snapshotIt = null;
            this.kvsetItRow = null;
            this.snapshotItRow = null;
        }

        @Override
        public long getSequenceID() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean shouldUseScanner(Scan scan, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
            return MemStore.this.shouldSeek(scan, oldestUnexpiredTS);
        }
    }

    private static class Member {
        final KeyValue kv;
        final NavigableSet<KeyValue> set;

        Member(NavigableSet<KeyValue> s, KeyValue kv) {
            this.kv = kv;
            this.set = s;
        }
    }
}

