/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class HLogKey
implements WritableComparable<HLogKey> {
    private static final Version VERSION = Version.COMPRESSED;
    private byte[] encodedRegionName;
    private byte[] tablename;
    private long logSeqNum;
    private long writeTime;
    private UUID clusterId;
    private CompressionContext compressionContext;

    public HLogKey() {
        this(null, null, 0L, Long.MAX_VALUE, HConstants.DEFAULT_CLUSTER_ID);
    }

    public HLogKey(byte[] encodedRegionName, byte[] tablename, long logSeqNum, long now, UUID clusterId) {
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterId = clusterId;
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public byte[] getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    void setLogSeqNum(long logSeqNum) {
        this.logSeqNum = logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(UUID clusterId) {
        this.clusterId = clusterId;
    }

    public String toString() {
        return Bytes.toString(this.tablename) + "/" + Bytes.toString(this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", Bytes.toStringBinary(this.tablename));
        stringMap.put("region", Bytes.toStringBinary(this.encodedRegionName));
        stringMap.put("sequence", this.logSeqNum);
        return stringMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.encodedRegionName);
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result ^= this.clusterId.hashCode();
    }

    public int compareTo(HLogKey o) {
        int result = Bytes.compareTo(this.encodedRegionName, o.encodedRegionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    void internTableName(byte[] tablename) {
        assert (Bytes.equals(tablename, this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals(this.encodedRegionName, encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)HLogKey.VERSION.code);
        if (this.compressionContext == null) {
            Bytes.writeByteArray(out, this.encodedRegionName);
            Bytes.writeByteArray(out, this.tablename);
        } else {
            Compressor.writeCompressed(this.encodedRegionName, 0, this.encodedRegionName.length, out, this.compressionContext.regionDict);
            Compressor.writeCompressed(this.tablename, 0, this.tablename.length, out, this.compressionContext.tableDict);
        }
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        if (this.clusterId == HConstants.DEFAULT_CLUSTER_ID) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.clusterId.getMostSignificantBits());
            out.writeLong(this.clusterId.getLeastSignificantBits());
        }
    }

    public void readFields(DataInput in) throws IOException {
        Version version = Version.UNVERSIONED;
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            version = Version.fromCode(len);
            if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
                len = WritableUtils.readVInt((DataInput)in);
            }
        }
        if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
            this.encodedRegionName = new byte[len];
            in.readFully(this.encodedRegionName);
            this.tablename = Bytes.readByteArray(in);
        } else {
            this.encodedRegionName = Compressor.readCompressed(in, this.compressionContext.regionDict);
            this.tablename = Compressor.readCompressed(in, this.compressionContext.tableDict);
        }
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
        this.clusterId = HConstants.DEFAULT_CLUSTER_ID;
        if (version.atLeast(Version.INITIAL)) {
            if (in.readBoolean()) {
                this.clusterId = new UUID(in.readLong(), in.readLong());
            }
        } else {
            try {
                in.readByte();
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    static enum Version {
        UNVERSIONED(0),
        INITIAL(-1),
        COMPRESSED(-2);

        final int code;
        static final Version[] byCode;

        private Version(int code) {
            this.code = code;
        }

        boolean atLeast(Version other) {
            return this.code <= other.code;
        }

        static Version fromCode(int code) {
            return byCode[code * -1];
        }

        static {
            byCode = Version.values();
            for (int i = 0; i < byCode.length; ++i) {
                if (Version.byCode[i].code != -1 * i) {
                    throw new AssertionError((Object)"Values in this enum should be descending by one");
                }
            }
        }
    }
}

