/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

public class SequenceFileLogWriter
implements HLog.Writer {
    static final Text WAL_VERSION_KEY = new Text("version");
    private static final int COMPRESSION_VERSION = 1;
    static final int VERSION = 1;
    static final Text WAL_VERSION = new Text("1");
    static final Text WAL_COMPRESSION_TYPE_KEY = new Text("compression.type");
    static final Text DICTIONARY_COMPRESSION_TYPE = new Text("dictionary");
    private final Log LOG = LogFactory.getLog(this.getClass());
    private SequenceFile.Writer writer;
    private FSDataOutputStream writer_out;
    private Class<? extends HLogKey> keyClass;
    private CompressionContext compressionContext;
    private Method syncFs = null;
    private Method hflush = null;

    public SequenceFileLogWriter() {
    }

    public SequenceFileLogWriter(Class<? extends HLogKey> keyClass) {
        this.keyClass = keyClass;
    }

    private static SequenceFile.Metadata createMetadata(Configuration conf, boolean compress) {
        TreeMap<Text, Text> metaMap = new TreeMap<Text, Text>();
        metaMap.put(WAL_VERSION_KEY, WAL_VERSION);
        if (compress) {
            metaMap.put(WAL_COMPRESSION_TYPE_KEY, DICTIONARY_COMPRESSION_TYPE);
        }
        return new SequenceFile.Metadata(metaMap);
    }

    static boolean isWALCompressionEnabled(SequenceFile.Metadata metadata) {
        Text txt = metadata.get(WAL_VERSION_KEY);
        if (txt == null || Integer.parseInt(txt.toString()) < 1) {
            return false;
        }
        txt = metadata.get(WAL_COMPRESSION_TYPE_KEY);
        return txt != null && txt.equals((Object)DICTIONARY_COMPRESSION_TYPE);
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf) throws IOException {
        boolean compress = conf.getBoolean("hbase.regionserver.wal.enablecompression", false);
        if (compress) {
            try {
                if (this.compressionContext == null) {
                    this.compressionContext = new CompressionContext(LRUDictionary.class);
                } else {
                    this.compressionContext.clear();
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to initiate CompressionContext", e);
            }
        }
        if (null == this.keyClass) {
            this.keyClass = HLog.getKeyClass(conf);
        }
        try {
            this.writer = (SequenceFile.Writer)SequenceFile.class.getMethod("createWriter", FileSystem.class, Configuration.class, Path.class, Class.class, Class.class, Integer.TYPE, Short.TYPE, Long.TYPE, Boolean.TYPE, SequenceFile.CompressionType.class, CompressionCodec.class, SequenceFile.Metadata.class).invoke(null, fs, conf, path, HLog.getKeyClass(conf), WALEdit.class, fs.getConf().getInt("io.file.buffer.size", 4096), (short)conf.getInt("hbase.regionserver.hlog.replication", (int)fs.getDefaultReplication()), conf.getLong("hbase.regionserver.hlog.blocksize", fs.getDefaultBlockSize()), false, SequenceFile.CompressionType.NONE, new DefaultCodec(), SequenceFileLogWriter.createMetadata(conf, compress));
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getCause());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.writer == null) {
            this.LOG.debug((Object)"new createWriter -- HADOOP-6840 -- not available");
            this.writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, HLog.getKeyClass(conf), WALEdit.class, (int)fs.getConf().getInt("io.file.buffer.size", 4096), (short)((short)conf.getInt("hbase.regionserver.hlog.replication", (int)fs.getDefaultReplication())), (long)conf.getLong("hbase.regionserver.hlog.blocksize", fs.getDefaultBlockSize()), (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)new DefaultCodec(), null, (SequenceFile.Metadata)SequenceFileLogWriter.createMetadata(conf, compress));
        } else {
            this.LOG.debug((Object)"using new createWriter -- HADOOP-6840");
        }
        this.writer_out = this.getSequenceFilePrivateFSDataOutputStreamAccessible();
        this.syncFs = this.getSyncFs();
        this.hflush = this.getHFlush();
        String msg = "Path=" + path + ", syncFs=" + (this.syncFs != null) + ", hflush=" + (this.hflush != null) + ", compression=" + compress;
        if (this.syncFs != null || this.hflush != null) {
            this.LOG.debug((Object)msg);
        } else {
            this.LOG.warn((Object)("No sync support! " + msg));
        }
    }

    private Method getSyncFs() throws IOException {
        Method m = null;
        try {
            m = this.writer.getClass().getMethod("syncFs", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for syncfs", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    private Method getHFlush() throws IOException {
        Method m = null;
        try {
            Class<?> c = this.getWriterFSDataOutputStream().getClass();
            m = c.getMethod("hflush", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for hflush", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    private FSDataOutputStream getSequenceFilePrivateFSDataOutputStreamAccessible() throws IOException {
        FSDataOutputStream out = null;
        Field[] fields = this.writer.getClass().getDeclaredFields();
        String fieldName = "out";
        for (int i = 0; i < fields.length; ++i) {
            if (!"out".equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                out = (FSDataOutputStream)fields[i].get(this.writer);
                break;
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Accessing out", ex);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    @Override
    public void append(HLog.Entry entry) throws IOException {
        entry.setCompressionContext(this.compressionContext);
        try {
            this.writer.append((Writable)entry.getKey(), (Writable)entry.getEdit());
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (NullPointerException npe) {
                this.LOG.warn((Object)npe);
            }
            this.writer = null;
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.syncFs != null) {
            try {
                this.syncFs.invoke((Object)this.writer, HLog.NO_ARGS);
            }
            catch (Exception e) {
                throw new IOException("Reflection", e);
            }
        }
        if (this.hflush != null) {
            try {
                this.hflush.invoke((Object)this.getWriterFSDataOutputStream(), HLog.NO_ARGS);
            }
            catch (Exception e) {
                throw new IOException("Reflection", e);
            }
        }
    }

    @Override
    public long getLength() throws IOException {
        try {
            return this.writer.getLength();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    public FSDataOutputStream getWriterFSDataOutputStream() {
        return this.writer_out;
    }
}

