/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationLogCleaner
extends BaseLogCleanerDelegate
implements Abortable {
    private static final Log LOG = LogFactory.getLog(ReplicationLogCleaner.class);
    private ReplicationZookeeper zkHelper;
    private Set<String> hlogs = new HashSet<String>();
    private boolean stopped = false;
    private boolean aborted;

    @Override
    public boolean isLogDeletable(Path filePath) {
        try {
            if (!this.zkHelper.getReplication()) {
                return false;
            }
        }
        catch (KeeperException e) {
            this.abort("Cannot get the state of replication", e);
            return false;
        }
        if (this.getConf() == null) {
            return true;
        }
        String log = filePath.getName();
        if (this.hlogs.contains(log)) {
            return false;
        }
        return !this.refreshHLogsAndSearch(log);
    }

    private boolean refreshHLogsAndSearch(String searchedLog) {
        this.hlogs.clear();
        boolean lookForLog = searchedLog != null;
        List<String> rss = this.zkHelper.getListOfReplicators();
        if (rss == null) {
            LOG.debug((Object)("Didn't find any region server that replicates, deleting: " + searchedLog));
            return false;
        }
        for (String rs : rss) {
            List<String> listOfPeers = this.zkHelper.getListPeersForRS(rs);
            if (listOfPeers == null) continue;
            for (String id : listOfPeers) {
                List<String> peersHlogs = this.zkHelper.getListHLogsForPeerForRS(rs, id);
                if (peersHlogs != null) {
                    this.hlogs.addAll(peersHlogs);
                }
                if (!lookForLog || !this.hlogs.contains(searchedLog)) continue;
                LOG.debug((Object)("Found log in ZK, keeping: " + searchedLog));
                return true;
            }
        }
        LOG.debug((Object)("Didn't find this log in ZK, deleting: " + searchedLog));
        return false;
    }

    @Override
    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", false)) {
            return;
        }
        Configuration conf = new Configuration(config);
        super.setConf(conf);
        try {
            ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "replicationLogCleaner", null);
            this.zkHelper = new ReplicationZookeeper(this, conf, zkw);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
        this.refreshHLogsAndSearch(null);
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkHelper != null) {
            LOG.info((Object)("Stopping " + this.zkHelper.getZookeeperWatcher()));
            this.zkHelper.getZookeeperWatcher().close();
        }
        HConnectionManager.deleteConnection(this.getConf());
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.warn((Object)("Aborting ReplicationLogCleaner because " + why), e);
        this.aborted = true;
        this.stop(why);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }
}

