/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.util.Bytes;

public class RemoteAdmin {
    final Client client;
    final Configuration conf;
    final String accessToken;
    final int maxRetries;
    final long sleepTime;

    public RemoteAdmin(Client client, Configuration conf) {
        this(client, conf, null);
    }

    public RemoteAdmin(Client client, Configuration conf, String accessToken) {
        this.client = client;
        this.conf = conf;
        this.accessToken = accessToken;
        this.maxRetries = conf.getInt("hbase.rest.client.max.retries", 10);
        this.sleepTime = conf.getLong("hbase.rest.client.sleep", 1000L);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(Bytes.toBytes(tableName));
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(tableName));
        sb.append('/');
        sb.append("exists");
        int code = 0;
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(sb.toString());
            code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 404: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block7;
                }
                default: {
                    throw new IOException("exists request returned " + code);
                }
            }
        }
        throw new IOException("exists request timed out");
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        TableSchemaModel model = new TableSchemaModel(desc);
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(desc.getName()));
        sb.append('/');
        sb.append("schema");
        int code = 0;
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            code = response.getCode();
            switch (code) {
                case 201: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                default: {
                    throw new IOException("create request returned " + code);
                }
            }
        }
        throw new IOException("create request timed out");
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes(tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(tableName));
        sb.append('/');
        sb.append("schema");
        int code = 0;
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.delete(sb.toString());
            code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                default: {
                    throw new IOException("delete request returned " + code);
                }
            }
        }
        throw new IOException("delete request timed out");
    }
}

