/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MurmurHash;

public abstract class Hash {
    public static final int INVALID_HASH = -1;
    public static final int JENKINS_HASH = 0;
    public static final int MURMUR_HASH = 1;

    public static int parseHashType(String name) {
        if ("jenkins".equalsIgnoreCase(name)) {
            return 0;
        }
        if ("murmur".equalsIgnoreCase(name)) {
            return 1;
        }
        return -1;
    }

    public static int getHashType(Configuration conf) {
        String name = conf.get("hbase.hash.type", "murmur");
        return Hash.parseHashType(name);
    }

    public static Hash getInstance(int type) {
        switch (type) {
            case 0: {
                return JenkinsHash.getInstance();
            }
            case 1: {
                return MurmurHash.getInstance();
            }
        }
        return null;
    }

    public static Hash getInstance(Configuration conf) {
        int type = Hash.getHashType(conf);
        return Hash.getInstance(type);
    }

    public int hash(byte[] bytes) {
        return this.hash(bytes, bytes.length, -1);
    }

    public int hash(byte[] bytes, int initval) {
        return this.hash(bytes, 0, bytes.length, initval);
    }

    public int hash(byte[] bytes, int length, int initval) {
        return this.hash(bytes, 0, length, initval);
    }

    public abstract int hash(byte[] var1, int var2, int var3, int var4);
}

