/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKTable {
    private static final Log LOG = LogFactory.getLog(ZKTable.class);
    private final ZooKeeperWatcher watcher;
    private final Map<String, TableState> cache = new HashMap<String, TableState>();

    public ZKTable(ZooKeeperWatcher zkw) throws KeeperException {
        this.watcher = zkw;
        this.populateTableStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableStates() throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.masterTableZNode);
            if (children == null) {
                return;
            }
            for (String child : children) {
                TableState state = ZKTable.getTableState(this.watcher, child);
                if (state == null) continue;
                this.cache.put(child, state);
            }
        }
    }

    private static TableState getTableState(ZooKeeperWatcher zkw, String child) throws KeeperException {
        return ZKTableReadOnly.getTableState(zkw, zkw.masterTableZNode, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabledTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isDisablingOrDisabledTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabled but was " + "not first in disabling state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isEnabledOrDisablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabling but was " + "not first in enabled state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.DISABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledOrEnablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to enabling but was " + "not first in disabled state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.ENABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndSetEnablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (this.isEnablingTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, TableState.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDisabledAndSetEnablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, TableState.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEnabledAndSetDisablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (this.cache.get(tableName) != null && !this.isEnabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, TableState.DISABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableState(String tableName, TableState state) throws KeeperException {
        boolean settingToEnabled;
        String znode = ZKUtil.joinZNode(this.watcher.masterTableZNode, tableName);
        if (ZKUtil.checkExists(this.watcher, znode) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode);
        }
        String znode92 = ZKUtil.joinZNode(this.watcher.masterTableZNode92, tableName);
        boolean bl = settingToEnabled = state == TableState.ENABLED;
        if (!settingToEnabled && ZKUtil.checkExists(this.watcher, znode92) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode92);
        }
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
            if (settingToEnabled) {
                ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(znode92));
            } else {
                ops.add(ZKUtil.ZKUtilOp.setData(znode92, Bytes.toBytes(state.toString())));
            }
            ops.add(ZKUtil.ZKUtilOp.setData(znode, Bytes.toBytes(state.toString())));
            ZKUtil.multiOrSequential(this.watcher, ops, true);
            this.cache.put(tableName, state);
        }
    }

    public boolean isDisabledTable(String tableName) {
        return this.isTableState(tableName, TableState.DISABLED);
    }

    public boolean isDisablingTable(String tableName) {
        return this.isTableState(tableName, TableState.DISABLING);
    }

    public boolean isEnablingTable(String tableName) {
        return this.isTableState(tableName, TableState.ENABLING);
    }

    public boolean isEnabledTable(String tableName) {
        return this.isTableState(tableName, TableState.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisablingOrDisabledTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isDisablingTable(tableName) || this.isDisabledTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabledOrDisablingTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isEnabledTable(tableName) || this.isDisablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabledOrEnablingTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isDisabledTable(tableName) || this.isEnablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableState(String tableName, TableState state) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            TableState currentState = this.cache.get(tableName);
            return ZKTableReadOnly.isTableState(currentState, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeletedTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
            ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(ZKUtil.joinZNode(this.watcher.masterTableZNode92, tableName)));
            ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(ZKUtil.joinZNode(this.watcher.masterTableZNode, tableName)));
            ZKUtil.multiOrSequential(this.watcher, ops, true);
            if (this.cache.remove(tableName) == null) {
                LOG.warn((Object)("Moving table " + tableName + " state to deleted but was " + "already deleted"));
            }
        }
    }

    public void setEnabledTable(String tableName) throws KeeperException {
        this.setTableState(tableName, TableState.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            TableState state = this.cache.get(tableName);
            return state != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDisabledTables() {
        HashSet<String> disabledTables = new HashSet<String>();
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            Set<String> tables = this.cache.keySet();
            for (String table : tables) {
                if (!this.isDisabledTable(table)) continue;
                disabledTables.add(table);
            }
        }
        return disabledTables;
    }

    public static enum TableState {
        ENABLED,
        DISABLED,
        DISABLING,
        ENABLING;

    }
}

