/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;

public class ZooKeeperMainServerArg {
    public String parse(Configuration c) {
        Properties zkProps = ZKConfig.makeZKProps(c);
        String host = null;
        String clientPort = null;
        ArrayList<String> hosts = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.startsWith("server.")) {
                String[] parts = value.split(":");
                hosts.add(parts[0]);
                continue;
            }
            if (!key.endsWith("clientPort")) continue;
            clientPort = value;
        }
        if (hosts.isEmpty() || clientPort == null) {
            return null;
        }
        for (int i = 0; i < hosts.size(); ++i) {
            host = i > 0 ? host + "," + (String)hosts.get(i) : (String)hosts.get(i);
        }
        return host != null ? host + ":" + clientPort : null;
    }

    public static void main(String[] args) {
        Configuration conf = HBaseConfiguration.create();
        String hostport = new ZooKeeperMainServerArg().parse(conf);
        System.out.println(hostport == null || hostport.length() == 0 ? "" : "-server " + hostport);
    }
}

