/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.counters.PigCounterHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlgebraicEvalFunc<T>
extends AccumulatorEvalFunc<T>
implements Algebraic {
    private EvalFunc<Tuple> initEvalFunc;
    private EvalFunc<Tuple> intermedEvalFunc;
    private EvalFunc<T> finalEvalFunc;
    private static final BagFactory mBagFactory = BagFactory.getInstance();
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private DataBag intermediateDB;
    private DataBag wrapDB;
    private DataBag accumDB;
    private Tuple argTuple;
    private Tuple accumTup;
    private int bagCombineThreshold = 1000;
    private int combineFactor = 2;
    private PigCounterHelper pigCounterHelper = new PigCounterHelper();
    private boolean combine;
    private String[] constructorArgs;
    private boolean init = false;

    public AlgebraicEvalFunc(String ... constructorArgs) {
        this.constructorArgs = constructorArgs;
    }

    @Override
    public abstract String getFinal();

    @Override
    public abstract String getInitial();

    @Override
    public abstract String getIntermed();

    private EvalFunc<?> makeEvalFunc(String base) {
        StringBuffer sb = new StringBuffer();
        sb.append(base).append("(");
        boolean first = true;
        for (String s : this.constructorArgs) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("'").append(s).append("'");
        }
        sb.append(")");
        return (EvalFunc)PigContext.instantiateFuncFromSpec(sb.toString());
    }

    @Override
    public void accumulate(Tuple input) throws IOException {
        if (!this.init) {
            this.intermediateDB = mBagFactory.newDefaultBag();
            this.wrapDB = mBagFactory.newDefaultBag();
            this.accumDB = mBagFactory.newDefaultBag();
            this.argTuple = mTupleFactory.newTuple(1);
            this.argTuple.set(0, this.wrapDB);
            this.accumTup = mTupleFactory.newTuple(1);
            this.accumTup.set(0, this.accumDB);
            this.initEvalFunc = this.makeEvalFunc(this.getInitial());
            this.intermedEvalFunc = this.makeEvalFunc(this.getIntermed());
            this.finalEvalFunc = this.makeEvalFunc(this.getFinal());
            this.combine = true;
            this.init = true;
        }
        this.accumDB.clear();
        for (Tuple t : (DataBag)input.get(0)) {
            this.wrapDB.clear();
            this.wrapDB.add(t);
            this.accumDB.add(this.initEvalFunc.exec(this.argTuple));
        }
        this.intermediateDB.add(this.intermedEvalFunc.exec(this.accumTup));
        if (this.combine && this.intermediateDB.size() > (long)this.bagCombineThreshold) {
            long initialSizeEstimate = this.intermediateDB.getMemorySize();
            DataBag newIntermediateDB = mBagFactory.newDefaultBag();
            Tuple t = mTupleFactory.newTuple(1);
            t.set(0, this.intermediateDB);
            newIntermediateDB.add(this.intermedEvalFunc.exec(t));
            this.intermediateDB = newIntermediateDB;
            long newSizeEstimate = this.intermediateDB.getMemorySize();
            this.pigCounterHelper.incrCounter("AlgebraicEvalFunc", "InitialSizeEst", initialSizeEstimate);
            this.pigCounterHelper.incrCounter("AlgebraicEvalFunc", "PostCombineSizeEst", newSizeEstimate);
            this.pigCounterHelper.incrCounter("AlgebraicEvalFunc", "CombineApply", 1L);
            if ((long)this.combineFactor * newSizeEstimate > initialSizeEstimate) {
                this.combine = false;
                this.pigCounterHelper.incrCounter("AlgebraicEvalFunc", "CombineShutoff", 1L);
            }
        }
    }

    @Override
    public void cleanup() {
        this.intermediateDB = null;
        this.wrapDB = null;
        this.accumDB = null;
        this.argTuple = null;
        this.accumTup = null;
        this.initEvalFunc = null;
        this.intermedEvalFunc = null;
        this.finalEvalFunc = null;
        this.init = false;
    }

    @Override
    public T getValue() {
        try {
            return this.finalEvalFunc.exec(mTupleFactory.newTuple(this.intermediateDB));
        }
        catch (IOException e) {
            throw new RuntimeException("Error in AlgebraicEvalFunc evaluating final method");
        }
    }
}

