/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.impl.io.NullableBooleanWritable;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigBooleanRawComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean[] mAsc;
    private BooleanWritable.Comparator mWrappedComp = new BooleanWritable.Comparator();

    public PigBooleanRawComparator() {
        super(NullableBooleanWritable.class);
    }

    public void setConf(Configuration conf) {
        if (!(conf instanceof JobConf)) {
            this.mLog.warn((Object)("Expected jobconf in setConf, got " + conf.getClass().getName()));
            return;
        }
        JobConf jconf = (JobConf)conf;
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(jconf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        byte byte2;
        byte byte1;
        int rc = 0;
        rc = b1[s1] == 0 && b2[s2] == 0 ? ((byte1 = b1[s1 + 1]) < (byte2 = b2[s2 + 1]) ? -1 : (byte1 > byte2 ? 1 : 0)) : (b1[s1] != 0 && b2[s2] != 0 ? 0 : (b1[s1] != 0 ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableBooleanWritable nbw1 = (NullableBooleanWritable)o1;
        NullableBooleanWritable nbw2 = (NullableBooleanWritable)o2;
        int rc = 0;
        rc = !nbw1.isNull() && !nbw2.isNull() ? ((Boolean)nbw1.getValueAsPigType()).compareTo((Boolean)nbw2.getValueAsPigType()) : (nbw1.isNull() && nbw2.isNull() ? 0 : (nbw1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

