/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.security.Permission;

public class RunJarSecurityManager
extends SecurityManager {
    private boolean exitInvoked = false;
    private int exitCode;
    private SecurityManager securityManager = null;
    private boolean internal = true;

    public RunJarSecurityManager() {
        if (this.securityManager == null) {
            this.securityManager = System.getSecurityManager();
            System.setSecurityManager(this);
        }
    }

    public void checkPermission(Permission perm) {
        if (this.securityManager != null) {
            this.securityManager.checkPermission(perm);
        }
    }

    public void retire() {
        System.setSecurityManager(this.securityManager);
    }

    public void checkExit(int status) throws SecurityException {
        if (this.internal) {
            this.exitInvoked = true;
            this.exitCode = status;
            this.internal = false;
        }
        throw new SecurityException("Intercepted System.exit(" + status + ")");
    }

    public boolean getExitInvoked() {
        return this.exitInvoked;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

