/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.util;

import java.net.URI;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanHelper {
    private static final Log log = LogFactory.getLog(new PlanHelper().getClass());

    private PlanHelper() {
    }

    public static LinkedList<POStore> getStores(PhysicalPlan plan) throws VisitorException {
        LoadStoreNativeFinder finder = new LoadStoreNativeFinder(plan);
        finder.visit();
        return finder.getStores();
    }

    public static LinkedList<POLoad> getLoads(PhysicalPlan plan) throws VisitorException {
        LoadStoreNativeFinder finder = new LoadStoreNativeFinder(plan);
        finder.visit();
        return finder.getLoads();
    }

    public static LinkedList<PONative> getNativeMRs(PhysicalPlan plan) throws VisitorException {
        LoadStoreNativeFinder finder = new LoadStoreNativeFinder(plan);
        finder.visit();
        return finder.getNativeMRs();
    }

    public static String makeStoreTmpPath(String orig) {
        Path path = new Path(orig);
        URI uri = path.toUri();
        uri.normalize();
        String pathStr = uri.getPath();
        if (path.isAbsolute()) {
            return new Path("abs" + pathStr).toString();
        }
        return new Path("rel/" + pathStr).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadStoreNativeFinder
    extends PhyPlanVisitor {
        private LinkedList<POLoad> loads;
        private LinkedList<POStore> stores = new LinkedList();
        private LinkedList<PONative> nativeMRs;

        LoadStoreNativeFinder(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.loads = new LinkedList();
            this.nativeMRs = new LinkedList();
        }

        @Override
        public void visit() throws VisitorException {
            super.visit();
        }

        @Override
        public void visitStore(POStore st) throws VisitorException {
            super.visitStore(st);
            this.stores.add(st);
        }

        @Override
        public void visitLoad(POLoad load) throws VisitorException {
            super.visitLoad(load);
            this.loads.add(load);
        }

        @Override
        public void visitNative(PONative nativeMR) throws VisitorException {
            super.visitNative(nativeMR);
            this.nativeMRs.add(nativeMR);
        }

        public LinkedList<POStore> getStores() {
            return this.stores;
        }

        public LinkedList<POLoad> getLoads() {
            return this.loads;
        }

        public LinkedList<PONative> getNativeMRs() {
            return this.nativeMRs;
        }
    }
}

