/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.shims;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputCommitter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;

public class HadoopShims {
    public static JobContext cloneJobContext(JobContext original) throws IOException, InterruptedException {
        JobContext newContext = new JobContext(original.getConfiguration(), original.getJobID());
        return newContext;
    }

    public static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        TaskAttemptContext newContext = new TaskAttemptContext(conf, taskId);
        return newContext;
    }

    public static JobContext createJobContext(Configuration conf, JobID jobId) {
        JobContext newJobContext = new JobContext(conf, jobId);
        return newJobContext;
    }

    public static boolean isMap(TaskAttemptID taskAttemptID) {
        return taskAttemptID.isMap();
    }

    public static TaskAttemptID getNewTaskAttemptID() {
        return new TaskAttemptID();
    }

    public static TaskAttemptID createTaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jtIdentifier, jobId, isMap, taskId, id);
    }

    public static void storeSchemaForLocal(Job job, POStore st) throws IOException {
        JobContext jc = HadoopShims.createJobContext((Configuration)job.getJobConf(), new JobID());
        JobContext updatedJc = PigOutputCommitter.setUpContext(jc, st);
        PigOutputCommitter.storeCleanup(st, updatedJc.getConfiguration());
    }

    public static String getFsCounterGroupName() {
        return "FileSystemCounters";
    }

    public static void commitOrCleanup(OutputCommitter oc, JobContext jc) throws IOException {
        oc.cleanupJob(jc);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize();
    }
}

