/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.util.Iterator;
import java.util.Map;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SizeUtil {
    private static final int MAP_MEM_PER_ENTRY = 152;

    public static long getPigObjMemSize(Object o) {
        switch (DataType.findType(o)) {
            case 50: {
                byte[] bytes = ((DataByteArray)o).get();
                long byte_array_sz = SizeUtil.roundToEight(bytes.length + 12);
                return byte_array_sz + 16L;
            }
            case 55: {
                String s = (String)o;
                return SizeUtil.roundToEight(s.length() * 2 + 38);
            }
            case 110: {
                Tuple t = (Tuple)o;
                return t.getMemorySize();
            }
            case 120: {
                DataBag b = (DataBag)o;
                return b.getMemorySize();
            }
            case 10: {
                return 16L;
            }
            case 15: {
                return 16L;
            }
            case 100: {
                Map m = (Map)o;
                Iterator i = m.entrySet().iterator();
                long sum = 0L;
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    sum += SizeUtil.getMapEntrySize(entry.getKey(), entry.getValue());
                }
                return sum;
            }
            case 20: {
                return 16L;
            }
            case 25: {
                return 16L;
            }
            case 5: {
                return 16L;
            }
            case 1: {
                return 0L;
            }
        }
        return 12L;
    }

    public static long getMapEntrySize(Object key, Object value) {
        return SizeUtil.getPigObjMemSize(key) + SizeUtil.getPigObjMemSize(value) + 152L;
    }

    public static long roundToEight(long i) {
        return 8L * ((i + 7L) / 8L);
    }
}

