/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstWalker
extends PlanWalker {
    public DepthFirstWalker(OperatorPlan plan) {
        super(plan);
    }

    @Override
    public PlanWalker spawnChildWalker(OperatorPlan plan) {
        return new DepthFirstWalker(plan);
    }

    @Override
    public void walk(PlanVisitor visitor) throws FrontendException {
        List<Operator> roots = this.plan.getSources();
        HashSet<Operator> seen = new HashSet<Operator>();
        this.depthFirst(null, roots, seen, visitor);
    }

    private void depthFirst(Operator node, Collection<Operator> successors, Set<Operator> seen, PlanVisitor visitor) throws FrontendException {
        if (successors == null) {
            return;
        }
        for (Operator suc : successors) {
            if (!seen.add(suc)) continue;
            suc.accept(visitor);
            Collection<Operator> newSuccessors = Utils.mergeCollection(this.plan.getSuccessors(suc), this.plan.getSoftLinkSuccessors(suc));
            this.depthFirst(suc, newSuccessors, seen, visitor);
        }
    }
}

