/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.DotPlanDumper;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotLOPrinter
extends DotPlanDumper {
    public DotLOPrinter(BaseOperatorPlan plan, PrintStream ps) {
        this(plan, ps, false, new HashSet<Operator>(), new HashSet<Operator>(), new HashSet<Operator>());
    }

    private DotLOPrinter(BaseOperatorPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> subgraphs, Set<Operator> multiInSubgraphs, Set<Operator> multiOutSubgraphs) {
        super(plan, ps, isSubGraph, subgraphs, multiInSubgraphs, multiOutSubgraphs);
    }

    @Override
    protected DotPlanDumper makeDumper(BaseOperatorPlan plan, PrintStream ps) {
        return new DotLOPrinter(plan, ps, true, this.mSubgraphs, this.mMultiInputSubgraphs, this.mMultiOutputSubgraphs);
    }

    @Override
    protected String getName(Operator op) {
        StringBuffer info = new StringBuffer(op.getName());
        if (op instanceof ProjectExpression) {
            ProjectExpression pr = (ProjectExpression)op;
            info.append(pr.getInputNum());
            info.append(":");
            if (pr.isProjectStar()) {
                info.append("(*)");
            } else if (pr.isRangeProject()) {
                info.append("[").append(pr.getStartCol()).append(" .. ").append(pr.getEndCol()).append("]");
            } else {
                info.append(pr.getColNum());
            }
        }
        return info.toString();
    }

    @Override
    protected String[] getAttributes(Operator op) {
        if (op instanceof LOStore || op instanceof LOLoad) {
            String[] attributes = new String[]{"label=\"" + this.getName(op).replace(":", ",\\n") + "\"", "style=\"filled\"", "fillcolor=\"gray\""};
            return attributes;
        }
        return super.getAttributes(op);
    }

    @Override
    protected MultiMap<Operator, BaseOperatorPlan> getMultiInputNestedPlans(Operator op) {
        if (op instanceof LOCogroup) {
            MultiMap<Operator, BaseOperatorPlan> planMap = new MultiMap<Operator, BaseOperatorPlan>();
            for (Integer i : ((LOCogroup)op).getExpressionPlans().keySet()) {
                ArrayList<LogicalExpressionPlan> plans = new ArrayList<LogicalExpressionPlan>();
                plans.addAll(((LOCogroup)op).getExpressionPlans().get(i));
                Operator pred = this.plan.getPredecessors(op).get(i);
                planMap.put(pred, plans);
            }
            return planMap;
        }
        if (op instanceof LOJoin) {
            MultiMap<Operator, BaseOperatorPlan> planMap = new MultiMap<Operator, BaseOperatorPlan>();
            for (Integer i : ((LOJoin)op).getExpressionPlans().keySet()) {
                ArrayList<LogicalExpressionPlan> plans = new ArrayList<LogicalExpressionPlan>();
                plans.addAll(((LOJoin)op).getExpressionPlans().get(i));
                Operator pred = this.plan.getPredecessors(op).get(i);
                planMap.put(pred, plans);
            }
            return planMap;
        }
        return new MultiMap<Operator, BaseOperatorPlan>();
    }

    @Override
    protected Collection<BaseOperatorPlan> getNestedPlans(Operator op) {
        LinkedList<BaseOperatorPlan> plans = new LinkedList<BaseOperatorPlan>();
        if (op instanceof LOFilter) {
            plans.add(((LOFilter)op).getFilterPlan());
        } else if (op instanceof LOLimit) {
            plans.add(((LOLimit)op).getLimitPlan());
        } else if (op instanceof LOForEach) {
            plans.add(((LOForEach)op).getInnerPlan());
        } else if (op instanceof LOGenerate) {
            plans.addAll(((LOGenerate)op).getOutputPlans());
        } else if (op instanceof LOSort) {
            plans.addAll(((LOSort)op).getSortColPlans());
        } else if (op instanceof LOSplitOutput) {
            plans.add(((LOSplitOutput)op).getFilterPlan());
        }
        return plans;
    }

    @Override
    protected boolean reverse(BaseOperatorPlan plan) {
        return plan instanceof LogicalExpressionPlan;
    }
}

