/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitSplitInserter
extends Rule {
    public ImplicitSplitInserter(String n) {
        super(n, true);
        this.setSkipListener(true);
    }

    @Override
    public List<OperatorPlan> match(OperatorPlan plan) throws FrontendException {
        this.currentPlan = plan;
        ArrayList<OperatorPlan> ll = new ArrayList<OperatorPlan>();
        Iterator<Operator> ops = plan.getOperators();
        while (ops.hasNext()) {
            List<Operator> succs;
            Operator op = ops.next();
            if (op instanceof LOSplit || op instanceof LOStore || (succs = plan.getSuccessors(op)) == null || succs.size() < 2) continue;
            LogicalPlan match = new LogicalPlan();
            match.add(op);
            ll.add(match);
        }
        return ll;
    }

    @Override
    public Transformer getNewTransformer() {
        return new ImplicitSplitInserterTransformer();
    }

    @Override
    protected OperatorPlan buildPattern() {
        return null;
    }

    public class ImplicitSplitInserterTransformer
    extends Transformer {
        public boolean check(OperatorPlan matched) throws FrontendException {
            return true;
        }

        public void transform(OperatorPlan matched) throws FrontendException {
            if (matched == null || matched instanceof LOSplit || matched instanceof LOStore || matched.size() != 1) {
                throw new FrontendException("Invalid match in ImplicitSplitInserter rule.", 2244);
            }
            Operator op = matched.getSources().get(0);
            List<Operator> succs = ImplicitSplitInserter.this.currentPlan.getSuccessors(op);
            if (succs == null || succs.size() < 2) {
                throw new FrontendException("Invalid match in ImplicitSplitInserter rule.", 2243);
            }
            LOSplit splitOp = new LOSplit(ImplicitSplitInserter.this.currentPlan);
            splitOp.setAlias(((LogicalRelationalOperator)op).getAlias());
            Operator[] sucs = succs.toArray(new Operator[0]);
            ImplicitSplitInserter.this.currentPlan.add(splitOp);
            ImplicitSplitInserter.this.currentPlan.connect(op, splitOp);
            for (Operator suc : sucs) {
                Pair<Integer, Integer> pos = ImplicitSplitInserter.this.currentPlan.disconnect(op, suc);
                LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
                new ConstantExpression(filterPlan, true);
                LOSplitOutput splitOutput = new LOSplitOutput((LogicalPlan)ImplicitSplitInserter.this.currentPlan, filterPlan);
                splitOutput.setAlias(splitOp.getAlias());
                ImplicitSplitInserter.this.currentPlan.add(splitOutput);
                ImplicitSplitInserter.this.currentPlan.connect(splitOp, splitOutput);
                ImplicitSplitInserter.this.currentPlan.connect(splitOutput, (Integer)pos.first, suc, (Integer)pos.second);
            }
            UidResetter uidResetter = new UidResetter(ImplicitSplitInserter.this.currentPlan);
            uidResetter.visit();
            SchemaResetter schemaResetter = new SchemaResetter(ImplicitSplitInserter.this.currentPlan, true);
            schemaResetter.visit();
        }

        public OperatorPlan reportChanges() {
            return ImplicitSplitInserter.this.currentPlan;
        }
    }
}

