/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapKeysPruneHelper {
    public static final String REQUIRED_MAPKEYS = "MapPruner:RequiredKeys";
    private OperatorPlan currentPlan;
    private OperatorSubPlan subplan;

    public MapKeysPruneHelper(OperatorPlan currentPlan) {
        this.currentPlan = currentPlan;
        this.subplan = currentPlan instanceof OperatorSubPlan ? new OperatorSubPlan(((OperatorSubPlan)currentPlan).getBasePlan()) : new OperatorSubPlan(currentPlan);
    }

    public boolean check() throws FrontendException {
        List<Operator> sources = this.currentPlan.getSources();
        for (Operator source : sources) {
            LogicalSchema schema = ((LogicalRelationalOperator)source).getSchema();
            if (schema != null) continue;
            return false;
        }
        MapMarker marker = new MapMarker(this.currentPlan);
        marker.visit();
        HashSet<Long> fullMapUids = new HashSet<Long>();
        FullMapCollector collector = new FullMapCollector(this.currentPlan, fullMapUids);
        collector.visit();
        boolean hasAnnotation = false;
        for (Operator source : sources) {
            Map annotationValue = (Map)((LogicalRelationalOperator)source).getAnnotation(REQUIRED_MAPKEYS);
            if (!fullMapUids.isEmpty() && annotationValue != null && !annotationValue.isEmpty()) {
                Integer[] annotationKeyArray = annotationValue.keySet().toArray(new Integer[0]);
                LogicalSchema sourceSchema = ((LogicalRelationalOperator)source).getSchema();
                for (Integer col : annotationKeyArray) {
                    if (!fullMapUids.contains(sourceSchema.getField((int)col.intValue()).uid)) continue;
                    annotationValue.remove(col);
                }
            }
            if (annotationValue != null && annotationValue.isEmpty()) {
                ((LogicalRelationalOperator)source).removeAnnotation(REQUIRED_MAPKEYS);
                annotationValue = null;
            }
            if (annotationValue == null) continue;
            hasAnnotation = true;
            this.subplan.add(source);
        }
        return hasAnnotation;
    }

    private boolean hasMap(LogicalSchema schema) {
        for (LogicalSchema.LogicalFieldSchema field : schema.getFields()) {
            if (field.type != 100) continue;
            return true;
        }
        return false;
    }

    private static Set<Long> getMapUids(LogicalSchema schema) {
        HashSet<Long> uids = new HashSet<Long>();
        if (schema != null) {
            for (LogicalSchema.LogicalFieldSchema field : schema.getFields()) {
                uids.add(field.uid);
            }
        }
        return uids;
    }

    public OperatorPlan reportChanges() {
        return this.subplan;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FullMapCollector
    extends AllExpressionVisitor {
        Set<Long> fullMapUids = new HashSet<Long>();

        protected FullMapCollector(OperatorPlan plan, Set<Long> fullMapUids) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
            this.fullMapUids = fullMapUids;
        }

        @Override
        public void visit(LOStore store) throws FrontendException {
            super.visit(store);
            Set uids = MapKeysPruneHelper.getMapUids(store.getSchema());
            this.fullMapUids.addAll(uids);
        }

        @Override
        public void visit(LOUnion union) throws FrontendException {
            super.visit(union);
            List<Operator> preds = this.plan.getPredecessors(union);
            if (preds != null) {
                for (Operator pred : preds) {
                    LogicalSchema schema = ((LogicalRelationalOperator)pred).getSchema();
                    Set uids = MapKeysPruneHelper.getMapUids(schema);
                    this.fullMapUids.addAll(uids);
                }
            }
        }

        @Override
        public void visit(LOCogroup cogroup) throws FrontendException {
            super.visit(cogroup);
            List<Operator> preds = this.plan.getPredecessors(cogroup);
            if (preds != null) {
                for (Operator pred : preds) {
                    LogicalSchema schema = ((LogicalRelationalOperator)pred).getSchema();
                    Set uids = MapKeysPruneHelper.getMapUids(schema);
                    this.fullMapUids.addAll(uids);
                }
            }
        }

        @Override
        public void visit(LOSplitOutput splitOutput) throws FrontendException {
            super.visit(splitOutput);
            if (splitOutput.getSchema() != null) {
                for (LogicalSchema.LogicalFieldSchema fs : splitOutput.getSchema().getFields()) {
                    if (!this.fullMapUids.contains(fs.uid) || splitOutput.getInputUids(fs.uid) == -1L) continue;
                    this.fullMapUids.add(splitOutput.getInputUids(fs.uid));
                }
            }
        }

        @Override
        protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan expr) throws FrontendException {
            return new FullMapExpCollector((OperatorPlan)expr, this.fullMapUids);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FullMapExpCollector
        extends LogicalExpressionVisitor {
            Set<Long> fullMapUids = new HashSet<Long>();

            protected FullMapExpCollector(OperatorPlan plan, Set<Long> fullMapUids) throws FrontendException {
                super(plan, new DependencyOrderWalker(plan));
                this.fullMapUids = fullMapUids;
            }

            @Override
            public void visit(UserFuncExpression userFunc) throws FrontendException {
                List<Operator> succs = userFunc.getPlan().getSuccessors(userFunc);
                if (succs == null) {
                    return;
                }
                LogicalExpression succ = (LogicalExpression)succs.get(0);
                if (succ.getFieldSchema() != null && succ.getFieldSchema().type == 100) {
                    this.fullMapUids.add(succ.getFieldSchema().uid);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapMarker
    extends AllExpressionVisitor {
        Map<Long, Set<String>> inputUids = new HashMap<Long, Set<String>>();

        protected MapMarker(OperatorPlan plan) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
        }

        @Override
        public void visit(LOLoad load) throws FrontendException {
            if (load.getSchema() != null) {
                HashMap<Integer, Set<String>> annotation = new HashMap<Integer, Set<String>>();
                for (int i = 0; i < load.getSchema().size(); ++i) {
                    LogicalSchema.LogicalFieldSchema field = load.getSchema().getField(i);
                    if (!this.inputUids.containsKey(field.uid)) continue;
                    annotation.put(i, this.inputUids.get(field.uid));
                }
                load.annotate(MapKeysPruneHelper.REQUIRED_MAPKEYS, annotation);
            }
        }

        @Override
        public void visit(LOFilter filter) throws FrontendException {
            this.currentOp = filter;
            MapExprMarker v = (MapExprMarker)this.getVisitor(filter.getFilterPlan());
            v.visit();
            this.mergeUidKeys(v.inputUids);
        }

        @Override
        public void visit(LOJoin join) throws FrontendException {
            this.currentOp = join;
            Collection<LogicalExpressionPlan> c = join.getExpressionPlanValues();
            for (LogicalExpressionPlan plan : c) {
                MapExprMarker v = (MapExprMarker)this.getVisitor(plan);
                v.visit();
                this.mergeUidKeys(v.inputUids);
            }
        }

        @Override
        public void visit(LOGenerate gen) throws FrontendException {
            this.currentOp = gen;
            List<LogicalExpressionPlan> plans = gen.getOutputPlans();
            for (LogicalExpressionPlan plan : plans) {
                MapExprMarker v = (MapExprMarker)this.getVisitor(plan);
                v.visit();
                this.mergeUidKeys(v.inputUids);
            }
        }

        @Override
        public void visit(LOSort sort) throws FrontendException {
            this.currentOp = sort;
            List<LogicalExpressionPlan> c = sort.getSortColPlans();
            for (LogicalExpressionPlan plan : c) {
                MapExprMarker v = (MapExprMarker)this.getVisitor(plan);
                v.visit();
                this.mergeUidKeys(v.inputUids);
            }
        }

        @Override
        public void visit(LOSplitOutput splitOutput) throws FrontendException {
            this.currentOp = splitOutput;
            MapExprMarker v = (MapExprMarker)this.getVisitor(splitOutput.getFilterPlan());
            v.visit();
            this.mergeUidKeys(v.inputUids);
            if (splitOutput.getSchema() != null) {
                for (LogicalSchema.LogicalFieldSchema fs : splitOutput.getSchema().getFields()) {
                    Set<String> mapKeySet;
                    long inputUid = splitOutput.getInputUids(fs.uid);
                    if (inputUid == -1L || (mapKeySet = this.inputUids.get(fs.uid)) == null) continue;
                    if (this.inputUids.containsKey(inputUid)) {
                        this.inputUids.get(inputUid).addAll(mapKeySet);
                        continue;
                    }
                    this.inputUids.put(inputUid, mapKeySet);
                }
            }
        }

        private void mergeUidKeys(Map<Long, Set<String>> inputMap) {
            for (Map.Entry<Long, Set<String>> entry : inputMap.entrySet()) {
                if (this.inputUids.containsKey(entry.getKey())) {
                    Set<String> mapKeySet = this.inputUids.get(entry.getKey());
                    mapKeySet.addAll((Collection<String>)entry.getValue());
                    continue;
                }
                this.inputUids.put(entry.getKey(), inputMap.get(entry.getKey()));
            }
        }

        @Override
        protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan expr) throws FrontendException {
            return new MapExprMarker(expr);
        }

        static class MapExprMarker
        extends LogicalExpressionVisitor {
            Map<Long, Set<String>> inputUids = new HashMap<Long, Set<String>>();

            protected MapExprMarker(OperatorPlan p) throws FrontendException {
                super(p, new DependencyOrderWalker(p));
            }

            public void visit(MapLookupExpression op) throws FrontendException {
                Long uid = op.getMap().getFieldSchema().uid;
                String key = op.getLookupKey();
                HashSet mapKeySet = null;
                if (this.inputUids.containsKey(uid)) {
                    mapKeySet = (HashSet)this.inputUids.get(uid);
                } else {
                    mapKeySet = new HashSet();
                    this.inputUids.put(uid, mapKeySet);
                }
                mapKeySet.add(key);
            }
        }
    }
}

