/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.FuncSpec;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.parser.LogicalPlanGenerator;
import org.apache.pig.parser.PigParserNodeAdaptor;
import org.apache.pig.parser.QueryParser;
import org.apache.pig.parser.SourceLocation;
import org.apache.pig.tools.pigstats.ScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParserUtils {
    private static Log log = LogFactory.getLog(LogicalPlanGenerator.class);

    public static String removeQuotes(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void attachStorePlan(LogicalPlan lp, String fileName, String func, Operator input, String alias, PigContext pigContext) throws FrontendException {
        if (func == null) {
            func = PigStorage.class.getName();
        }
        FuncSpec funcSpec = new FuncSpec(func);
        StoreFuncInterface stoFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(funcSpec);
        stoFunc.setStoreFuncUDFContextSignature(LOStore.constructSignature(alias, fileName, funcSpec));
        fileName = QueryParserUtils.removeQuotes(fileName);
        FileSpec fileSpec = new FileSpec(fileName, funcSpec);
        LOStore store = new LOStore(lp, fileSpec);
        store.setAlias(alias);
        try {
            stoFunc.relToAbsPathForStoreLocation(fileName, QueryParserUtils.getCurrentDir(pigContext));
        }
        catch (IOException ioe) {
            FrontendException e = new FrontendException(ioe.getMessage(), ioe);
            throw e;
        }
        lp.add(store);
        lp.connect(input, store);
    }

    static Path getCurrentDir(PigContext pigContext) throws IOException {
        DataStorage dfs = pigContext.getDfs();
        ContainerDescriptor desc = dfs.getActiveContainer();
        ElementDescriptor el = dfs.asElement(desc);
        return new Path(el.toString());
    }

    static void setHdfsServers(String absolutePath, PigContext pigContext) throws URISyntaxException {
        URI defaultFSURI;
        String defaultHost;
        String defaultFS = (String)pigContext.getProperties().get("fs.default.name");
        if (defaultFS == null) {
            defaultFS = (String)pigContext.getProperties().get("fs.defaultFS");
        }
        if ((defaultHost = (defaultFSURI = new URI(defaultFS)).getHost()) == null) {
            defaultHost = "";
        }
        defaultHost = defaultHost.toLowerCase();
        Set<String> remoteHosts = QueryParserUtils.getRemoteHosts(absolutePath, defaultHost);
        String hdfsServersString = (String)pigContext.getProperties().get("mapreduce.job.hdfs-servers");
        if (hdfsServersString == null) {
            hdfsServersString = "";
        }
        String[] hdfsServers = hdfsServersString.split(",");
        for (String remoteHost : remoteHosts) {
            boolean existing = false;
            for (String hdfsServer : hdfsServers) {
                if (!hdfsServer.equals(remoteHost)) continue;
                existing = true;
            }
            if (existing) continue;
            if (!hdfsServersString.isEmpty()) {
                hdfsServersString = hdfsServersString + ",";
            }
            hdfsServersString = hdfsServersString + remoteHost;
        }
        if (!hdfsServersString.isEmpty()) {
            pigContext.getProperties().setProperty("mapreduce.job.hdfs-servers", hdfsServersString);
        }
    }

    static Set<String> getRemoteHosts(String absolutePath, String defaultHost) {
        String[] fnames;
        String HAR_PREFIX = "hdfs-";
        HashSet<String> result = new HashSet<String>();
        for (String fname : fnames = absolutePath.split(",")) {
            String scheme;
            Path p = new Path(fname = fname.trim());
            URI uri = p.toUri();
            if (!uri.isAbsolute() || ((scheme = uri.getScheme()) == null || !scheme.toLowerCase().equals("hdfs")) && !scheme.toLowerCase().equals("har") || uri.getHost() == null) continue;
            String thisHost = uri.getHost().toLowerCase();
            if (scheme.toLowerCase().equals("har") && thisHost.startsWith(HAR_PREFIX)) {
                thisHost = thisHost.substring(HAR_PREFIX.length());
            }
            if (uri.getHost().isEmpty() || thisHost.equals(defaultHost)) continue;
            if (uri.getPort() != -1) {
                result.add("hdfs://" + thisHost + ":" + uri.getPort());
                continue;
            }
            result.add("hdfs://" + thisHost);
        }
        return result;
    }

    static String constructFileNameSignature(String fileName, FuncSpec funcSpec) {
        return fileName + "_" + funcSpec.toString();
    }

    static String constructSignature(String alias, String filename, FuncSpec funcSpec) {
        return alias + "_" + filename + "_" + funcSpec.toString();
    }

    static String generateErrorHeader(RecognitionException ex, String filename) {
        return new SourceLocation(filename, ex.line, ex.charPositionInLine).toString();
    }

    static void replaceNodeWithNodeList(Tree oldNode, CommonTree newTree, String fileName) {
        int idx = oldNode.getChildIndex();
        CommonTree parent = (CommonTree)oldNode.getParent();
        int count = parent.getChildCount();
        ArrayList childList = new ArrayList(parent.getChildren());
        List macroList = newTree.getChildren();
        while (parent.getChildCount() > 0) {
            parent.deleteChild(0);
        }
        for (int i = 0; i < count; ++i) {
            if (i == idx) {
                if (macroList == null) continue;
                parent.addChildren(macroList);
                continue;
            }
            parent.addChild((Tree)childList.get(i));
        }
    }

    static File getFileFromImportSearchPath(String scriptPath) {
        String srchPath;
        File f = new File(scriptPath);
        if (f.exists() || f.isAbsolute() || scriptPath.startsWith("./") || scriptPath.startsWith("../")) {
            return f;
        }
        ScriptState state = ScriptState.get();
        if (state != null && state.getPigContext() != null && (srchPath = state.getPigContext().getProperties().getProperty("pig.import.search.path")) != null) {
            String[] paths;
            for (String path : paths = srchPath.split(",")) {
                File f1 = new File(path + File.separator + scriptPath);
                if (!f1.exists()) continue;
                return f1;
            }
        }
        return null;
    }

    static QueryParser createParser(CommonTokenStream tokens) {
        return QueryParserUtils.createParser(tokens, 0);
    }

    static QueryParser createParser(CommonTokenStream tokens, int lineOffset) {
        QueryParser parser = new QueryParser((TokenStream)tokens);
        PigParserNodeAdaptor adaptor = new PigParserNodeAdaptor(tokens.getSourceName(), lineOffset);
        parser.setTreeAdaptor((TreeAdaptor)adaptor);
        return parser;
    }
}

