/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceClasses {
    public static Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> getLoToEqClassMap(PhysicalPlan plan, LogicalPlan lp, Map<Operator, PhysicalOperator> logToPhyMap, Map<Operator, DataBag> logToDataMap, Map<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> forEachInnerLogToPhyMap, HashMap<PhysicalOperator, Collection<IdentityHashSet<Tuple>>> poToEqclassesMap) {
        HashMap<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> ret = new HashMap<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>>();
        List<Operator> roots = lp.getSources();
        HashSet<Operator> seen = new HashSet<Operator>();
        for (Operator lo : roots) {
            EquivalenceClasses.getEqClasses(plan, lo, lp, logToPhyMap, ret, poToEqclassesMap, logToDataMap, forEachInnerLogToPhyMap, seen);
        }
        return ret;
    }

    private static void getEqClasses(PhysicalPlan plan, Operator parent, LogicalPlan lp, Map<Operator, PhysicalOperator> logToPhyMap, Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> result, HashMap<PhysicalOperator, Collection<IdentityHashSet<Tuple>>> poToEqclassesMap, Map<Operator, DataBag> logToDataMap, Map<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> forEachInnerLogToPhyMap, HashSet<Operator> seen) {
        if (parent instanceof LOForEach) {
            if (poToEqclassesMap.get(logToPhyMap.get(parent)) != null) {
                LinkedList<IdentityHashSet<Tuple>> eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
                eqClasses.addAll(poToEqclassesMap.get(logToPhyMap.get(parent)));
                for (Map.Entry<LogicalRelationalOperator, PhysicalOperator> entry : forEachInnerLogToPhyMap.get(parent).entrySet()) {
                    if (poToEqclassesMap.get(entry.getValue()) == null) continue;
                    eqClasses.addAll(poToEqclassesMap.get(entry.getValue()));
                }
                result.put((LogicalRelationalOperator)parent, eqClasses);
            }
        } else if (parent instanceof LOCross) {
            IdentityHashSet<Tuple> eqClass;
            LinkedList eqClasses;
            boolean ok = true;
            for (Operator input : ((LOCross)parent).getInputs()) {
                if (logToDataMap.get(input).size() >= 2L) continue;
                ok = false;
                break;
            }
            if (ok) {
                eqClasses = new LinkedList();
                eqClass = new IdentityHashSet<Tuple>();
                Iterator<Tuple> it = logToDataMap.get(parent).iterator();
                while (it.hasNext()) {
                    eqClass.add(it.next());
                }
                eqClasses.add(eqClass);
                result.put((LogicalRelationalOperator)parent, eqClasses);
            } else {
                eqClasses = new LinkedList();
                eqClass = new IdentityHashSet();
                eqClasses.add(eqClass);
                result.put((LogicalRelationalOperator)parent, eqClasses);
            }
        } else {
            Collection<IdentityHashSet<Tuple>> eqClasses = poToEqclassesMap.get(logToPhyMap.get(parent));
            if (eqClasses == null) {
                eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
                int size = ((POPackage)logToPhyMap.get(parent)).getNumInps();
                for (int i = 0; i < size; ++i) {
                    eqClasses.add(new IdentityHashSet());
                }
            }
            result.put((LogicalRelationalOperator)parent, eqClasses);
        }
        if (lp.getSuccessors(parent) != null) {
            for (Operator lo : lp.getSuccessors(parent)) {
                if (seen.contains(lo)) continue;
                seen.add(lo);
                EquivalenceClasses.getEqClasses(plan, lo, lp, logToPhyMap, result, poToEqclassesMap, logToDataMap, forEachInnerLogToPhyMap, seen);
            }
        }
    }
}

