/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import java.io.IOException;
import java.util.Map;
import org.apache.pig.AlgebraicEvalFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.scripting.jruby.JrubyScriptEngine;
import org.apache.pig.scripting.jruby.PigJrubyLibrary;
import org.apache.pig.scripting.jruby.RubyDataBag;
import org.jruby.Ruby;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JrubyAlgebraicEvalFunc<T>
extends AlgebraicEvalFunc<T> {
    protected static BagFactory mBagFactory = BagFactory.getInstance();
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected static final ScriptingContainer rubyEngine = JrubyScriptEngine.rubyEngine;
    protected static final Ruby ruby = rubyEngine.getProvider().getRuntime();

    private JrubyAlgebraicEvalFunc() {
        super(new String[0]);
    }

    public JrubyAlgebraicEvalFunc(String fileName, String functionName) {
        super(fileName, functionName);
    }

    @Override
    public abstract String getFinal();

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermed.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Tuple> {
        public TupleJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Tuple> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Map<?, ?>> {
        public MapJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Map<?, ?>> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Long> {
        public LongJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Long> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Integer> {
        public IntegerJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Integer> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Float> {
        public FloatJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Float> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<Double> {
        public DoubleJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<Double> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataByteArrayJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<DataByteArray> {
        public DataByteArrayJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<DataByteArray> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChararrayJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<String> {
        public ChararrayJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<String> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BagJrubyAlgebraicEvalFunc
    extends JrubyAlgebraicEvalFunc<DataBag> {
        public BagJrubyAlgebraicEvalFunc(String fileName, String functionName) {
            super(fileName, functionName);
        }

        @Override
        public String getFinal() {
            return Final.class.getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc$Final<DataBag> {
            public Final() {
            }

            public Final(String fileName, String functionName) {
                super(fileName, functionName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AlgebraicFunctionWrapper<T>
    extends EvalFunc<T> {
        private String fileName;
        private String functionName;
        protected Object receiver;
        protected boolean isInitialized = false;
        protected String stage;

        public String getStage() {
            return this.stage;
        }

        public Object getReceiver() {
            return this.receiver;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public AlgebraicFunctionWrapper() {
        }

        public AlgebraicFunctionWrapper(String fileName, String functionName, String stage) {
            this.fileName = fileName;
            this.functionName = functionName;
            this.stage = stage;
        }

        public boolean isInitialized() {
            return this.isInitialized;
        }

        public void initialize() {
            this.receiver = rubyEngine.callMethod(JrubyScriptEngine.RubyFunctions.getFunctions("algebraic", this.fileName).get(this.functionName), "new", new Object[0]);
            this.isInitialized = true;
        }

        @Override
        public abstract T exec(Tuple var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final<T>
    extends AlgebraicFunctionWrapper<T> {
        public Final() {
        }

        public Final(String fileName, String functionName) {
            super(fileName, functionName, "final");
        }

        @Override
        public T exec(Tuple input) throws IOException {
            if (!this.isInitialized()) {
                this.initialize();
            }
            try {
                RubyDataBag inp = new RubyDataBag(ruby, ruby.getClass("DataBag"), (DataBag)input.get(0));
                IRubyObject rubyResult = (IRubyObject)rubyEngine.callMethod(this.getReceiver(), this.getStage(), (Object)inp, IRubyObject.class);
                return (T)PigJrubyLibrary.rubyToPig(rubyResult);
            }
            catch (Exception e) {
                throw new IOException("Error executing final function", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermed
    extends AlgebraicFunctionWrapper<Tuple> {
        public Intermed() {
        }

        public Intermed(String fileName, String functionName) {
            super(fileName, functionName, "intermed");
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (!this.isInitialized()) {
                this.initialize();
            }
            try {
                RubyDataBag inp = new RubyDataBag(ruby, ruby.getClass("DataBag"), (DataBag)input.get(0));
                IRubyObject rubyResult = (IRubyObject)rubyEngine.callMethod(this.getReceiver(), this.getStage(), (Object)inp, IRubyObject.class);
                return mTupleFactory.newTuple(PigJrubyLibrary.rubyToPig(rubyResult));
            }
            catch (Exception e) {
                throw new IOException("Error executing intermediate function: ", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends AlgebraicFunctionWrapper<Tuple> {
        public Initial() {
        }

        public Initial(String fileName, String functionName) {
            super(fileName, functionName, "initial");
        }

        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (!this.isInitialized()) {
                this.initialize();
            }
            try {
                IRubyObject inp = PigJrubyLibrary.pigToRuby(ruby, ((DataBag)input.get(0)).iterator().next().get(0));
                IRubyObject rubyResult = (IRubyObject)rubyEngine.callMethod(this.getReceiver(), this.getStage(), (Object)inp, IRubyObject.class);
                return mTupleFactory.newTuple(PigJrubyLibrary.rubyToPig(rubyResult));
            }
            catch (Exception e) {
                throw new IOException("Error executing initial function", e);
            }
        }
    }
}

