/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.scripting.jruby.RubyDataBag;
import org.apache.pig.scripting.jruby.RubyDataByteArray;
import org.apache.pig.scripting.jruby.RubySchema;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigJrubyLibrary
implements Library {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final Method enumeratorizeMethod;

    public void load(Ruby runtime, boolean wrap) throws IOException {
        RubyDataBag.define(runtime);
        RubyDataByteArray.define(runtime);
        RubySchema.define(runtime);
    }

    public static Object rubyToPig(IRubyObject rbObject) throws ExecException {
        if (rbObject == null || rbObject instanceof RubyNil) {
            return null;
        }
        if (rbObject instanceof RubyArray) {
            return PigJrubyLibrary.rubyToPig((RubyArray)rbObject);
        }
        if (rbObject instanceof RubyHash) {
            return PigJrubyLibrary.rubyToPig((RubyHash)rbObject);
        }
        if (rbObject instanceof RubyString) {
            return PigJrubyLibrary.rubyToPig((RubyString)rbObject);
        }
        if (rbObject instanceof RubyBignum) {
            return PigJrubyLibrary.rubyToPig((RubyBignum)rbObject);
        }
        if (rbObject instanceof RubyFixnum) {
            return PigJrubyLibrary.rubyToPig((RubyFixnum)rbObject);
        }
        if (rbObject instanceof RubyFloat) {
            return PigJrubyLibrary.rubyToPig((RubyFloat)rbObject);
        }
        if (rbObject instanceof RubyInteger) {
            return PigJrubyLibrary.rubyToPig((RubyInteger)rbObject);
        }
        if (rbObject instanceof RubyDataBag) {
            return PigJrubyLibrary.rubyToPig((RubyDataBag)rbObject);
        }
        if (rbObject instanceof RubyDataByteArray) {
            return PigJrubyLibrary.rubyToPig((RubyDataByteArray)rbObject);
        }
        if (rbObject instanceof RubySchema) {
            return PigJrubyLibrary.rubyToPig((RubySchema)rbObject);
        }
        if (rbObject instanceof RubyBoolean) {
            return PigJrubyLibrary.rubyToPig((RubyBoolean)rbObject);
        }
        throw new ExecException("Cannot cast into any pig supported type: " + rbObject.getClass().getName());
    }

    public static Tuple rubyToPig(RubyArray rbObject) throws ExecException {
        Tuple out = tupleFactory.newTuple(rbObject.size());
        int i = 0;
        for (IRubyObject arrayObj : rbObject.toJavaArray()) {
            out.set(i++, PigJrubyLibrary.rubyToPig(arrayObj));
        }
        return out;
    }

    public static Map<String, ?> rubyToPig(RubyHash rbObject) throws ExecException {
        HashMap newMap = Maps.newHashMap();
        for (Map.Entry entry : rbObject.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String || key instanceof RubyString || key instanceof RubySymbol)) {
                throw new ExecException("Hash must have String or Symbol key. Was given: " + key.getClass().getName());
            }
            String keyStr = key.toString();
            if (entry.getValue() instanceof IRubyObject) {
                newMap.put(keyStr, PigJrubyLibrary.rubyToPig((IRubyObject)entry.getValue()));
                continue;
            }
            newMap.put(keyStr, entry.getValue());
        }
        return newMap;
    }

    public static Boolean rubyToPig(RubyBoolean rbObject) {
        return rbObject.isTrue();
    }

    public static Schema rubyToPig(RubySchema rbObject) {
        return rbObject.getInternalSchema();
    }

    public static String rubyToPig(RubyString rbObject) {
        return rbObject.toString();
    }

    public static Long rubyToPig(RubyBignum rbObject) {
        return rbObject.getLongValue();
    }

    public static Long rubyToPig(RubyFixnum rbObject) {
        return rbObject.getLongValue();
    }

    public static Double rubyToPig(RubyFloat rbObject) {
        return rbObject.getDoubleValue();
    }

    public static Integer rubyToPig(RubyInteger rbObject) {
        return (Integer)rbObject.toJava(Integer.class);
    }

    public static DataBag rubyToPig(RubyDataBag rbObject) {
        return rbObject.getBag();
    }

    public static DataByteArray rubyToPig(RubyDataByteArray rbObject) {
        return rbObject.getDBA();
    }

    public static Object rubyToPig(RubyNil rbObject) {
        return null;
    }

    public static IRubyObject pigToRuby(Ruby ruby, Object object) throws ExecException {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof Tuple) {
            return PigJrubyLibrary.pigToRuby(ruby, (Tuple)object);
        }
        if (object instanceof DataBag) {
            return PigJrubyLibrary.pigToRuby(ruby, (DataBag)object);
        }
        if (object instanceof Map) {
            return PigJrubyLibrary.pigToRuby(ruby, (Map)object);
        }
        if (object instanceof DataByteArray) {
            return PigJrubyLibrary.pigToRuby(ruby, (DataByteArray)object);
        }
        if (object instanceof Schema) {
            return PigJrubyLibrary.pigToRuby(ruby, (Schema)object);
        }
        if (object instanceof String) {
            return PigJrubyLibrary.pigToRuby(ruby, (String)object);
        }
        if (object instanceof Integer) {
            return PigJrubyLibrary.pigToRuby(ruby, (Integer)object);
        }
        if (object instanceof Long) {
            return PigJrubyLibrary.pigToRuby(ruby, (Long)object);
        }
        if (object instanceof Float) {
            return PigJrubyLibrary.pigToRuby(ruby, (Float)object);
        }
        if (object instanceof Double) {
            return PigJrubyLibrary.pigToRuby(ruby, (Double)object);
        }
        if (object instanceof Boolean) {
            return PigJrubyLibrary.pigToRuby(ruby, (Boolean)object);
        }
        throw new ExecException("Object of unknown type " + object.getClass().getName() + " passed to pigToRuby");
    }

    public static RubyArray pigToRuby(Ruby ruby, Tuple object) throws ExecException {
        RubyArray rubyArray = ruby.newArray();
        for (Object o : object.getAll()) {
            rubyArray.add((Object)PigJrubyLibrary.pigToRuby(ruby, o));
        }
        return rubyArray;
    }

    public static RubyBoolean pigToRuby(Ruby ruby, Boolean object) {
        return RubyBoolean.newBoolean((Ruby)ruby, (boolean)object);
    }

    public static RubyDataBag pigToRuby(Ruby ruby, DataBag object) {
        return new RubyDataBag(ruby, ruby.getClass("DataBag"), object);
    }

    public static RubySchema pigToRuby(Ruby ruby, Schema object) {
        return new RubySchema(ruby, ruby.getClass("Schema"), object);
    }

    public static <T> RubyHash pigToRuby(Ruby ruby, Map<T, ?> object) throws ExecException {
        RubyHash newMap = RubyHash.newHash((Ruby)ruby);
        boolean checkType = false;
        for (Map.Entry<T, ?> entry : object.entrySet()) {
            T key = entry.getKey();
            if (!checkType) {
                if (!(key instanceof String)) {
                    throw new ExecException("pigToRuby only supports converting Maps with String keys");
                }
                checkType = true;
            }
            newMap.put(key, (Object)PigJrubyLibrary.pigToRuby(ruby, entry.getValue()));
        }
        return newMap;
    }

    public static RubyDataByteArray pigToRuby(Ruby ruby, DataByteArray object) {
        return new RubyDataByteArray(ruby, ruby.getClass("DataByteArray"), object);
    }

    public static RubyString pigToRuby(Ruby ruby, String object) {
        return ruby.newString(object.toString());
    }

    public static RubyFixnum pigToRuby(Ruby ruby, Integer object) {
        return RubyFixnum.newFixnum((Ruby)ruby, (long)object.longValue());
    }

    public static RubyFixnum pigToRuby(Ruby ruby, Long object) {
        return RubyFixnum.newFixnum((Ruby)ruby, (long)object);
    }

    public static RubyFloat pigToRuby(Ruby ruby, Float object) {
        return RubyFloat.newFloat((Ruby)ruby, (double)object.doubleValue());
    }

    public static RubyFloat pigToRuby(Ruby ruby, Double object) {
        return RubyFloat.newFloat((Ruby)ruby, (double)object);
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject obj, String name) {
        try {
            return (IRubyObject)enumeratorizeMethod.invoke(null, runtime, obj, name);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to properly enumeratorize", e);
        }
    }

    static {
        try {
            enumeratorizeMethod = RubyEnumerator.class.getDeclaredMethod("enumeratorize", Ruby.class, IRubyObject.class, String.class);
            enumeratorizeMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Enumeratorize method not found", e);
        }
    }
}

