/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.pigstats.EmbeddedPigStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.SimplePigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PigStatsUtil {
    public static final String MULTI_STORE_RECORD_COUNTER = "Output records in ";
    public static final String MULTI_STORE_COUNTER_GROUP = "MultiStoreCounters";
    public static final String TASK_COUNTER_GROUP = "org.apache.hadoop.mapred.Task$Counter";
    public static final String FS_COUNTER_GROUP = HadoopShims.getFsCounterGroupName();
    public static final String MAP_INPUT_RECORDS = "MAP_INPUT_RECORDS";
    public static final String MAP_OUTPUT_RECORDS = "MAP_OUTPUT_RECORDS";
    public static final String REDUCE_INPUT_RECORDS = "REDUCE_INPUT_RECORDS";
    public static final String REDUCE_OUTPUT_RECORDS = "REDUCE_OUTPUT_RECORDS";
    public static final String HDFS_BYTES_WRITTEN = "HDFS_BYTES_WRITTEN";
    public static final String HDFS_BYTES_READ = "HDFS_BYTES_READ";
    public static final String MULTI_INPUTS_RECORD_COUNTER = "Input records from ";
    public static final String MULTI_INPUTS_COUNTER_GROUP = "MultiInputCounters";
    private static final Log LOG = LogFactory.getLog(PigStatsUtil.class);
    private static final int COUNTER_NAME_LIMIT = 40;
    private static final String SEPARATOR = "/";
    private static final String SEMICOLON = ";";
    private static Pattern pattern = Pattern.compile("tmp(-)?[\\d]{1,10}$");

    public static long getMultiStoreCount(Job job, JobClient jobClient, String counterName) {
        long value = -1L;
        try {
            RunningJob rj = jobClient.getJob(job.getAssignedJobID());
            if (rj != null) {
                Counters.Counter counter = rj.getCounters().getGroup(MULTI_STORE_COUNTER_GROUP).getCounterForName(counterName);
                value = counter.getValue();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to get the counter for " + counterName), (Throwable)e);
        }
        return value;
    }

    public static String getMultiStoreCounterName(POStore store) {
        String shortName = PigStatsUtil.getShortName(store.getSFile().getFileName());
        return shortName == null ? null : "Output records in _" + store.getIndex() + "_" + shortName;
    }

    public static String getMultiInputsCounterName(String fname, int index) {
        String shortName = PigStatsUtil.getShortName(fname);
        return shortName == null ? null : "Input records from _" + index + "_" + shortName;
    }

    private static String getShortName(String uri) {
        int scolon = uri.indexOf(SEMICOLON);
        int slash = scolon != -1 ? uri.lastIndexOf(SEPARATOR, scolon) : uri.lastIndexOf(SEPARATOR);
        String shortName = null;
        if (scolon == -1) {
            shortName = uri.substring(slash + 1);
        }
        if (slash < scolon) {
            shortName = uri.substring(slash + 1, scolon);
        }
        if (shortName != null && shortName.length() > 40) {
            shortName = shortName.substring(shortName.length() - 40);
        }
        return shortName;
    }

    public static void startCollection(PigContext pc, JobClient client, JobControlCompiler jcc, MROperPlan plan) {
        SimplePigStats ps = (SimplePigStats)PigStats.start();
        ps.start(pc, client, jcc, plan);
        ScriptState.get().emitLaunchStartedNotification(plan.size());
    }

    public static void stopCollection(boolean display) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        ps.stop();
        if (!ps.isSuccessful()) {
            LOG.error((Object)(ps.getNumberFailedJobs() + " map reduce job(s) failed!"));
            String errMsg = ps.getErrorMessage();
            if (errMsg != null) {
                LOG.error((Object)("Error message: " + errMsg));
            }
        }
        ScriptState.get().emitLaunchCompletedNotification(ps.getNumberSuccessfulJobs());
        if (display) {
            ps.display();
        }
    }

    public static PigStats getEmptyPigStats() {
        return PigStats.start();
    }

    public static PigStats getPigStats(int code) {
        PigStats ps = PigStats.get();
        ps.setReturnCode(code);
        return ps;
    }

    public static void displayStatistics() {
        ((SimplePigStats)PigStats.get()).display();
    }

    public static void updateJobMroMap(Map<Job, MapReduceOper> jobMroMap) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        for (Map.Entry<Job, MapReduceOper> entry : jobMroMap.entrySet()) {
            MapReduceOper mro = entry.getValue();
            ps.mapMROperToJob(mro, entry.getKey());
        }
    }

    public static void accumulateStats(JobControl jc) {
        JobStats js;
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        ScriptState ss = ScriptState.get();
        for (Job job : jc.getSuccessfulJobs()) {
            js = PigStatsUtil.addSuccessJobStats(ps, job);
            if (js == null) continue;
            ss.emitjobFinishedNotification(js);
        }
        for (Job job : jc.getFailedJobs()) {
            js = PigStatsUtil.addFailedJobStats(ps, job);
            if (js == null) continue;
            js.setErrorMsg(job.getMessage());
            ss.emitJobFailedNotification(js);
        }
    }

    public static void setErrorMessage(String msg) {
        PigStats.get().setErrorMessage(msg);
    }

    public static void setErrorCode(int code) {
        PigStats.get().setErrorCode(code);
    }

    public static void setBackendException(Job job, Exception e) {
        ((SimplePigStats)PigStats.get()).setBackendException(job, e);
    }

    public static boolean isTempFile(String fileName) {
        Matcher result = pattern.matcher(fileName);
        return result.find();
    }

    private static JobStats addFailedJobStats(SimplePigStats ps, Job job) {
        if (ps.isJobSeen(job)) {
            return null;
        }
        JobStats js = ps.addJobStats(job);
        if (js == null) {
            LOG.warn((Object)"unable to add failed job stats");
        } else {
            js.setSuccessful(false);
            js.addOutputStatistics();
            js.addInputStatistics();
        }
        return js;
    }

    public static JobStats addNativeJobStats(PigStats ps, NativeMapReduceOper mr, boolean success) {
        return PigStatsUtil.addNativeJobStats(ps, mr, success, null);
    }

    public static void setStatsMap(Map<String, List<PigStats>> statsMap) {
        EmbeddedPigStats stats = new EmbeddedPigStats(statsMap);
        PigStats.set(stats);
    }

    public static JobStats addNativeJobStats(PigStats ps, NativeMapReduceOper mr, boolean success, Exception e) {
        if (ps.isEmbedded()) {
            throw new IllegalArgumentException();
        }
        JobStats js = ((SimplePigStats)ps).addJobStatsForNative(mr);
        if (js == null) {
            LOG.warn((Object)"unable to add native job stats");
        } else {
            js.setSuccessful(success);
            if (e != null) {
                js.setBackendException(e);
            }
        }
        return js;
    }

    private static JobStats addSuccessJobStats(SimplePigStats ps, Job job) {
        if (ps.isJobSeen(job)) {
            return null;
        }
        JobStats js = ps.addJobStats(job);
        if (js == null) {
            LOG.warn((Object)"unable to add job stats");
        } else {
            js.setSuccessful(true);
            js.addMapReduceStatistics(ps.getJobClient(), (Configuration)job.getJobConf());
            JobClient client = ps.getJobClient();
            RunningJob rjob = null;
            try {
                rjob = client.getJob(job.getAssignedJobID());
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to get running job", (Throwable)e);
            }
            if (rjob == null) {
                LOG.warn((Object)("Failed to get RunningJob for job " + job.getAssignedJobID()));
            } else {
                js.addCounters(rjob);
            }
            js.addOutputStatistics();
            js.addInputStatistics();
        }
        return js;
    }
}

