/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.timer;

import java.io.PrintStream;

public class PerformanceTimer {
    private State mState;
    private long mNanosecs = 0L;
    private long mStartedAt;
    private int mStarts = 0;
    private String mName;

    public void start() {
        this.mStartedAt = System.nanoTime();
        ++this.mStarts;
        this.mState = State.RUNNING;
    }

    public void stop() {
        this.mState = State.STOPPED;
        this.mNanosecs += System.nanoTime() - this.mStartedAt;
    }

    public void print(PrintStream out) {
        if (this.mStarts == 0) {
            out.println(this.mName + " never started.");
            return;
        }
        if (this.mState == State.RUNNING) {
            out.print("WARNING:  timer still running!  ");
        }
        out.print(this.mName + ": ");
        double t = (double)this.mNanosecs / 1.0E9;
        out.print(t);
        out.print(".  Run ");
        out.print(this.mStarts);
        out.print(" times, average run time ");
        long avg = this.mNanosecs / (long)this.mStarts;
        t = (double)avg / 1.0E9;
        out.print(t);
        out.println(".");
    }

    PerformanceTimer(String name) {
        this.mName = name;
        this.mState = State.STOPPED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        STOPPED;

    }
}

