/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroKeyComparator;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.AvroSerialization;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.HadoopCombiner;
import org.apache.avro.mapred.HadoopMapper;
import org.apache.avro.mapred.HadoopReducer;
import org.apache.avro.mapred.SequenceFileInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class AvroJob {
    static final String MAPPER = "avro.mapper";
    static final String COMBINER = "avro.combiner";
    static final String REDUCER = "avro.reducer";
    public static final String INPUT_SCHEMA = "avro.input.schema";
    public static final String MAP_OUTPUT_SCHEMA = "avro.map.output.schema";
    public static final String OUTPUT_SCHEMA = "avro.output.schema";
    public static final String OUTPUT_CODEC = "avro.output.codec";
    public static final String TEXT_PREFIX = "avro.meta.text.";
    public static final String BINARY_PREFIX = "avro.meta.binary.";
    public static final String INPUT_IS_REFLECT = "avro.input.is.reflect";
    public static final String MAP_OUTPUT_IS_REFLECT = "avro.map.output.is.reflect";

    private AvroJob() {
    }

    public static void setInputSchema(JobConf job, Schema s) {
        job.set(INPUT_SCHEMA, s.toString());
        AvroJob.configureAvroInput(job);
    }

    public static Schema getInputSchema(Configuration job) {
        return Schema.parse((String)job.get(INPUT_SCHEMA));
    }

    public static void setMapOutputSchema(JobConf job, Schema s) {
        job.set(MAP_OUTPUT_SCHEMA, s.toString());
        AvroJob.configureAvroShuffle(job);
    }

    public static Schema getMapOutputSchema(Configuration job) {
        return Schema.parse((String)job.get(MAP_OUTPUT_SCHEMA, job.get(OUTPUT_SCHEMA)));
    }

    public static void setOutputSchema(JobConf job, Schema s) {
        job.set(OUTPUT_SCHEMA, s.toString());
        AvroJob.configureAvroOutput(job);
    }

    public static void setOutputCodec(JobConf job, String codec) {
        job.set(OUTPUT_CODEC, codec);
    }

    public static void setOutputMeta(JobConf job, String key, String value) {
        job.set(TEXT_PREFIX + key, value);
    }

    public static void setOutputMeta(JobConf job, String key, long value) {
        job.set(TEXT_PREFIX + key, Long.toString(value));
    }

    public static void setOutputMeta(JobConf job, String key, byte[] value) {
        try {
            job.set(BINARY_PREFIX + key, URLEncoder.encode(new String(value, "ISO-8859-1"), "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setInputSequenceFile(JobConf job) {
        job.setInputFormat(SequenceFileInputFormat.class);
    }

    public static void setReflect(JobConf job) {
        AvroJob.setInputReflect(job);
        AvroJob.setMapOutputReflect(job);
    }

    public static void setInputReflect(JobConf job) {
        job.setBoolean(INPUT_IS_REFLECT, true);
    }

    public static void setMapOutputReflect(JobConf job) {
        job.setBoolean(MAP_OUTPUT_IS_REFLECT, true);
    }

    public static Schema getOutputSchema(Configuration job) {
        return Schema.parse((String)job.get(OUTPUT_SCHEMA));
    }

    private static void configureAvroInput(JobConf job) {
        if (job.get("mapred.input.format.class") == null) {
            job.setInputFormat(AvroInputFormat.class);
        }
        if (job.getMapperClass() == IdentityMapper.class) {
            job.setMapperClass(HadoopMapper.class);
        }
        AvroJob.configureAvroShuffle(job);
    }

    private static void configureAvroOutput(JobConf job) {
        if (job.get("mapred.output.format.class") == null) {
            job.setOutputFormat(AvroOutputFormat.class);
        }
        if (job.getReducerClass() == IdentityReducer.class) {
            job.setReducerClass(HadoopReducer.class);
        }
        job.setOutputKeyClass(AvroWrapper.class);
        AvroJob.configureAvroShuffle(job);
    }

    private static void configureAvroShuffle(JobConf job) {
        job.setOutputKeyComparatorClass(AvroKeyComparator.class);
        job.setMapOutputKeyClass(AvroKey.class);
        job.setMapOutputValueClass(AvroValue.class);
        Collection serializations = job.getStringCollection("io.serializations");
        if (!serializations.contains(AvroSerialization.class.getName())) {
            serializations.add(AvroSerialization.class.getName());
            job.setStrings("io.serializations", serializations.toArray(new String[0]));
        }
    }

    public static void setMapperClass(JobConf job, Class<? extends AvroMapper> c) {
        job.set(MAPPER, c.getName());
    }

    public static void setCombinerClass(JobConf job, Class<? extends AvroReducer> c) {
        job.set(COMBINER, c.getName());
        job.setCombinerClass(HadoopCombiner.class);
    }

    public static void setReducerClass(JobConf job, Class<? extends AvroReducer> c) {
        job.set(REDUCER, c.getName());
    }
}

