/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    public static final String SERVLET_PATH = "templeton";
    private static final Log LOG = LogFactory.getLog(Main.class);
    public static final int DEFAULT_PORT = 8080;
    private Server server;
    private static volatile AppConfig conf;

    public static synchronized AppConfig getAppConfigInstance() {
        if (conf == null) {
            LOG.error((Object)"Bug: configuration not yet loaded");
        }
        return conf;
    }

    Main(String[] args) {
        this.init(args);
    }

    public void init(String[] args) {
        this.initLogger();
        conf = this.loadConfig(args);
        conf.startCleanup();
        LOG.debug((Object)("Loaded conf " + (Object)((Object)conf)));
    }

    private void initLogger() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler h : rootLogger.getHandlers()) {
            rootLogger.removeHandler(h);
        }
        SLF4JBridgeHandler.install();
    }

    public AppConfig loadConfig(String[] args) {
        AppConfig cf = new AppConfig();
        try {
            GenericOptionsParser parser = new GenericOptionsParser((Configuration)cf, args);
            if (parser.getRemainingArgs().length > 0) {
                this.usage();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to parse options: " + e));
            this.usage();
        }
        return cf;
    }

    public void usage() {
        System.err.println("usage: templeton [-Dtempleton.port=N] [-D...]");
        System.exit(1);
    }

    public void run() {
        int port = conf.getInt("templeton.port", 8080);
        try {
            this.checkEnv();
            this.runServer(port);
            System.out.println("templeton: listening on port " + port);
            LOG.info((Object)("Templeton listening on port " + port));
        }
        catch (Exception e) {
            System.err.println("templeton: Server failed to start: " + e.getMessage());
            LOG.fatal((Object)("Server failed to start: " + e));
            System.exit(1);
        }
    }

    void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to stop jetty.Server", (Throwable)ex);
            }
        }
    }

    private void checkEnv() {
        this.checkCurrentDirPermissions();
    }

    private void checkCurrentDirPermissions() {
        File pwd = new File(".");
        if (!pwd.exists()) {
            String msg = "Server failed to start: templeton: Current working directory '.' does not exist!";
            System.err.println(msg);
            LOG.fatal((Object)msg);
            System.exit(1);
        }
    }

    public Server runServer(int port) throws Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)conf.kerberosPrincipal(), (String)conf.kerberosKeytab());
        }
        Server server = new Server(port);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/");
        FilterHolder fHolder = this.makeAuthFilter();
        root.addFilter(fHolder, "/templeton/v1/ddl/*", 1);
        root.addFilter(fHolder, "/templeton/v1/pig/*", 1);
        root.addFilter(fHolder, "/templeton/v1/hive/*", 1);
        root.addFilter(fHolder, "/templeton/v1/queue/*", 1);
        root.addFilter(fHolder, "/templeton/v1/jobs/*", 1);
        root.addFilter(fHolder, "/templeton/v1/mapreduce/*", 1);
        root.addFilter(fHolder, "/templeton/v1/status/*", 1);
        root.addFilter(fHolder, "/templeton/v1/version/*", 1);
        ServletHolder h = new ServletHolder((Servlet)new ServletContainer((Application)this.makeJerseyConfig()));
        root.addServlet(h, "/templeton/*");
        this.addRedirects(server);
        server.start();
        this.server = server;
        return server;
    }

    public FilterHolder makeAuthFilter() {
        FilterHolder authFilter = new FilterHolder(AuthFilter.class);
        if (UserGroupInformation.isSecurityEnabled()) {
            authFilter.setInitParameter("dfs.web.authentication.signature.secret", conf.kerberosSecret());
            authFilter.setInitParameter("dfs.web.authentication.kerberos.principal", conf.kerberosPrincipal());
            authFilter.setInitParameter("dfs.web.authentication.kerberos.keytab", conf.kerberosKeytab());
        }
        return authFilter;
    }

    public PackagesResourceConfig makeJerseyConfig() {
        PackagesResourceConfig rc = new PackagesResourceConfig(new String[]{"org.apache.hive.hcatalog.templeton"});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        props.put("com.sun.jersey.config.property.WadlGeneratorConfig", "org.apache.hive.hcatalog.templeton.WadlConfig");
        rc.setPropertiesAndFeatures(props);
        return rc;
    }

    public void addRedirects(Server server) {
        RewriteHandler rewrite = new RewriteHandler();
        RedirectPatternRule redirect = new RedirectPatternRule();
        redirect.setPattern("/templeton/v1/application.wadl");
        redirect.setLocation("/templeton/application.wadl");
        rewrite.addRule((Rule)redirect);
        HandlerList handlerlist = new HandlerList();
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(rewrite);
        for (org.eclipse.jetty.server.Handler handler : server.getHandlers()) {
            handlers.add(handler);
        }
        org.eclipse.jetty.server.Handler[] newlist = new org.eclipse.jetty.server.Handler[handlers.size()];
        handlerlist.setHandlers(handlers.toArray(newlist));
        server.setHandler((org.eclipse.jetty.server.Handler)handlerlist);
    }

    public static void main(String[] args) {
        Main templeton = new Main(args);
        templeton.run();
    }
}

