/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.thrift.TException;

public class SecureProxySupport {
    private Path tokenPath;
    private final String HCAT_SERVICE = "hcat";
    private boolean isEnabled = UserGroupInformation.isSecurityEnabled();
    private String user;
    private static final Log LOG = LogFactory.getLog(SecureProxySupport.class);

    public Path getTokenPath() {
        return this.tokenPath;
    }

    public String getHcatServiceStr() {
        return "hcat";
    }

    public Path open(String user, Configuration conf) throws IOException, InterruptedException {
        this.close();
        if (this.isEnabled) {
            String hcatTokenStr;
            this.user = user;
            File t = File.createTempFile("templeton", null);
            this.tokenPath = new Path(t.toURI());
            Token<?> fsToken = this.getFSDelegationToken(user, conf);
            try {
                hcatTokenStr = this.buildHcatDelegationToken(user);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Token msToken = new Token();
            msToken.decodeFromUrlString(hcatTokenStr);
            msToken.setService(new Text("hcat"));
            this.writeProxyDelegationTokens(fsToken, msToken, conf, user, this.tokenPath);
        }
        return this.tokenPath;
    }

    public void close() {
        if (this.tokenPath != null) {
            new File(this.tokenPath.toUri()).delete();
            this.tokenPath = null;
        }
    }

    public void addEnv(Map<String, String> env) {
        if (this.isEnabled) {
            env.put("HADOOP_TOKEN_FILE_LOCATION", this.getTokenPath().toUri().getPath());
        }
    }

    public void addArgs(List<String> args) {
        if (this.isEnabled) {
            args.add("-D");
            args.add("hive.metastore.token.signature=" + this.getHcatServiceStr());
            args.add("-D");
            args.add("proxy.user.name=" + this.user);
        }
    }

    private Token<?> getFSDelegationToken(String user, final Configuration conf) throws IOException, InterruptedException {
        LOG.info((Object)("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName()));
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        final TokenWrapper twrapper = new TokenWrapper();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileSystem fs = FileSystem.get((Configuration)conf);
                twrapper.token = fs.getDelegationToken(ugi.getShortUserName());
                return null;
            }
        });
        return twrapper.token;
    }

    private void writeProxyDelegationTokens(final Token<?> fsToken, final Token<?> msToken, final Configuration conf, String user, final Path tokenPath) throws IOException, InterruptedException {
        LOG.info((Object)("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName()));
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Credentials cred = new Credentials();
                cred.addToken(fsToken.getService(), fsToken);
                cred.addToken(msToken.getService(), msToken);
                cred.writeTokenStorageFile(tokenPath, conf);
                return null;
            }
        });
    }

    private String buildHcatDelegationToken(String user) throws IOException, InterruptedException, MetaException, TException {
        HiveConf c = new HiveConf();
        final HiveMetaStoreClient client = new HiveMetaStoreClient(c);
        LOG.info((Object)("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName()));
        TokenWrapper twrapper = new TokenWrapper();
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        String s = (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException, MetaException, TException {
                String u = ugi.getUserName();
                return client.getDelegationToken(u);
            }
        });
        return s;
    }

    class TokenWrapper {
        Token<?> token;

        TokenWrapper() {
        }
    }
}

