/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

abstract class JobIDParser {
    private String statusdir;
    private Configuration conf;

    JobIDParser(String statusdir, Configuration conf) {
        this.statusdir = statusdir;
        this.conf = conf;
    }

    private BufferedReader openStatusFile(String fname) throws IOException {
        Path p = new Path(this.statusdir, fname);
        FileSystem fs = p.getFileSystem(this.conf);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(p)));
        return in;
    }

    private List<String> findJobID(BufferedReader in, String patternAsString) throws IOException {
        String line;
        Pattern pattern = Pattern.compile(patternAsString);
        ArrayList<String> jobs = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String jobid = matcher.group(1);
            jobs.add(jobid);
        }
        return jobs;
    }

    abstract List<String> parseJobID() throws IOException;

    List<String> parseJobID(String fname, String pattern) throws IOException {
        try (BufferedReader in = null;){
            List<String> jobs;
            in = this.openStatusFile(fname);
            List<String> list = jobs = this.findJobID(in, pattern);
            return list;
        }
    }
}

