/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.UgiFactory;

public class TempletonUtils {
    public static final Pattern JAR_COMPLETE = Pattern.compile(" map \\d+%\\s+reduce \\d+%$");
    public static final Pattern PIG_COMPLETE = Pattern.compile(" \\d+% complete$");
    public static final Pattern JAR_ID = Pattern.compile(" Running job: (\\S+)$");
    public static final Pattern PIG_ID = Pattern.compile(" HadoopJobId: (\\S+)$");
    public static final Pattern[] ID_PATTERNS = new Pattern[]{JAR_ID, PIG_ID};

    public static boolean isset(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isset(char ch) {
        return ch != '\u0000';
    }

    public static <T> boolean isset(T[] a) {
        return a != null && a.length > 0;
    }

    public static <T> boolean isset(Collection<T> col) {
        return col != null && !col.isEmpty();
    }

    public static <K, V> boolean isset(Map<K, V> col) {
        return col != null && !col.isEmpty();
    }

    public static String extractPercentComplete(String line) {
        Matcher jar = JAR_COMPLETE.matcher(line);
        if (jar.find()) {
            return jar.group().trim();
        }
        Matcher pig = PIG_COMPLETE.matcher(line);
        if (pig.find()) {
            return pig.group().trim();
        }
        return null;
    }

    public static String extractChildJobId(String line) {
        for (Pattern p : ID_PATTERNS) {
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            return m.group(1);
        }
        return null;
    }

    public static String encodeArray(String[] plain) {
        if (plain == null) {
            return null;
        }
        String[] escaped = new String[plain.length];
        for (int i = 0; i < plain.length; ++i) {
            if (plain[i] == null) {
                plain[i] = "";
            }
            escaped[i] = StringUtils.escapeString((String)plain[i]);
        }
        return StringUtils.arrayToString((String[])escaped);
    }

    public static String encodeArray(List<String> list) {
        if (list == null) {
            return null;
        }
        String[] array = new String[list.size()];
        return TempletonUtils.encodeArray(list.toArray(array));
    }

    public static String[] decodeArray(String s) {
        if (s == null) {
            return null;
        }
        String[] escaped = StringUtils.split((String)s);
        String[] plain = new String[escaped.length];
        for (int i = 0; i < escaped.length; ++i) {
            plain[i] = StringUtils.unEscapeString((String)escaped[i]);
        }
        return plain;
    }

    public static String[] hadoopFsListAsArray(String files, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        if (files == null || conf == null) {
            return null;
        }
        String[] dirty = files.split(",");
        String[] clean = new String[dirty.length];
        for (int i = 0; i < dirty.length; ++i) {
            clean[i] = TempletonUtils.hadoopFsFilename(dirty[i], conf, user);
        }
        return clean;
    }

    public static String hadoopFsListAsString(String files, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        if (files == null || conf == null) {
            return null;
        }
        return StringUtils.arrayToString((String[])TempletonUtils.hadoopFsListAsArray(files, conf, user));
    }

    public static String hadoopFsFilename(String fname, Configuration conf, String user) throws URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        Path p = TempletonUtils.hadoopFsPath(fname, conf, user);
        if (p == null) {
            return null;
        }
        return p.toString();
    }

    public static boolean hadoopFsIsMissing(FileSystem fs, Path p) {
        try {
            return !fs.exists(p);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String addUserHomeDirectoryIfApplicable(String origPathStr, String user) throws IOException, URISyntaxException {
        URI uri = new URI(origPathStr);
        if (uri.getPath().isEmpty()) {
            String newPath = "/user/" + user;
            uri = UriBuilder.fromUri((URI)uri).replacePath(newPath).build(new Object[0]);
        } else if (!new Path(uri.getPath()).isAbsolute()) {
            String newPath = "/user/" + user + "/" + uri.getPath();
            uri = UriBuilder.fromUri((URI)uri).replacePath(newPath).build(new Object[0]);
        }
        return uri.toString();
    }

    public static Path hadoopFsPath(String fname, Configuration conf, String user) throws URISyntaxException, IOException, InterruptedException {
        URI u;
        Path p;
        String finalFName;
        if (fname == null || conf == null) {
            return null;
        }
        UserGroupInformation ugi = user != null ? UgiFactory.getUgi(user) : UserGroupInformation.getLoginUser();
        FileSystem defaultFs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(finalFName = new String(fname), conf){
            final /* synthetic */ String val$finalFName;
            final /* synthetic */ Configuration val$conf;
            {
                this.val$finalFName = string;
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws URISyntaxException, IOException, InterruptedException {
                return FileSystem.get((URI)new URI(this.val$finalFName), (Configuration)this.val$conf);
            }
        });
        if (TempletonUtils.hadoopFsIsMissing(defaultFs, p = new Path(u = new URI(fname = TempletonUtils.addUserHomeDirectoryIfApplicable(fname, user))).makeQualified(defaultFs))) {
            throw new FileNotFoundException("File " + fname + " does not exist.");
        }
        return p;
    }

    public static int fetchUrl(URL url) throws IOException {
        URLConnection cnx = url.openConnection();
        InputStream in = cnx.getInputStream();
        byte[] buf = new byte[8192];
        int total = 0;
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            total += len;
        }
        return total;
    }

    public static Map<String, String> hadoopUserEnv(String user, String overrideClasspath) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("HADOOP_USER_NAME", user);
        if (overrideClasspath != null) {
            env.put("HADOOP_USER_CLASSPATH_FIRST", "true");
            String cur = System.getenv("HADOOP_CLASSPATH");
            if (TempletonUtils.isset(cur)) {
                overrideClasspath = overrideClasspath + ":" + cur;
            }
            env.put("HADOOP_CLASSPATH", overrideClasspath);
        }
        return env;
    }

    public static String quoteForWindows(String param) throws BadParam {
        if (Shell.WINDOWS && param != null && param.length() > 0) {
            String nonQuotedPart = param;
            boolean addQuotes = true;
            if (param.charAt(0) == '\"' && param.charAt(param.length() - 1) == '\"') {
                if (param.length() < 2) {
                    throw new BadParam("Passed in parameter is incorrectly quoted: " + param);
                }
                addQuotes = false;
                nonQuotedPart = param.substring(1, param.length() - 1);
            }
            if (nonQuotedPart.contains("\"")) {
                throw new BadParam("Passed in parameter is incorrectly quoted: " + param);
            }
            if (addQuotes) {
                param = '\"' + param + '\"';
            }
        }
        return param;
    }

    public static void addCmdForWindows(ArrayList<String> args) {
        if (Shell.WINDOWS) {
            args.add("cmd");
            args.add("/c");
            args.add("call");
        }
    }
}

