/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrivialExecService {
    private static volatile TrivialExecService theSingleton;
    private static final Log LOG;

    public static synchronized TrivialExecService getInstance() {
        if (theSingleton == null) {
            theSingleton = new TrivialExecService();
        }
        return theSingleton;
    }

    public Process run(List<String> cmd, List<String> removeEnv, Map<String, String> environmentVariables) throws IOException {
        this.logDebugCmd(cmd, environmentVariables);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        for (String key : removeEnv) {
            pb.environment().remove(key);
        }
        pb.environment().putAll(environmentVariables);
        return pb.start();
    }

    private void logDebugCmd(List<String> cmd, Map<String, String> environmentVariables) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)("starting " + cmd));
        LOG.debug((Object)"With environment variables: ");
        for (Map.Entry<String, String> keyVal : environmentVariables.entrySet()) {
            LOG.debug((Object)(keyVal.getKey() + "=" + keyVal.getValue()));
        }
        LOG.debug((Object)"With environment variables already set: ");
        Map<String, String> env = System.getenv();
        for (String envName : env.keySet()) {
            LOG.debug((Object)(envName + "=" + env.get(envName)));
        }
    }

    static {
        LOG = LogFactory.getLog(TrivialExecService.class);
    }
}

