/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DeadlockDetector {
    private static final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();

    public static void printDeadlocks(PrintStream writer) {
        List<ThreadInfo> deadlocks = DeadlockDetector.findDeadlocks();
        if (deadlocks.isEmpty()) {
            return;
        }
        DeadlockDetector.print(writer, deadlocks);
    }

    private static void print(PrintStream writer, List<ThreadInfo> deadlocks) {
        writer.println("Deadlock detected\n=================\n");
        for (ThreadInfo thread : deadlocks) {
            writer.println(String.format("\"%s\":", thread.getThreadName()));
            writer.println(String.format("  waiting to lock Monitor of %s ", thread.getLockName()));
            writer.println(String.format("  which is held by \"%s\"", thread.getLockOwnerName()));
            writer.println();
        }
    }

    private static List<ThreadInfo> findDeadlocks() {
        long[] result = mbean.isSynchronizerUsageSupported() ? mbean.findDeadlockedThreads() : mbean.findMonitorDeadlockedThreads();
        long[] monitorDeadlockedThreads = result;
        if (monitorDeadlockedThreads == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(mbean.getThreadInfo(monitorDeadlockedThreads));
    }
}

