/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.Interrupter;
import com.google.code.tempusfugit.concurrency.TimeoutExceptionWithResults;
import com.google.code.tempusfugit.concurrency.TimeoutableCompletionService;
import com.google.code.tempusfugit.temporal.Clock;
import com.google.code.tempusfugit.temporal.Duration;
import com.google.code.tempusfugit.temporal.RealClock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;

public class DefaultTimeoutableCompletionService
implements TimeoutableCompletionService {
    private static final boolean INTERRUPT_IF_RUNNING = true;
    private static final Duration DEFAULT_TIMEOUT = Duration.seconds(30L);
    private final CompletionService completionService;
    private final Duration timeout;
    private final Clock time;

    public DefaultTimeoutableCompletionService(CompletionService completionService) {
        this(completionService, DEFAULT_TIMEOUT, RealClock.now());
    }

    public DefaultTimeoutableCompletionService(CompletionService completionService, Duration timeout, Clock time) {
        this.timeout = timeout;
        this.time = time;
        this.completionService = completionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> submit(List<? extends Callable<T>> tasks) throws ExecutionException, TimeoutException {
        ArrayList<Future<T>> submitted = new ArrayList<Future<T>>();
        try {
            for (Callable<T> task : tasks) {
                submitted.add(this.completionService.submit(task));
            }
            List<T> list = this.waitFor(tasks.size(), this.timeout);
            return list;
        }
        finally {
            for (Future future : submitted) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> waitFor(int tasks, Duration timeout) throws ExecutionException, TimeoutException {
        ArrayList completed = new ArrayList();
        Interrupter interrupter = Interrupter.interrupt(Thread.currentThread()).using(this.time).after(timeout);
        try {
            for (int i = 0; i < tasks; ++i) {
                try {
                    Future future = this.completionService.take();
                    completed.add(future.get());
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TimeoutExceptionWithResults("timed out after " + timeout.toString(), completed);
                }
            }
        }
        finally {
            interrupter.cancel();
        }
        return completed;
    }
}

