/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.ReaderWriter;
import org.apache.hcatalog.data.schema.HCatSchema;

public class DefaultHCatRecord
extends HCatRecord {
    private List<Object> contents;

    public DefaultHCatRecord() {
        this.contents = new ArrayList<Object>();
    }

    public DefaultHCatRecord(int size) {
        this.contents = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.contents.add(null);
        }
    }

    @Override
    public void remove(int idx) throws HCatException {
        this.contents.remove(idx);
    }

    public DefaultHCatRecord(List<Object> list) {
        this.contents = list;
    }

    @Override
    public Object get(int fieldNum) {
        return this.contents.get(fieldNum);
    }

    @Override
    public List<Object> getAll() {
        return this.contents;
    }

    @Override
    public void set(int fieldNum, Object val) {
        this.contents.set(fieldNum, val);
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    public void readFields(DataInput in) throws IOException {
        this.contents.clear();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.contents.add(ReaderWriter.readDatum(in));
        }
    }

    public void write(DataOutput out) throws IOException {
        int sz = this.size();
        out.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            ReaderWriter.writeDatum(out, this.contents.get(i));
        }
    }

    public int hashCode() {
        int hash = 1;
        for (Object o : this.contents) {
            if (o == null) continue;
            hash = 31 * hash + o.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object o : this.contents) {
            sb.append(o + "\t");
        }
        return sb.toString();
    }

    @Override
    public Object get(String fieldName, HCatSchema recordSchema) throws HCatException {
        return this.get(recordSchema.getPosition(fieldName));
    }

    @Override
    public void set(String fieldName, HCatSchema recordSchema, Object value) throws HCatException {
        this.set(recordSchema.getPosition(fieldName), value);
    }

    @Override
    public void copy(HCatRecord r) throws HCatException {
        this.contents = r.getAll();
    }
}

