/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.InternalUtil;
import org.apache.hcatalog.mapreduce.StorerInfo;

public class HCatTableInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private final HCatSchema dataColumns;
    private final HCatSchema partitionColumns;
    private final org.apache.hadoop.hive.metastore.api.Table table;
    private StorerInfo storerInfo;

    HCatTableInfo(String databaseName, String tableName, HCatSchema dataColumns, HCatSchema partitionColumns, StorerInfo storerInfo, org.apache.hadoop.hive.metastore.api.Table table) {
        this.databaseName = databaseName == null ? "default" : databaseName;
        this.tableName = tableName;
        this.dataColumns = dataColumns;
        this.table = table;
        this.storerInfo = storerInfo;
        this.partitionColumns = partitionColumns;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HCatSchema getDataColumns() {
        return this.dataColumns;
    }

    public HCatSchema getPartitionColumns() {
        return this.partitionColumns;
    }

    public StorerInfo getStorerInfo() {
        return this.storerInfo;
    }

    public String getTableLocation() {
        return this.table.getSd().getLocation();
    }

    org.apache.hadoop.hive.metastore.api.Table getTable() {
        return this.table;
    }

    static HCatTableInfo valueOf(org.apache.hadoop.hive.metastore.api.Table table) throws IOException {
        Table mTable = new Table(table);
        HCatSchema schema = HCatUtil.extractSchema(mTable);
        StorerInfo storerInfo = InternalUtil.extractStorerInfo(table.getSd(), table.getParameters());
        HCatSchema partitionColumns = HCatUtil.getPartitionColumns(mTable);
        return new HCatTableInfo(table.getDbName(), table.getTableName(), schema, partitionColumns, storerInfo, table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HCatTableInfo tableInfo = (HCatTableInfo)o;
        if (this.dataColumns != null ? !this.dataColumns.equals(tableInfo.dataColumns) : tableInfo.dataColumns != null) {
            return false;
        }
        if (this.databaseName != null ? !this.databaseName.equals(tableInfo.databaseName) : tableInfo.databaseName != null) {
            return false;
        }
        if (this.partitionColumns != null ? !this.partitionColumns.equals(tableInfo.partitionColumns) : tableInfo.partitionColumns != null) {
            return false;
        }
        if (this.storerInfo != null ? !this.storerInfo.equals(tableInfo.storerInfo) : tableInfo.storerInfo != null) {
            return false;
        }
        if (this.table != null ? !this.table.equals(tableInfo.table) : tableInfo.table != null) {
            return false;
        }
        return !(this.tableName != null ? !this.tableName.equals(tableInfo.tableName) : tableInfo.tableName != null);
    }

    public int hashCode() {
        int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.dataColumns != null ? this.dataColumns.hashCode() : 0);
        result = 31 * result + (this.partitionColumns != null ? this.partitionColumns.hashCode() : 0);
        result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
        result = 31 * result + (this.storerInfo != null ? this.storerInfo.hashCode() : 0);
        return result;
    }
}

