/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data.transfer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.hcatalog.mapreduce.HCatSplit;

public class ReaderContext
implements Externalizable,
Configurable {
    private static final long serialVersionUID = -2656468331739574367L;
    private List<InputSplit> splits = new ArrayList<InputSplit>();
    private Configuration conf = new Configuration();

    public void setInputSplits(List<InputSplit> splits) {
        this.splits = splits;
    }

    public List<InputSplit> getSplits() {
        return this.splits;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration config) {
        this.conf = config;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.conf.write((DataOutput)out);
        out.writeInt(this.splits.size());
        for (InputSplit split : this.splits) {
            ((HCatSplit)split).write(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.conf.readFields((DataInput)in);
        int numOfSplits = in.readInt();
        for (int i = 0; i < numOfSplits; ++i) {
            HCatSplit split = new HCatSplit();
            split.readFields(in);
            this.splits.add(split);
        }
    }
}

