/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroKeyDeserializer;
import org.apache.avro.hadoop.io.AvroSerializer;
import org.apache.avro.hadoop.io.AvroValueDeserializer;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSerialization<T>
extends Configured
implements Serialization<AvroWrapper<T>> {
    private static final String CONF_KEY_WRITER_SCHEMA = "avro.serialization.key.writer.schema";
    private static final String CONF_KEY_READER_SCHEMA = "avro.serialization.key.reader.schema";
    private static final String CONF_VALUE_WRITER_SCHEMA = "avro.serialization.value.writer.schema";
    private static final String CONF_VALUE_READER_SCHEMA = "avro.serialization.value.reader.schema";

    public boolean accept(Class<?> c) {
        return AvroKey.class.isAssignableFrom(c) || AvroValue.class.isAssignableFrom(c);
    }

    public Deserializer<AvroWrapper<T>> getDeserializer(Class<AvroWrapper<T>> c) {
        Configuration conf = this.getConf();
        if (AvroKey.class.isAssignableFrom(c)) {
            return new AvroKeyDeserializer(AvroSerialization.getKeyWriterSchema(conf), AvroSerialization.getKeyReaderSchema(conf));
        }
        if (AvroValue.class.isAssignableFrom(c)) {
            return new AvroValueDeserializer(AvroSerialization.getValueWriterSchema(conf), AvroSerialization.getValueReaderSchema(conf));
        }
        throw new IllegalStateException("Only AvroKey and AvroValue are supported.");
    }

    public Serializer<AvroWrapper<T>> getSerializer(Class<AvroWrapper<T>> c) {
        Schema schema;
        if (AvroKey.class.isAssignableFrom(c)) {
            schema = AvroSerialization.getKeyWriterSchema(this.getConf());
        } else if (AvroValue.class.isAssignableFrom(c)) {
            schema = AvroSerialization.getValueWriterSchema(this.getConf());
        } else {
            throw new IllegalStateException("Only AvroKey and AvroValue are supported.");
        }
        return new AvroSerializer(schema);
    }

    public static void addToConfiguration(Configuration conf) {
        Collection serializations = conf.getStringCollection("io.serializations");
        if (!serializations.contains(AvroSerialization.class.getName())) {
            serializations.add(AvroSerialization.class.getName());
            conf.setStrings("io.serializations", serializations.toArray(new String[serializations.size()]));
        }
    }

    public static void setKeyWriterSchema(Configuration conf, Schema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        conf.set(CONF_KEY_WRITER_SCHEMA, schema.toString());
    }

    public static void setKeyReaderSchema(Configuration conf, Schema schema) {
        conf.set(CONF_KEY_READER_SCHEMA, schema.toString());
    }

    public static void setValueWriterSchema(Configuration conf, Schema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        conf.set(CONF_VALUE_WRITER_SCHEMA, schema.toString());
    }

    public static void setValueReaderSchema(Configuration conf, Schema schema) {
        conf.set(CONF_VALUE_READER_SCHEMA, schema.toString());
    }

    public static Schema getKeyWriterSchema(Configuration conf) {
        String json = conf.get(CONF_KEY_WRITER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getKeyReaderSchema(Configuration conf) {
        String json = conf.get(CONF_KEY_READER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getValueWriterSchema(Configuration conf) {
        String json = conf.get(CONF_VALUE_WRITER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getValueReaderSchema(Configuration conf) {
        String json = conf.get(CONF_VALUE_READER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }
}

