/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class ExprNodeColumnEvaluator
extends ExprNodeEvaluator<ExprNodeColumnDesc> {
    transient boolean simpleCase;
    transient StructObjectInspector inspector;
    transient StructField field;
    transient StructObjectInspector[] inspectors;
    transient StructField[] fields;
    transient boolean[] unionField;

    public ExprNodeColumnEvaluator(ExprNodeColumnDesc expr) {
        super(expr);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        String[] names = ((ExprNodeColumnDesc)this.expr).getColumn().split("\\.");
        String[] unionfields = names[0].split("\\:");
        if (names.length == 1 && unionfields.length == 1) {
            this.simpleCase = true;
            this.inspector = (StructObjectInspector)rowInspector;
            this.field = this.inspector.getStructFieldRef(names[0]);
            this.outputOI = this.field.getFieldObjectInspector();
            return this.outputOI;
        }
        this.simpleCase = false;
        this.inspectors = new StructObjectInspector[names.length];
        this.fields = new StructField[names.length];
        this.unionField = new boolean[names.length];
        int unionIndex = -1;
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                this.inspectors[0] = (StructObjectInspector)rowInspector;
            } else {
                this.inspectors[i] = unionIndex != -1 ? (StructObjectInspector)((UnionObjectInspector)this.fields[i - 1].getFieldObjectInspector()).getObjectInspectors().get(unionIndex) : (StructObjectInspector)this.fields[i - 1].getFieldObjectInspector();
            }
            unionfields = names[i].split("\\:");
            this.fields[i] = this.inspectors[i].getStructFieldRef(unionfields[0]);
            if (unionfields.length > 1) {
                unionIndex = Integer.parseInt(unionfields[1]);
                this.unionField[i] = true;
                continue;
            }
            unionIndex = -1;
            this.unionField[i] = false;
        }
        this.outputOI = this.fields[names.length - 1].getFieldObjectInspector();
        return this.outputOI;
    }

    @Override
    protected Object _evaluate(Object row, int version) throws HiveException {
        if (this.simpleCase) {
            return this.inspector.getStructFieldData(row, this.field);
        }
        Object o = row;
        for (int i = 0; i < this.fields.length; ++i) {
            o = this.inspectors[i].getStructFieldData(o, this.fields[i]);
            if (!this.unionField[i]) continue;
            o = ((StandardUnionObjectInspector.StandardUnion)o).getObject();
        }
        return o;
    }
}

