/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;

abstract class InStream
extends InputStream {
    InStream() {
    }

    public abstract void seek(PositionProvider var1) throws IOException;

    public static InStream create(String name, ByteBuffer[] input, long[] offsets, long length, CompressionCodec codec, int bufferSize) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, input, offsets, length);
        }
        return new CompressedStream(name, input, offsets, length, codec, bufferSize);
    }

    private static class CompressedStream
    extends InStream {
        private final String name;
        private final ByteBuffer[] bytes;
        private final long[] offsets;
        private final int bufferSize;
        private final long length;
        private ByteBuffer uncompressed = null;
        private final CompressionCodec codec;
        private byte[] compressed = null;
        private long currentOffset;
        private int currentRange;
        private int offsetInCompressed;
        private int limitInCompressed;
        private boolean isUncompressedOriginal;

        public CompressedStream(String name, ByteBuffer[] input, long[] offsets, long length, CompressionCodec codec, int bufferSize) {
            this.bytes = input;
            this.name = name;
            this.codec = codec;
            this.length = length;
            this.offsets = offsets;
            this.bufferSize = bufferSize;
            this.currentOffset = 0L;
            this.currentRange = 0;
            this.offsetInCompressed = 0;
            this.limitInCompressed = 0;
        }

        private void readHeader() throws IOException {
            if (this.compressed == null || this.offsetInCompressed >= this.limitInCompressed) {
                this.seek(this.currentOffset);
            }
            if (this.limitInCompressed - this.offsetInCompressed > 3) {
                int chunkLength = (0xFF & this.compressed[this.offsetInCompressed + 2]) << 15 | (0xFF & this.compressed[this.offsetInCompressed + 1]) << 7 | (0xFF & this.compressed[this.offsetInCompressed]) >> 1;
                if (chunkLength > this.bufferSize) {
                    throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
                }
                boolean isOriginal = (this.compressed[this.offsetInCompressed] & 1) == 1;
                this.offsetInCompressed += 3;
                if (isOriginal) {
                    this.isUncompressedOriginal = true;
                    this.uncompressed = this.bytes[this.currentRange].duplicate();
                    this.uncompressed.position(this.offsetInCompressed - this.bytes[this.currentRange].arrayOffset());
                    this.uncompressed.limit(this.offsetInCompressed + chunkLength);
                } else {
                    if (this.isUncompressedOriginal) {
                        this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                        this.isUncompressedOriginal = false;
                    } else if (this.uncompressed == null) {
                        this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                    } else {
                        this.uncompressed.clear();
                    }
                    this.codec.decompress(ByteBuffer.wrap(this.compressed, this.offsetInCompressed, chunkLength), this.uncompressed);
                }
                this.offsetInCompressed += chunkLength;
                this.currentOffset += (long)(chunkLength + 3);
            } else {
                throw new IllegalStateException("Can't read header at " + this);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.readHeader();
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.readHeader();
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            System.arraycopy(this.uncompressed.array(), this.uncompressed.arrayOffset() + this.uncompressed.position(), data, offset, actualLength);
            this.uncompressed.position(this.uncompressed.position() + actualLength);
            return actualLength;
        }

        @Override
        public int available() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return 0;
                }
                this.readHeader();
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.uncompressed = null;
            this.currentRange = this.bytes.length;
            this.offsetInCompressed = 0;
            this.limitInCompressed = 0;
            this.currentOffset = this.length;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
            long uncompressedBytes = index.getNext();
            if (uncompressedBytes != 0L) {
                this.readHeader();
                this.uncompressed.position(this.uncompressed.position() + (int)uncompressedBytes);
            } else if (this.uncompressed != null) {
                this.uncompressed.position(this.uncompressed.limit());
            }
        }

        private void seek(long desired) throws IOException {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.offsets[i] > desired || desired - this.offsets[i] >= (long)this.bytes[i].remaining()) continue;
                this.currentRange = i;
                this.compressed = this.bytes[i].array();
                this.offsetInCompressed = (int)((long)(this.bytes[i].arrayOffset() + this.bytes[i].position()) + (desired - this.offsets[i]));
                this.currentOffset = desired;
                this.limitInCompressed = this.bytes[i].arrayOffset() + this.bytes[i].limit();
                return;
            }
            int segments = this.bytes.length;
            if (segments != 0 && desired == this.offsets[segments - 1] + (long)this.bytes[segments - 1].remaining()) {
                this.currentRange = segments - 1;
                this.compressed = this.bytes[this.currentRange].array();
                this.offsetInCompressed = this.bytes[this.currentRange].arrayOffset() + this.bytes[this.currentRange].limit();
                this.currentOffset = desired;
                this.limitInCompressed = this.offsetInCompressed;
                return;
            }
            throw new IOException("Seek outside of data in " + this + " to " + desired);
        }

        private String rangeString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.offsets.length; ++i) {
                if (i != 0) {
                    builder.append("; ");
                }
                builder.append(" range " + i + " = " + this.offsets[i] + " to " + this.bytes[i].remaining());
            }
            return builder.toString();
        }

        public String toString() {
            return "compressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + this.offsetInCompressed + " limit: " + this.limitInCompressed + this.rangeString() + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    private static class UncompressedStream
    extends InStream {
        private final String name;
        private final ByteBuffer[] bytes;
        private final long[] offsets;
        private final long length;
        private long currentOffset;
        private byte[] range;
        private int currentRange;
        private int offsetInRange;
        private int limitInRange;

        public UncompressedStream(String name, ByteBuffer[] input, long[] offsets, long length) {
            this.name = name;
            this.bytes = input;
            this.offsets = offsets;
            this.length = length;
            this.currentRange = 0;
            this.offsetInRange = 0;
            this.limitInRange = 0;
            this.currentOffset = 0L;
        }

        @Override
        public int read() {
            if (this.offsetInRange >= this.limitInRange) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            ++this.currentOffset;
            return 0xFF & this.range[this.offsetInRange++];
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (this.offsetInRange >= this.limitInRange) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            int actualLength = Math.min(length, this.limitInRange - this.offsetInRange);
            System.arraycopy(this.range, this.offsetInRange, data, offset, actualLength);
            this.offsetInRange += actualLength;
            this.currentOffset += (long)actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            if (this.offsetInRange < this.limitInRange) {
                return this.limitInRange - this.offsetInRange;
            }
            return (int)(this.length - this.currentOffset);
        }

        @Override
        public void close() {
            this.currentRange = this.bytes.length;
            this.currentOffset = this.length;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
        }

        public void seek(long desired) {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.offsets[i] > desired || desired - this.offsets[i] >= (long)this.bytes[i].remaining()) continue;
                this.currentOffset = desired;
                this.currentRange = i;
                this.range = this.bytes[i].array();
                this.offsetInRange = this.bytes[i].arrayOffset() + this.bytes[i].position();
                this.limitInRange = this.bytes[i].arrayOffset() + this.bytes[i].limit();
                this.offsetInRange = (int)((long)this.offsetInRange + (desired - this.offsets[i]));
                return;
            }
            throw new IllegalArgumentException("Seek in " + this.name + " to " + desired + " is outside of the data");
        }

        public String toString() {
            return "uncompressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + this.offsetInRange + " limit: " + this.limitInRange;
        }
    }
}

