/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.protobuf.GeneratedMessage;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.BitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerReader;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReaderV2;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

class RecordReaderImpl
implements RecordReader {
    private static final Log LOG = LogFactory.getLog(RecordReaderImpl.class);
    private final FSDataInputStream file;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final List<OrcProto.Type> types;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = -1;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    private final TreeReader reader;
    private final OrcProto.RowIndex[] indexes;
    private final SearchArgument sarg;
    private final List<PredicateLeaf> sargLeaves;
    private final int[] filterColumns;
    private boolean[] includedRowGroups = null;
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    RecordReaderImpl(Iterable<StripeInformation> stripes, FileSystem fileSystem, Path path, long offset, long length, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, boolean[] included, long strideRate, SearchArgument sarg, String[] columnNames) throws IOException {
        this.file = fileSystem.open(path);
        this.codec = codec;
        this.types = types;
        this.bufferSize = bufferSize;
        this.included = included;
        this.sarg = sarg;
        if (sarg != null) {
            this.sargLeaves = sarg.getLeaves();
            this.filterColumns = new int[this.sargLeaves.size()];
            for (int i = 0; i < this.filterColumns.length; ++i) {
                String colName = this.sargLeaves.get(i).getColumnName();
                this.filterColumns[i] = RecordReaderImpl.findColumns(columnNames, colName);
            }
        } else {
            this.sargLeaves = null;
            this.filterColumns = null;
        }
        long rows = 0L;
        long skippedRows = 0L;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= offset + length) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        this.reader = RecordReaderImpl.createTreeReader(path, 0, types, included);
        this.indexes = new OrcProto.RowIndex[types.size()];
        this.rowIndexStride = strideRate;
        this.advanceToNextRow(0L);
    }

    private static int findColumns(String[] columnNames, String columnName) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return i;
        }
        return -1;
    }

    private static TreeReader createTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new BooleanTreeReader(path, columnId);
            }
            case BYTE: {
                return new ByteTreeReader(path, columnId);
            }
            case DOUBLE: {
                return new DoubleTreeReader(path, columnId);
            }
            case FLOAT: {
                return new FloatTreeReader(path, columnId);
            }
            case SHORT: {
                return new ShortTreeReader(path, columnId);
            }
            case INT: {
                return new IntTreeReader(path, columnId);
            }
            case LONG: {
                return new LongTreeReader(path, columnId);
            }
            case STRING: {
                return new StringTreeReader(path, columnId);
            }
            case VARCHAR: {
                if (!type.hasMaximumLength()) {
                    throw new IllegalArgumentException("ORC varchar type has no length specified");
                }
                return new VarcharTreeReader(path, columnId, type.getMaximumLength());
            }
            case BINARY: {
                return new BinaryTreeReader(path, columnId);
            }
            case TIMESTAMP: {
                return new TimestampTreeReader(path, columnId);
            }
            case DATE: {
                return new DateTreeReader(path, columnId);
            }
            case DECIMAL: {
                return new DecimalTreeReader(path, columnId);
            }
            case STRUCT: {
                return new StructTreeReader(path, columnId, types, included);
            }
            case LIST: {
                return new ListTreeReader(path, columnId, types, included);
            }
            case MAP: {
                return new MapTreeReader(path, columnId, types, included);
            }
            case UNION: {
                return new UnionTreeReader(path, columnId, types, included);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.getKind());
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = (int)stripe.getFooterLength();
        ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
        this.file.seek(offset);
        this.file.readFully(tailBuf.array(), tailBuf.arrayOffset(), tailLength);
        return OrcProto.StripeFooter.parseFrom(InStream.create("footer", new ByteBuffer[]{tailBuf}, new long[]{0L}, tailLength, this.codec, this.bufferSize));
    }

    static <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        if (maxCompare == 0) {
            return Location.MAX;
        }
        return Location.MIDDLE;
    }

    static Object getMin(OrcProto.ColumnStatistics index) {
        GeneratedMessage stat;
        if (index.hasIntStatistics() && ((OrcProto.IntegerStatistics)(stat = index.getIntStatistics())).hasMinimum()) {
            return ((OrcProto.IntegerStatistics)stat).getMinimum();
        }
        if (index.hasStringStatistics() && ((OrcProto.StringStatistics)(stat = index.getStringStatistics())).hasMinimum()) {
            return ((OrcProto.StringStatistics)stat).getMinimum();
        }
        if (index.hasDoubleStatistics() && ((OrcProto.DoubleStatistics)(stat = index.getDoubleStatistics())).hasMinimum()) {
            return ((OrcProto.DoubleStatistics)stat).getMinimum();
        }
        return null;
    }

    static Object getMax(OrcProto.ColumnStatistics index) {
        GeneratedMessage stat;
        if (index.hasIntStatistics() && ((OrcProto.IntegerStatistics)(stat = index.getIntStatistics())).hasMaximum()) {
            return ((OrcProto.IntegerStatistics)stat).getMaximum();
        }
        if (index.hasStringStatistics() && ((OrcProto.StringStatistics)(stat = index.getStringStatistics())).hasMaximum()) {
            return ((OrcProto.StringStatistics)stat).getMaximum();
        }
        if (index.hasDoubleStatistics() && ((OrcProto.DoubleStatistics)(stat = index.getDoubleStatistics())).hasMaximum()) {
            return ((OrcProto.DoubleStatistics)stat).getMaximum();
        }
        return null;
    }

    static SearchArgument.TruthValue evaluatePredicate(OrcProto.ColumnStatistics index, PredicateLeaf predicate) {
        Object minValue = RecordReaderImpl.getMin(index);
        if (minValue == null) {
            if (predicate.getOperator() == PredicateLeaf.Operator.IS_NULL) {
                return SearchArgument.TruthValue.YES;
            }
            return SearchArgument.TruthValue.NULL;
        }
        Object maxValue = RecordReaderImpl.getMax(index);
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predicate.getLiteral(), minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO;
                }
                return SearchArgument.TruthValue.YES_NO;
            }
            case EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predicate.getLiteral(), minValue, maxValue);
                if (minValue.equals(maxValue) && loc == Location.MIN) {
                    return SearchArgument.TruthValue.YES_NULL;
                }
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO_NULL;
                }
                return SearchArgument.TruthValue.YES_NO_NULL;
            }
            case LESS_THAN: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predicate.getLiteral(), minValue, maxValue);
                if (loc == Location.AFTER) {
                    return SearchArgument.TruthValue.YES_NULL;
                }
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    return SearchArgument.TruthValue.NO_NULL;
                }
                return SearchArgument.TruthValue.YES_NO_NULL;
            }
            case LESS_THAN_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predicate.getLiteral(), minValue, maxValue);
                if (loc == Location.AFTER || loc == Location.MAX) {
                    return SearchArgument.TruthValue.YES_NULL;
                }
                if (loc == Location.BEFORE) {
                    return SearchArgument.TruthValue.NO_NULL;
                }
                return SearchArgument.TruthValue.YES_NO_NULL;
            }
            case IN: {
                if (minValue.equals(maxValue)) {
                    for (Object arg : predicate.getLiteralList()) {
                        Location loc = RecordReaderImpl.compareToRange((Comparable)arg, minValue, maxValue);
                        if (loc != Location.MIN) continue;
                        return SearchArgument.TruthValue.YES_NULL;
                    }
                    return SearchArgument.TruthValue.NO_NULL;
                }
                for (Object arg : predicate.getLiteralList()) {
                    Location loc = RecordReaderImpl.compareToRange((Comparable)arg, minValue, maxValue);
                    if (loc != Location.MIN && loc != Location.MIDDLE && loc != Location.MAX) continue;
                    return SearchArgument.TruthValue.YES_NO_NULL;
                }
                return SearchArgument.TruthValue.NO_NULL;
            }
            case BETWEEN: {
                List<Object> args = predicate.getLiteralList();
                Location loc = RecordReaderImpl.compareToRange((Comparable)args.get(0), minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    Location loc2 = RecordReaderImpl.compareToRange((Comparable)args.get(1), minValue, maxValue);
                    if (loc2 == Location.AFTER || loc2 == Location.MAX) {
                        return SearchArgument.TruthValue.YES_NULL;
                    }
                    if (loc2 == Location.BEFORE) {
                        return SearchArgument.TruthValue.NO_NULL;
                    }
                    return SearchArgument.TruthValue.YES_NO_NULL;
                }
                if (loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO_NULL;
                }
                return SearchArgument.TruthValue.YES_NO_NULL;
            }
            case IS_NULL: {
                return SearchArgument.TruthValue.YES_NO;
            }
        }
        return SearchArgument.TruthValue.YES_NO_NULL;
    }

    private boolean[] pickRowGroups() throws IOException {
        if (this.sarg == null || this.rowIndexStride == 0L) {
            return null;
        }
        this.readRowIndex();
        long rowsInStripe = this.stripes.get(this.currentStripe).getNumberOfRows();
        int groupsInStripe = (int)((rowsInStripe + this.rowIndexStride - 1L) / this.rowIndexStride);
        boolean[] result = new boolean[groupsInStripe];
        SearchArgument.TruthValue[] leafValues = new SearchArgument.TruthValue[this.sargLeaves.size()];
        for (int rowGroup = 0; rowGroup < result.length; ++rowGroup) {
            for (int pred = 0; pred < leafValues.length; ++pred) {
                if (this.filterColumns[pred] != -1) {
                    OrcProto.ColumnStatistics stats = this.indexes[this.filterColumns[pred]].getEntry(rowGroup).getStatistics();
                    leafValues[pred] = RecordReaderImpl.evaluatePredicate(stats, this.sargLeaves.get(pred));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Stats = " + stats));
                    LOG.debug((Object)("Setting " + this.sargLeaves.get(pred) + " to " + (Object)((Object)leafValues[pred])));
                    continue;
                }
                leafValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
            }
            result[rowGroup] = this.sarg.evaluate(leafValues).isNotNeeded();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Row group " + this.rowIndexStride * (long)rowGroup + " to " + (this.rowIndexStride * (long)(rowGroup + 1) - 1L) + " is " + (result[rowGroup] ? "" : "not ") + "included."));
        }
        for (boolean b : result) {
            if (b) continue;
            return result;
        }
        return null;
    }

    private void readStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        this.streams.clear();
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowInStripe = 0L;
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
        this.includedRowGroups = this.pickRowGroups();
        if (this.includedRowGroups != null) {
            while (this.rowInStripe < this.rowCountInStripe && !this.includedRowGroups[(int)(this.rowInStripe / this.rowIndexStride)]) {
                this.rowInStripe = Math.min(this.rowCountInStripe, this.rowInStripe + this.rowIndexStride);
            }
        }
        if (this.rowInStripe < this.rowCountInStripe) {
            if (this.included == null && this.includedRowGroups == null) {
                this.readAllDataStreams(stripe);
            } else {
                this.readPartialDataStreams(stripe);
            }
            this.reader.startStripe(this.streams, this.stripeFooter.getColumnsList());
            if (this.rowInStripe != 0L) {
                this.seekToRowEntry((int)(this.rowInStripe / this.rowIndexStride));
            }
        }
    }

    private void readAllDataStreams(StripeInformation stripe) throws IOException {
        byte[] buffer = new byte[(int)stripe.getDataLength()];
        this.file.seek(stripe.getOffset() + stripe.getIndexLength());
        this.file.readFully(buffer, 0, buffer.length);
        int sectionOffset = 0;
        for (OrcProto.Stream section : this.stripeFooter.getStreamsList()) {
            if (StreamName.getArea(section.getKind()) != StreamName.Area.DATA) continue;
            int sectionLength = (int)section.getLength();
            ByteBuffer sectionBuffer = ByteBuffer.wrap(buffer, sectionOffset, sectionLength);
            StreamName name = new StreamName(section.getColumn(), section.getKind());
            this.streams.put(name, InStream.create(name.toString(), new ByteBuffer[]{sectionBuffer}, new long[]{0L}, sectionLength, this.codec, this.bufferSize));
            sectionOffset += sectionLength;
        }
    }

    static int getIndexPosition(OrcProto.ColumnEncoding.Kind encoding, OrcProto.Type.Kind type, OrcProto.Stream.Kind stream, boolean isCompressed, boolean hasNulls) {
        if (stream == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case INT: 
            case LONG: 
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return base;
            }
            case STRING: {
                if (encoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || encoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case DECIMAL: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    static List<DiskRange> planReadPartialDataStreams(List<OrcProto.Stream> streamList, OrcProto.RowIndex[] indexes, boolean[] includedColumns, boolean[] includedRowGroups, boolean isCompressed, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Type> types, int compressionSize) {
        ArrayList<DiskRange> result = new ArrayList<DiskRange>();
        long offset = 0L;
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int column = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (StreamName.getArea(streamKind) == StreamName.Area.DATA && includedColumns[column]) {
                if (includedRowGroups == null || RecordReaderImpl.isDictionary(streamKind, encodings.get(column))) {
                    result.add(new DiskRange(offset, offset + length));
                } else {
                    for (int group = 0; group < includedRowGroups.length; ++group) {
                        if (!includedRowGroups[group]) continue;
                        int posn = RecordReaderImpl.getIndexPosition(encodings.get(column).getKind(), types.get(column).getKind(), stream.getKind(), isCompressed, hasNull[column]);
                        long start = indexes[column].getEntry(group).getPositions(posn);
                        long end = group == includedRowGroups.length - 1 ? length : Math.min(length, indexes[column].getEntry(group + 1).getPositions(posn) + (long)(isCompressed ? 3 + compressionSize : 4098));
                        result.add(new DiskRange(offset + start, offset + end));
                    }
                }
            }
            offset += length;
        }
        return result;
    }

    static void mergeDiskRanges(List<DiskRange> ranges) {
        DiskRange prev = null;
        for (int i = 0; i < ranges.size(); ++i) {
            DiskRange current = ranges.get(i);
            if (prev != null && RecordReaderImpl.overlap(prev.offset, prev.end, current.offset, current.end)) {
                prev.offset = Math.min(prev.offset, current.offset);
                prev.end = Math.max(prev.end, current.end);
                ranges.remove(i);
                --i;
                continue;
            }
            prev = current;
        }
    }

    static byte[][] readDiskRanges(FSDataInputStream file, long base, List<DiskRange> ranges) throws IOException {
        byte[][] result = new byte[ranges.size()][];
        int i = 0;
        for (DiskRange range : ranges) {
            int len = (int)(range.end - range.offset);
            result[i] = new byte[len];
            file.seek(base + range.offset);
            file.readFully(result[i]);
            ++i;
        }
        return result;
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    static String stringifyDiskRanges(List<DiskRange> ranges) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < ranges.size(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(ranges.get(i).toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    static void createStreams(List<OrcProto.Stream> streamDescriptions, List<DiskRange> ranges, byte[][] bytes, boolean[] includeColumn, CompressionCodec codec, int bufferSize, Map<StreamName, InStream> streams) throws IOException {
        long offset = 0L;
        for (OrcProto.Stream streamDesc : streamDescriptions) {
            int column = streamDesc.getColumn();
            if (includeColumn[column] && StreamName.getArea(streamDesc.getKind()) == StreamName.Area.DATA) {
                long length = streamDesc.getLength();
                int first = -1;
                int last = -2;
                for (int i = 0; i < bytes.length; ++i) {
                    DiskRange range = ranges.get(i);
                    if (!RecordReaderImpl.overlap(offset, offset + length, range.offset, range.end)) continue;
                    if (first == -1) {
                        first = i;
                    }
                    last = i;
                }
                ByteBuffer[] buffers = new ByteBuffer[last - first + 1];
                long[] offsets = new long[last - first + 1];
                for (int i = 0; i < buffers.length; ++i) {
                    DiskRange range = ranges.get(i + first);
                    long start = Math.max(range.offset, offset);
                    long end = Math.min(range.end, offset + length);
                    buffers[i] = ByteBuffer.wrap(bytes[first + i], Math.max(0, (int)(offset - range.offset)), (int)(end - start));
                    offsets[i] = Math.max(0L, range.offset - offset);
                }
                StreamName name = new StreamName(column, streamDesc.getKind());
                streams.put(name, InStream.create(name.toString(), buffers, offsets, length, codec, bufferSize));
            }
            offset += streamDesc.getLength();
        }
    }

    private void readPartialDataStreams(StripeInformation stripe) throws IOException {
        List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
        List<DiskRange> chunks = RecordReaderImpl.planReadPartialDataStreams(streamList, this.indexes, this.included, this.includedRowGroups, this.codec != null, this.stripeFooter.getColumnsList(), this.types, this.bufferSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("chunks = " + RecordReaderImpl.stringifyDiskRanges(chunks)));
        }
        RecordReaderImpl.mergeDiskRanges(chunks);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge = " + RecordReaderImpl.stringifyDiskRanges(chunks)));
        }
        byte[][] bytes = RecordReaderImpl.readDiskRanges(this.file, stripe.getOffset(), chunks);
        RecordReaderImpl.createStreams(streamList, chunks, bytes, this.included, this.codec, this.bufferSize, this.streams);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe;
    }

    private void advanceStripe() throws IOException {
        this.rowInStripe = this.rowCountInStripe;
        while (this.rowInStripe >= this.rowCountInStripe && this.currentStripe < this.stripes.size() - 1) {
            ++this.currentStripe;
            this.readStripe();
        }
    }

    private void advanceToNextRow(long nextRow) throws IOException {
        int rowGroup;
        long nextRowInStripe = nextRow - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && nextRowInStripe < this.rowCountInStripe && !this.includedRowGroups[rowGroup = (int)(nextRowInStripe / this.rowIndexStride)]) {
            while (rowGroup < this.includedRowGroups.length && !this.includedRowGroups[rowGroup]) {
                ++rowGroup;
            }
            if (rowGroup >= this.includedRowGroups.length) {
                this.advanceStripe();
                return;
            }
            nextRowInStripe = Math.min(this.rowCountInStripe, (long)rowGroup * this.rowIndexStride);
        }
        if (nextRowInStripe < this.rowCountInStripe) {
            if (nextRowInStripe != this.rowInStripe) {
                if (this.rowIndexStride != 0L) {
                    rowGroup = (int)(nextRowInStripe / this.rowIndexStride);
                    this.seekToRowEntry(rowGroup);
                    this.reader.skipRows(nextRowInStripe - (long)rowGroup * this.rowIndexStride);
                } else {
                    this.reader.skipRows(nextRowInStripe - this.rowInStripe);
                }
                this.rowInStripe = nextRowInStripe;
            }
        } else {
            this.advanceStripe();
        }
    }

    @Override
    public Object next(Object previous) throws IOException {
        Object result = this.reader.next(previous);
        ++this.rowInStripe;
        this.advanceToNextRow(this.rowInStripe + this.rowBaseInStripe);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    private void readRowIndex() throws IOException {
        long offset = this.stripes.get(this.currentStripe).getOffset();
        for (OrcProto.Stream stream : this.stripeFooter.getStreamsList()) {
            if (stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                int col = stream.getColumn();
                if ((this.included == null || this.included[col]) && this.indexes[col] == null) {
                    byte[] buffer = new byte[(int)stream.getLength()];
                    this.file.seek(offset);
                    this.file.readFully(buffer);
                    this.indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", new ByteBuffer[]{ByteBuffer.wrap(buffer)}, new long[]{0L}, stream.getLength(), this.codec, this.bufferSize));
                }
            }
            offset += stream.getLength();
        }
    }

    private void seekToRowEntry(int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        this.reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        int rightStripe = this.findStripe(rowNumber -= this.firstRow);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex();
        this.advanceToNextRow(rowNumber);
    }

    static class DiskRange {
        long offset;
        long end;

        DiskRange(long offset, long end) {
            this.offset = offset;
            this.end = end;
            if (end < offset) {
                throw new IllegalArgumentException("invalid range " + this);
            }
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            DiskRange otherR = (DiskRange)other;
            return otherR.offset == this.offset && otherR.end == this.end;
        }

        public String toString() {
            return "range start: " + this.offset + " end: " + this.end;
        }
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }

    private static class MapTreeReader
    extends TreeReader {
        private final TreeReader keyReader;
        private final TreeReader valueReader;
        private IntegerReader lengths = null;

        MapTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(path, columnId);
            OrcProto.Type type = types.get(columnId);
            int keyColumn = type.getSubtypes(0);
            int valueColumn = type.getSubtypes(1);
            this.keyReader = included == null || included[keyColumn] ? RecordReaderImpl.createTreeReader(path, keyColumn, types, included) : null;
            this.valueReader = included == null || included[valueColumn] ? RecordReaderImpl.createTreeReader(path, valueColumn, types, included) : null;
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.keyReader.seek(index);
            this.valueReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            HashMap<Object, Object> result = null;
            if (this.valuePresent) {
                result = previous == null ? new HashMap<Object, Object>() : (HashMap<Object, Object>)previous;
                result.clear();
                int length = (int)this.lengths.next();
                for (int i = 0; i < length; ++i) {
                    result.put(this.keyReader.next(null), this.valueReader.next(null));
                }
            }
            return result;
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.keyReader != null) {
                this.keyReader.startStripe(streams, encodings);
            }
            if (this.valueReader != null) {
                this.valueReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.keyReader.skipRows(childSkip);
            this.valueReader.skipRows(childSkip);
        }
    }

    private static class ListTreeReader
    extends TreeReader {
        private final TreeReader elementReader;
        private IntegerReader lengths = null;

        ListTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(path, columnId);
            OrcProto.Type type = types.get(columnId);
            this.elementReader = RecordReaderImpl.createTreeReader(path, type.getSubtypes(0), types, included);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.elementReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ArrayList<Object> result = null;
            if (this.valuePresent) {
                int i;
                result = previous == null ? new ArrayList<Object>() : (ArrayList<Object>)previous;
                int prevLength = result.size();
                int length = (int)this.lengths.next();
                for (i = prevLength; i < length; ++i) {
                    result.add(null);
                }
                for (i = 0; i < length; ++i) {
                    result.set(i, this.elementReader.next(i < prevLength ? result.get(i) : null));
                }
                for (i = prevLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            }
            return result;
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.elementReader != null) {
                this.elementReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.elementReader.skipRows(childSkip);
        }
    }

    private static class UnionTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private RunLengthByteReader tags;

        UnionTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(path, columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new TreeReader[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included != null && !included[subtype]) continue;
                this.fields[i] = RecordReaderImpl.createTreeReader(path, subtype, types, included);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.tags.seek(index[this.columnId]);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcUnion result = null;
            if (this.valuePresent) {
                result = previous == null ? new OrcUnion() : (OrcUnion)previous;
                byte tag = this.tags.next();
                Object previousVal = result.getObject();
                result.set(tag, this.fields[tag].next(tag == result.getTag() ? previousVal : null));
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long[] counts = new long[this.fields.length];
            int i = 0;
            while ((long)i < items) {
                byte by = this.tags.next();
                counts[by] = counts[by] + 1L;
                ++i;
            }
            for (i = 0; i < counts.length; ++i) {
                this.fields[i].skipRows(counts[i]);
            }
        }
    }

    private static class StructTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private final String[] fieldNames;

        StructTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(path, columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getFieldNamesCount();
            this.fields = new TreeReader[fieldCount];
            this.fieldNames = new String[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included == null || included[subtype]) {
                    this.fields[i] = RecordReaderImpl.createTreeReader(path, subtype, types, included);
                }
                this.fieldNames[i] = type.getFieldNames(i);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            for (TreeReader kid : this.fields) {
                if (kid == null) continue;
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcStruct result = null;
            if (this.valuePresent) {
                if (previous == null) {
                    result = new OrcStruct(this.fields.length);
                } else {
                    result = (OrcStruct)previous;
                    if (result.getNumFields() != this.fields.length) {
                        result.setNumFields(this.fields.length);
                    }
                }
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i] == null) continue;
                    result.setFieldValue(i, this.fields[i].next(result.getFieldValue(i)));
                }
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.skipRows(items);
            }
        }
    }

    private static class VarcharTreeReader
    extends StringTreeReader {
        int maxLength;

        VarcharTreeReader(Path path, int columnId, int maxLength) {
            super(path, columnId);
            this.maxLength = maxLength;
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveVarcharWritable result = null;
            result = previous == null ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
            Object textVal = super.next(result.getTextValue());
            if (textVal == null) {
                return null;
            }
            result.enforceMaxLength(this.maxLength);
            return result;
        }
    }

    private static class StringDictionaryTreeReader
    extends TreeReader {
        private DynamicByteArray dictionaryBuffer;
        private int[] dictionaryOffsets;
        private IntegerReader reader;

        StringDictionaryTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            int dictionarySize = encodings.get(this.columnId).getDictionarySize();
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
            InStream in = streams.get(name);
            if (in.available() > 0) {
                this.dictionaryBuffer = new DynamicByteArray(64, in.available());
                this.dictionaryBuffer.readAll(in);
            } else {
                this.dictionaryBuffer = null;
            }
            in.close();
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
            in = streams.get(name);
            IntegerReader lenReader = this.createIntegerReader(encodings.get(this.columnId).getKind(), in, false);
            int offset = 0;
            if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < dictionarySize + 1) {
                this.dictionaryOffsets = new int[dictionarySize + 1];
            }
            for (int i = 0; i < dictionarySize; ++i) {
                this.dictionaryOffsets[i] = offset;
                offset += (int)lenReader.next();
            }
            this.dictionaryOffsets[dictionarySize] = offset;
            in.close();
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                int entry = (int)this.reader.next();
                result = previous == null ? new Text() : (Text)previous;
                int offset = this.dictionaryOffsets[entry];
                int length = entry < this.dictionaryOffsets.length - 1 ? this.dictionaryOffsets[entry + 1] - offset : this.dictionaryBuffer.size() - offset;
                if (this.dictionaryBuffer != null) {
                    this.dictionaryBuffer.setText(result, offset, length);
                } else {
                    result.clear();
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class StringDirectTreeReader
    extends TreeReader {
        private InStream stream;
        private IntegerReader lengths;

        StringDirectTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
            this.lengths.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                result = previous == null ? new Text() : (Text)previous;
                int len = (int)this.lengths.next();
                int offset = 0;
                byte[] bytes = new byte[len];
                while (len > 0) {
                    int written = this.stream.read(bytes, offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
                result.set(bytes);
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            this.stream.skip(lengthToSkip);
        }
    }

    private static class StringTreeReader
    extends TreeReader {
        private TreeReader reader;

        StringTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.reader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            switch (encodings.get(this.columnId).getKind()) {
                case DIRECT_V2: 
                case DIRECT: {
                    this.reader = new StringDirectTreeReader(this.path, this.columnId);
                    break;
                }
                case DICTIONARY_V2: 
                case DICTIONARY: {
                    this.reader = new StringDictionaryTreeReader(this.path, this.columnId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported encoding " + encodings.get(this.columnId).getKind());
                }
            }
            this.reader.startStripe(streams, encodings);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            return this.reader.next(previous);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skipRows(items);
        }
    }

    private static class DecimalTreeReader
    extends TreeReader {
        private InStream valueStream;
        private IntegerReader scaleStream = null;

        DecimalTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.valueStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA));
            this.scaleStream = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.valueStream.seek(index[this.columnId]);
            this.scaleStream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            if (this.valuePresent) {
                return new HiveDecimal(SerializationUtils.readBigInteger(this.valueStream), (int)this.scaleStream.next());
            }
            return null;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readBigInteger(this.valueStream);
                ++i;
            }
            this.scaleStream.skip(items);
        }
    }

    private static class DateTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        DateTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Date result = null;
            if (this.valuePresent) {
                result = previous == null ? new Date(0L) : (Date)previous;
                result.setTime(DateWritable.daysToMillis((int)this.reader.next()));
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class TimestampTreeReader
    extends TreeReader {
        private IntegerReader data = null;
        private IntegerReader nanos = null;

        TimestampTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.data = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true);
            this.nanos = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.data.seek(index[this.columnId]);
            this.nanos.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Timestamp result = null;
            if (this.valuePresent) {
                result = previous == null ? new Timestamp(0L) : (Timestamp)previous;
                long millis = (this.data.next() + WriterImpl.BASE_TIMESTAMP) * 1000L;
                int newNanos = TimestampTreeReader.parseNanos(this.nanos.next());
                millis = millis >= 0L ? (millis += (long)(newNanos / 1000000)) : (millis -= (long)(newNanos / 1000000));
                result.setTime(millis);
                result.setNanos(newNanos);
            }
            return result;
        }

        private static int parseNanos(long serialized) {
            int zeros = 7 & (int)serialized;
            int result = (int)serialized >>> 3;
            if (zeros != 0) {
                for (int i = 0; i <= zeros; ++i) {
                    result *= 10;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.data.skip(items);
            this.nanos.skip(items);
        }
    }

    private static class BinaryTreeReader
    extends TreeReader {
        private InStream stream;
        private IntegerReader lengths = null;

        BinaryTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
            this.lengths.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BytesWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BytesWritable() : (BytesWritable)previous;
                int len = (int)this.lengths.next();
                result.setSize(len);
                int offset = 0;
                while (len > 0) {
                    int written = this.stream.read(result.getBytes(), offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            this.stream.skip(lengthToSkip);
        }
    }

    private static class DoubleTreeReader
    extends TreeReader {
        private InStream stream;

        DoubleTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DoubleWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)previous;
                result.set(SerializationUtils.readDouble(this.stream));
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.stream.skip(items * 8L);
        }
    }

    private static class FloatTreeReader
    extends TreeReader {
        private InStream stream;

        FloatTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            FloatWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set(SerializationUtils.readFloat(this.stream));
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readFloat(this.stream);
                ++i;
            }
        }
    }

    private static class LongTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        LongTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LongWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new LongWritable() : (LongWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class IntTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        IntTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            IntWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new IntWritable() : (IntWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ShortTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        ShortTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ShortWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ShortWritable() : (ShortWritable)previous;
                result.set((short)this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ByteTreeReader
    extends TreeReader {
        private RunLengthByteReader reader = null;

        ByteTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ByteWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ByteWritable() : (ByteWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class BooleanTreeReader
    extends TreeReader {
        private BitFieldReader reader = null;

        BooleanTreeReader(Path path, int columnId) {
            super(path, columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), 1);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BooleanWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
                result.set(this.reader.next() == 1);
            }
            return result;
        }
    }

    private static abstract class TreeReader {
        protected final Path path;
        protected final int columnId;
        private BitFieldReader present = null;
        protected boolean valuePresent = false;

        TreeReader(Path path, int columnId) {
            this.path = path;
            this.columnId = columnId;
        }

        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        IntegerReader createIntegerReader(OrcProto.ColumnEncoding.Kind kind, InStream in, boolean signed) throws IOException {
            switch (kind) {
                case DIRECT_V2: 
                case DICTIONARY_V2: {
                    return new RunLengthIntegerReaderV2(in, signed);
                }
                case DIRECT: 
                case DICTIONARY: {
                    return new RunLengthIntegerReader(in, signed);
                }
            }
            throw new IllegalArgumentException("Unknown encoding " + kind);
        }

        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encoding) throws IOException {
            this.checkEncoding(encoding.get(this.columnId));
            InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void seek(PositionProvider[] index) throws IOException {
            if (this.present != null) {
                this.present.seek(index[this.columnId]);
            }
        }

        protected long countNonNulls(long rows) throws IOException {
            if (this.present != null) {
                long result = 0L;
                for (long c = 0L; c < rows; ++c) {
                    if (this.present.next() != 1) continue;
                    ++result;
                }
                return result;
            }
            return rows;
        }

        abstract void skipRows(long var1) throws IOException;

        Object next(Object previous) throws IOException {
            if (this.present != null) {
                this.valuePresent = this.present.next() == 1;
            }
            return previous;
        }
    }

    private static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index = 0;

        PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this.entry = entry;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }
    }
}

