/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.JobConf;

public class MapWork
extends BaseWork {
    private static final transient Log LOG = LogFactory.getLog(MapWork.class);
    private boolean hadoopSupportsSplittable;
    private LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap();
    private LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap();
    private LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap();
    private LinkedHashMap<String, PartitionDesc> aliasToPartnInfo = new LinkedHashMap();
    private HashMap<String, SplitSample> nameToSplitSample = new LinkedHashMap<String, SplitSample>();
    private final Map<String, List<BucketingSortingCtx.BucketCol>> bucketedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.BucketCol>>();
    private final Map<String, List<BucketingSortingCtx.SortCol>> sortedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.SortCol>>();
    private MapredLocalWork mapLocalWork;
    private String tmpHDFSFileURI;
    private String inputformat;
    private String indexIntermediateFile;
    private Integer numMapTasks;
    private Long maxSplitSize;
    private Long minSplitSize;
    private Long minSplitSizePerNode;
    private Long minSplitSizePerRack;
    private int samplingType;
    public static final int SAMPLING_ON_PREV_MR = 1;
    public static final int SAMPLING_ON_START = 2;
    private QBJoinTree joinTree;
    private LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtxMap;
    private boolean mapperCannotSpanPartns;
    private boolean inputFormatSorted = false;
    private transient boolean useBucketizedHiveInputFormat;

    @Explain(displayName="Path -> Alias", normalExplain=false)
    public LinkedHashMap<String, ArrayList<String>> getPathToAliases() {
        return this.pathToAliases;
    }

    public void setPathToAliases(LinkedHashMap<String, ArrayList<String>> pathToAliases) {
        this.pathToAliases = pathToAliases;
    }

    @Explain(displayName="Truncated Path -> Alias", normalExplain=false)
    public Map<String, ArrayList<String>> getTruncatedPathToAliases() {
        LinkedHashMap<String, ArrayList<String>> trunPathToAliases = new LinkedHashMap<String, ArrayList<String>>();
        for (Map.Entry<String, ArrayList<String>> entry : this.pathToAliases.entrySet()) {
            String origiKey = entry.getKey();
            String newKey = PlanUtils.removePrefixFromWarehouseConfig(origiKey);
            ArrayList<String> value = entry.getValue();
            trunPathToAliases.put(newKey, value);
        }
        return trunPathToAliases;
    }

    @Explain(displayName="Path -> Partition", normalExplain=false)
    public LinkedHashMap<String, PartitionDesc> getPathToPartitionInfo() {
        return this.pathToPartitionInfo;
    }

    public void setPathToPartitionInfo(LinkedHashMap<String, PartitionDesc> pathToPartitionInfo) {
        this.pathToPartitionInfo = pathToPartitionInfo;
    }

    public void deriveExplainAttributes() {
        if (this.pathToPartitionInfo != null) {
            for (Map.Entry<String, PartitionDesc> entry : this.pathToPartitionInfo.entrySet()) {
                entry.getValue().deriveBaseFileName(entry.getKey());
            }
        }
        if (this.mapLocalWork != null) {
            this.mapLocalWork.deriveExplainAttributes();
        }
    }

    public LinkedHashMap<String, PartitionDesc> getAliasToPartnInfo() {
        return this.aliasToPartnInfo;
    }

    public void setAliasToPartnInfo(LinkedHashMap<String, PartitionDesc> aliasToPartnInfo) {
        this.aliasToPartnInfo = aliasToPartnInfo;
    }

    @Explain(displayName="Alias -> Map Operator Tree")
    public LinkedHashMap<String, Operator<? extends OperatorDesc>> getAliasToWork() {
        return this.aliasToWork;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Local Work")
    public MapredLocalWork getMapLocalWork() {
        return this.mapLocalWork;
    }

    public void setMapLocalWork(MapredLocalWork mapLocalWork) {
        this.mapLocalWork = mapLocalWork;
    }

    @Explain(displayName="Split Sample")
    public HashMap<String, SplitSample> getNameToSplitSample() {
        return this.nameToSplitSample;
    }

    public void setNameToSplitSample(HashMap<String, SplitSample> nameToSplitSample) {
        this.nameToSplitSample = nameToSplitSample;
    }

    public Integer getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(Integer numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public void addMapWork(String path, String alias, Operator<?> work, PartitionDesc pd) {
        ArrayList<String> curAliases = this.pathToAliases.get(path);
        if (curAliases == null) {
            assert (this.pathToPartitionInfo.get(path) == null);
            curAliases = new ArrayList();
            this.pathToAliases.put(path, curAliases);
            this.pathToPartitionInfo.put(path, pd);
        } else assert (this.pathToPartitionInfo.get(path) != null);
        for (String oneAlias : curAliases) {
            if (!oneAlias.equals(alias)) continue;
            throw new RuntimeException("Multiple aliases named: " + alias + " for path: " + path);
        }
        curAliases.add(alias);
        if (this.aliasToWork.get(alias) != null) {
            throw new RuntimeException("Existing work for alias: " + alias);
        }
        this.aliasToWork.put(alias, work);
    }

    public boolean isInputFormatSorted() {
        return this.inputFormatSorted;
    }

    public void setInputFormatSorted(boolean inputFormatSorted) {
        this.inputFormatSorted = inputFormatSorted;
    }

    public void resolveDynamicPartitionStoredAsSubDirsMerge(HiveConf conf, Path path, TableDesc tblDesc, ArrayList<String> aliases, PartitionDesc partDesc) {
        this.pathToAliases.put(path.toString(), aliases);
        this.pathToPartitionInfo.put(path.toString(), partDesc);
    }

    private void setAliases() {
        if (this.aliasToWork == null) {
            return;
        }
        for (String oneAlias : this.aliasToWork.keySet()) {
            this.aliasToWork.get(oneAlias).setAlias(oneAlias);
        }
    }

    @Override
    protected List<Operator<?>> getAllRootOperators() {
        ArrayList opList = new ArrayList();
        LinkedHashMap<String, ArrayList<String>> pa = this.getPathToAliases();
        if (pa != null) {
            for (List ls : pa.values()) {
                for (String a : ls) {
                    Operator<? extends OperatorDesc> op = this.getAliasToWork().get(a);
                    if (op == null) continue;
                    opList.add(op);
                }
            }
        }
        return opList;
    }

    public void mergeAliasedInput(String alias, String pathDir, PartitionDesc partitionInfo) {
        ArrayList<String> aliases = this.pathToAliases.get(pathDir);
        if (aliases == null) {
            aliases = new ArrayList<String>(Arrays.asList(alias));
            this.pathToAliases.put(pathDir, aliases);
            this.pathToPartitionInfo.put(pathDir, partitionInfo);
        } else {
            aliases.add(alias);
        }
    }

    public void initialize() {
        this.setAliases();
    }

    public Long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    public void setMaxSplitSize(Long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public Long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(Long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public Long getMinSplitSizePerNode() {
        return this.minSplitSizePerNode;
    }

    public void setMinSplitSizePerNode(Long minSplitSizePerNode) {
        this.minSplitSizePerNode = minSplitSizePerNode;
    }

    public Long getMinSplitSizePerRack() {
        return this.minSplitSizePerRack;
    }

    public void setMinSplitSizePerRack(Long minSplitSizePerRack) {
        this.minSplitSizePerRack = minSplitSizePerRack;
    }

    public String getInputformat() {
        return this.inputformat;
    }

    public void setInputformat(String inputformat) {
        this.inputformat = inputformat;
    }

    public boolean isUseBucketizedHiveInputFormat() {
        return this.useBucketizedHiveInputFormat;
    }

    public void setUseBucketizedHiveInputFormat(boolean useBucketizedHiveInputFormat) {
        this.useBucketizedHiveInputFormat = useBucketizedHiveInputFormat;
    }

    public QBJoinTree getJoinTree() {
        return this.joinTree;
    }

    public void setJoinTree(QBJoinTree joinTree) {
        this.joinTree = joinTree;
    }

    public void setMapperCannotSpanPartns(boolean mapperCannotSpanPartns) {
        this.mapperCannotSpanPartns = mapperCannotSpanPartns;
    }

    public boolean isMapperCannotSpanPartns() {
        return this.mapperCannotSpanPartns;
    }

    public boolean getHadoopSupportsSplittable() {
        return this.hadoopSupportsSplittable;
    }

    public void setHadoopSupportsSplittable(boolean hadoopSupportsSplittable) {
        this.hadoopSupportsSplittable = hadoopSupportsSplittable;
    }

    public String getIndexIntermediateFile() {
        return this.indexIntermediateFile;
    }

    public ArrayList<String> getAliases() {
        return new ArrayList<String>(this.aliasToWork.keySet());
    }

    public ArrayList<Operator<?>> getWorks() {
        return new ArrayList(this.aliasToWork.values());
    }

    public ArrayList<String> getPaths() {
        return new ArrayList<String>(this.pathToAliases.keySet());
    }

    public ArrayList<PartitionDesc> getPartitionDescs() {
        return new ArrayList<PartitionDesc>(this.aliasToPartnInfo.values());
    }

    public LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> getOpParseCtxMap() {
        return this.opParseCtxMap;
    }

    public void setOpParseCtxMap(LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtxMap) {
        this.opParseCtxMap = opParseCtxMap;
    }

    public String getTmpHDFSFileURI() {
        return this.tmpHDFSFileURI;
    }

    public void setTmpHDFSFileURI(String tmpHDFSFileURI) {
        this.tmpHDFSFileURI = tmpHDFSFileURI;
    }

    public void mergingInto(MapWork mapWork) {
        mapWork.useBucketizedHiveInputFormat |= this.useBucketizedHiveInputFormat;
    }

    @Explain(displayName="Path -> Bucketed Columns", normalExplain=false)
    public Map<String, List<BucketingSortingCtx.BucketCol>> getBucketedColsByDirectory() {
        return this.bucketedColsByDirectory;
    }

    @Explain(displayName="Path -> Sorted Columns", normalExplain=false)
    public Map<String, List<BucketingSortingCtx.SortCol>> getSortedColsByDirectory() {
        return this.sortedColsByDirectory;
    }

    public void addIndexIntermediateFile(String fileName) {
        this.indexIntermediateFile = this.indexIntermediateFile == null ? fileName : this.indexIntermediateFile + "," + fileName;
    }

    public int getSamplingType() {
        return this.samplingType;
    }

    public void setSamplingType(int samplingType) {
        this.samplingType = samplingType;
    }

    @Explain(displayName="Sampling")
    public String getSamplingTypeString() {
        return this.samplingType == 1 ? "SAMPLING_ON_PREV_MR" : (this.samplingType == 2 ? "SAMPLING_ON_START" : null);
    }

    public void configureJobConf(JobConf job) {
        for (PartitionDesc partition : this.aliasToPartnInfo.values()) {
            PlanUtils.configureJobConf(partition.getTableDesc(), job);
        }
        Collection<Operator<?>> mappers = this.aliasToWork.values();
        for (FileSinkOperator fs : OperatorUtils.findOperators(mappers, FileSinkOperator.class)) {
            PlanUtils.configureJobConf(((FileSinkDesc)fs.getConf()).getTableInfo(), job);
        }
    }
}

