/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.EmptyWatcher;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;

public class HBaseTestingUtility {
    private static final Log LOG = LogFactory.getLog(HBaseTestingUtility.class);
    private Configuration conf;
    private MiniZooKeeperCluster zkCluster = null;
    private static int DEFAULT_REGIONS_PER_SERVER = 5;
    private boolean passedZkCluster = false;
    private MiniDFSCluster dfsCluster = null;
    private HBaseCluster hbaseCluster = null;
    private MiniMRCluster mrCluster = null;
    private File dataTestDir = null;
    private File clusterTestDir = null;
    private static final String TEST_DIRECTORY_KEY = "test.build.data";
    public static final String BASE_TEST_DIRECTORY_KEY = "test.build.data.basedirectory";
    public static final String DEFAULT_BASE_TEST_DIRECTORY = "target/test-data";
    public static final List<Object[]> COMPRESSION_ALGORITHMS_PARAMETERIZED = Arrays.asList({Compression.Algorithm.NONE}, {Compression.Algorithm.GZ});
    public static final List<Object[]> BOOLEAN_PARAMETERIZED = Arrays.asList({new Boolean(false)}, {new Boolean(true)});
    public static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    public static final Collection<Object[]> BLOOM_AND_COMPRESSION_COMBINATIONS = HBaseTestingUtility.bloomAndCompressionCombinations();
    public static final byte[][] KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};
    public static final byte[][] KEYS_FOR_HBA_CREATE_TABLE = new byte[][]{Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy"), Bytes.toBytes((String)"zzz")};
    private HBaseAdmin hbaseAdmin = null;
    private static final int MIN_RANDOM_PORT = 49152;
    private static final int MAX_RANDOM_PORT = 65534;

    private static List<Object[]> bloomAndCompressionCombinations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (Compression.Algorithm comprAlgo : COMPRESSION_ALGORITHMS) {
            for (StoreFile.BloomType bloomType : StoreFile.BloomType.values()) {
                configurations.add(new Object[]{comprAlgo, bloomType});
            }
        }
        return Collections.unmodifiableList(configurations);
    }

    public HBaseTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseTestingUtility(Configuration conf) {
        this.conf = conf;
        ChecksumUtil.generateExceptionForChecksumFailureForTest((boolean)true);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void setHBaseCluster(HBaseCluster hbaseCluster) {
        this.hbaseCluster = hbaseCluster;
    }

    private Path getBaseTestDir() {
        String PathName = System.getProperty(BASE_TEST_DIRECTORY_KEY, DEFAULT_BASE_TEST_DIRECTORY);
        return new Path(PathName);
    }

    public Path getDataTestDir() {
        if (this.dataTestDir == null) {
            this.setupDataTestDir();
        }
        return new Path(this.dataTestDir.getAbsolutePath());
    }

    public Path getClusterTestDir() {
        if (this.clusterTestDir == null) {
            this.setupClusterTestDir();
        }
        return new Path(this.clusterTestDir.getAbsolutePath());
    }

    public Path getDataTestDir(String subdirName) {
        return new Path(this.getDataTestDir(), subdirName);
    }

    private void setupDataTestDir() {
        if (this.dataTestDir != null) {
            LOG.warn((Object)("Data test dir already setup in " + this.dataTestDir.getAbsolutePath()));
            return;
        }
        String randomStr = UUID.randomUUID().toString();
        Path testPath = new Path(this.getBaseTestDir(), randomStr);
        this.dataTestDir = new File(testPath.toString()).getAbsoluteFile();
        this.dataTestDir.deleteOnExit();
        this.createSubDirAndSystemProperty("hadoop.log.dir", testPath, "hadoop-log-dir");
        this.createSubDirAndSystemProperty("hadoop.tmp.dir", testPath, "hadoop-tmp-dir");
        this.createSubDir("mapred.local.dir", testPath, "mapred-local-dir");
        this.createSubDirAndSystemProperty("mapred.working.dir", testPath, "mapred-working-dir");
        this.createSubDir("hbase.local.dir", testPath, "hbase-local-dir");
    }

    private void createSubDir(String propertyName, Path parent, String subDirName) {
        Path newPath = new Path(parent, subDirName);
        File newDir = new File(newPath.toString()).getAbsoluteFile();
        newDir.deleteOnExit();
        this.conf.set(propertyName, newDir.getAbsolutePath());
    }

    private void createSubDirAndSystemProperty(String propertyName, Path parent, String subDirName) {
        String sysValue = System.getProperty(propertyName);
        if (sysValue != null) {
            LOG.info((Object)("System.getProperty(\"" + propertyName + "\") already set to: " + sysValue + " so I do NOT create it in " + this.dataTestDir.getAbsolutePath()));
            String confValue = this.conf.get(propertyName);
            if (confValue != null && !confValue.endsWith(sysValue)) {
                LOG.warn((Object)(propertyName + " property value differs in configuration and system: " + "Configuration=" + confValue + " while System=" + sysValue + " Erasing configuration value by system value."));
            }
            this.conf.set(propertyName, sysValue);
        } else {
            this.createSubDir(propertyName, parent, subDirName);
            System.setProperty(propertyName, this.conf.get(propertyName));
        }
    }

    private void setupClusterTestDir() {
        if (this.clusterTestDir != null) {
            LOG.warn((Object)("Cluster test dir already setup in " + this.clusterTestDir.getAbsolutePath()));
            return;
        }
        Path testDir = this.getDataTestDir("dfscluster_" + UUID.randomUUID().toString());
        this.clusterTestDir = new File(testDir.toString()).getAbsoluteFile();
        this.clusterTestDir.deleteOnExit();
    }

    public void isRunningCluster() throws IOException {
        if (this.dfsCluster == null) {
            return;
        }
        throw new IOException("Cluster already running at " + this.clusterTestDir);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers) throws Exception {
        return this.startMiniDFSCluster(servers, null);
    }

    public MiniDFSCluster startMiniDFSCluster(String[] hosts) throws Exception {
        if (hosts != null && hosts.length != 0) {
            return this.startMiniDFSCluster(hosts.length, hosts);
        }
        return this.startMiniDFSCluster(1, null);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, String[] hosts) throws Exception {
        this.isRunningCluster();
        if (this.clusterTestDir == null) {
            this.setupClusterTestDir();
        }
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestDir.toString());
        System.setProperty("test.cache.data", this.clusterTestDir.toString());
        this.dfsCluster = new MiniDFSCluster(0, this.conf, servers, true, true, true, null, null, hosts, null);
        FileSystem fs = this.dfsCluster.getFileSystem();
        this.conf.set("fs.defaultFS", fs.getUri().toString());
        this.conf.set("fs.default.name", fs.getUri().toString());
        this.dfsCluster.waitClusterUp();
        return this.dfsCluster;
    }

    public void shutdownMiniDFSCluster() throws Exception {
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
    }

    public MiniZooKeeperCluster startMiniZKCluster() throws Exception {
        return this.startMiniZKCluster(1);
    }

    public MiniZooKeeperCluster startMiniZKCluster(int zooKeeperServerNum) throws Exception {
        File zkClusterFile = new File(this.getClusterTestDir().toString());
        return this.startMiniZKCluster(zkClusterFile, zooKeeperServerNum);
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir) throws Exception {
        return this.startMiniZKCluster(dir, 1);
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir, int zooKeeperServerNum) throws Exception {
        if (this.zkCluster != null) {
            throw new IOException("Cluster already running at " + dir);
        }
        this.passedZkCluster = false;
        this.zkCluster = new MiniZooKeeperCluster(this.getConfiguration());
        int clientPort = this.zkCluster.startup(dir, zooKeeperServerNum);
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        return this.zkCluster;
    }

    public void shutdownMiniZKCluster() throws IOException {
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
    }

    public MiniHBaseCluster startMiniCluster() throws Exception {
        return this.startMiniCluster(1, 1);
    }

    public MiniHBaseCluster startMiniCluster(int numSlaves) throws Exception {
        return this.startMiniCluster(1, numSlaves);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, null);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts) throws Exception {
        int numDataNodes = numSlaves;
        if (dataNodeHosts != null && dataNodeHosts.length != 0) {
            numDataNodes = dataNodeHosts.length;
        }
        LOG.info((Object)("Starting up minicluster with " + numMasters + " master(s) and " + numSlaves + " regionserver(s) and " + numDataNodes + " datanode(s)"));
        this.isRunningCluster();
        this.startMiniDFSCluster(numDataNodes, dataNodeHosts);
        if (this.zkCluster == null) {
            this.startMiniZKCluster(this.clusterTestDir);
        }
        return this.startMiniHBaseCluster(numMasters, numSlaves);
    }

    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numSlaves) throws IOException, InterruptedException {
        this.createRootDir();
        if (this.conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", numSlaves);
        }
        if (this.conf.getInt("hbase.master.wait.on.regionservers.maxtostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", numSlaves);
        }
        Configuration c = new Configuration(this.conf);
        this.hbaseCluster = new MiniHBaseCluster(c, numMasters, numSlaves);
        HTable t = new HTable(c, HConstants.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        s.close();
        t.close();
        this.getHBaseAdmin();
        LOG.info((Object)"Minicluster is up");
        return (MiniHBaseCluster)this.hbaseCluster;
    }

    public void restartHBaseCluster(int servers) throws IOException, InterruptedException {
        this.hbaseCluster = new MiniHBaseCluster(this.conf, servers);
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        LOG.info((Object)"HBase has been restarted");
        s.close();
        t.close();
    }

    public MiniHBaseCluster getMiniHBaseCluster() {
        if (this.hbaseCluster instanceof MiniHBaseCluster) {
            return (MiniHBaseCluster)this.hbaseCluster;
        }
        throw new RuntimeException(this.hbaseCluster + " not an instance of " + MiniHBaseCluster.class.getName());
    }

    public void shutdownMiniCluster() throws Exception {
        LOG.info((Object)"Shutting down minicluster");
        this.shutdownMiniHBaseCluster();
        if (!this.passedZkCluster) {
            this.shutdownMiniZKCluster();
        }
        this.shutdownMiniDFSCluster();
        if (this.clusterTestDir != null && this.clusterTestDir.exists()) {
            if (!FSUtils.deleteDirectory((FileSystem)FileSystem.getLocal((Configuration)this.conf), (Path)new Path(this.clusterTestDir.toString()))) {
                LOG.warn((Object)("Failed delete of " + this.clusterTestDir.toString()));
            }
            this.clusterTestDir = null;
        }
        LOG.info((Object)"Minicluster is down");
    }

    public void shutdownMiniHBaseCluster() throws IOException {
        if (this.hbaseAdmin != null) {
            this.hbaseAdmin.close();
            this.hbaseAdmin = null;
        }
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", -1);
        this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", -1);
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.waitUntilShutDown();
            this.hbaseCluster = null;
        }
    }

    public Path getDefaultRootDirPath() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        return new Path(fs.makeQualified(fs.getHomeDirectory()), "hbase");
    }

    public Path createRootDir() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path hbaseRootdir = this.getDefaultRootDirPath();
        this.conf.set("hbase.rootdir", hbaseRootdir.toString());
        fs.mkdirs(hbaseRootdir);
        FSUtils.setVersion((FileSystem)fs, (Path)hbaseRootdir);
        return hbaseRootdir;
    }

    public void flush() throws IOException {
        this.getMiniHBaseCluster().flushcache();
    }

    public void flush(byte[] tableName) throws IOException {
        this.getMiniHBaseCluster().flushcache(tableName);
    }

    public void compact(boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(major);
    }

    public void compact(byte[] tableName, boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(tableName, major);
    }

    public HTable createTable(byte[] tableName, byte[] family) throws IOException {
        return this.createTable(tableName, new byte[][]{family});
    }

    public HTable createTable(byte[] tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, new Configuration(this.getConfiguration()));
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc, startKey, endKey, numRegions);
        return new HTable(this.getConfiguration(), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, Configuration c) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(c, tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, Configuration c, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(c, tableName);
    }

    public HTable createTable(byte[] tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions, int blockSize) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions).setBlocksize(blockSize);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int[] numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions[i]);
            desc.addFamily(hcd);
            ++i;
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public void deleteTable(byte[] tableName) throws IOException {
        try {
            this.getHBaseAdmin().disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOG.debug((Object)("Table: " + Bytes.toString((byte[])tableName) + " already disabled, so just deleting it."));
        }
        this.getHBaseAdmin().deleteTable(tableName);
    }

    public HTable truncateTable(byte[] tableName) throws IOException {
        HTable table = new HTable(this.getConfiguration(), tableName);
        Scan scan = new Scan();
        ResultScanner resScan = table.getScanner(scan);
        for (Result res : resScan) {
            Delete del = new Delete(res.getRow());
            table.delete(del);
        }
        resScan = table.getScanner(scan);
        resScan.close();
        return table;
    }

    public int loadTable(HTable t, byte[] f) throws IOException {
        t.setAutoFlush(false);
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(f, null, k);
                    t.put(put);
                    ++rowCount;
                }
            }
        }
        t.flushCommits();
        return rowCount;
    }

    public int loadTable(HTable t, byte[][] f) throws IOException {
        t.setAutoFlush(false);
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    for (int i = 0; i < f.length; ++i) {
                        put.add(f[i], null, k);
                    }
                    t.put(put);
                    ++rowCount;
                }
            }
        }
        t.flushCommits();
        return rowCount;
    }

    public int loadRegion(HRegion r, byte[] f) throws IOException {
        return this.loadRegion(r, f, false);
    }

    public int loadRegion(HRegion r, byte[] f, boolean flush) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(f, null, k);
                    if (r.getLog() == null) {
                        put.setWriteToWAL(false);
                    }
                    r.put(put);
                    ++rowCount;
                }
            }
            if (!flush) continue;
            r.flushcache();
        }
        return rowCount;
    }

    public int countRows(HTable table) throws IOException {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    public int countRows(HTable table, byte[] ... families) throws IOException {
        Scan scan = new Scan();
        for (byte[] family : families) {
            scan.addFamily(family);
        }
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    public String checksumRows(HTable table) throws Exception {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (Result res : results) {
            digest.update(res.getRow());
        }
        results.close();
        return digest.toString();
    }

    public int createMultiRegions(HTable table, byte[] columnFamily) throws IOException {
        return this.createMultiRegions(table, columnFamily, true);
    }

    public int createMultiRegions(HTable table, byte[] columnFamily, boolean cleanupFS) throws IOException {
        return this.createMultiRegions(this.getConfiguration(), table, columnFamily, KEYS, cleanupFS);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegions(c, table, family, regionStartKeys);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily, byte[][] startKeys) throws IOException {
        return this.createMultiRegions(c, table, columnFamily, startKeys, true);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily, byte[][] startKeys, boolean cleanupFS) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, HConstants.META_TABLE_NAME);
        HTableDescriptor htd = table.getTableDescriptor();
        if (!htd.hasFamily(columnFamily)) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
            htd.addFamily(hcd);
        }
        List<byte[]> rows = this.getMetaTableRows(htd.getName());
        String regionToDeleteInFS = ((HRegionLocation)table.getRegionsInRange(Bytes.toBytes((String)""), Bytes.toBytes((String)"")).get(0)).getRegionInfo().getEncodedName();
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(table.getTableName(), startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegions: inserted " + hri.toString()));
            newRegions.add(hri);
            ++count;
        }
        for (byte[] row : rows) {
            LOG.info((Object)("createMultiRegions: deleting meta row -> " + Bytes.toStringBinary((byte[])row)));
            meta.delete(new Delete(row));
        }
        if (cleanupFS) {
            Path tableDir = new Path(this.getDefaultRootDirPath().toString() + System.getProperty("file.separator") + htd.getNameAsString() + System.getProperty("file.separator") + regionToDeleteInFS);
            this.getDFSCluster().getFileSystem().delete(tableDir);
        }
        HConnection conn = table.getConnection();
        conn.clearRegionCache();
        HBaseAdmin admin = this.getHBaseAdmin();
        if (admin.isTableEnabled(table.getTableName())) {
            for (HRegionInfo hri : newRegions) {
                admin.assign(hri.getRegionName());
            }
        }
        meta.close();
        return count;
    }

    public List<HRegionInfo> createMultiRegionsInMeta(Configuration conf, HTableDescriptor htd, byte[][] startKeys) throws IOException {
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(htd.getName(), startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegionsInMeta: inserted " + hri.toString()));
            newRegions.add(hri);
        }
        meta.close();
        return newRegions;
    }

    public List<byte[]> getMetaTableRows() throws IOException {
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow())));
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    public List<byte[]> getMetaTableRows(byte[] tableName) throws IOException {
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            byte[] val = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            if (val == null) {
                LOG.error((Object)("No region info for row " + Bytes.toString((byte[])result.getRow())));
                continue;
            }
            HRegionInfo info = Writables.getHRegionInfo((byte[])val);
            if (Bytes.compareTo((byte[])info.getTableName(), (byte[])tableName) != 0) continue;
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow()) + info));
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    public HRegionServer getRSForFirstRegionInTable(byte[] tableName) throws IOException {
        List<byte[]> metaRows = this.getMetaTableRows(tableName);
        if (metaRows == null || metaRows.isEmpty()) {
            return null;
        }
        LOG.debug((Object)("Found " + metaRows.size() + " rows for table " + Bytes.toString((byte[])tableName)));
        byte[] firstrow = metaRows.get(0);
        LOG.debug((Object)("FirstRow=" + Bytes.toString((byte[])firstrow)));
        int index = this.getMiniHBaseCluster().getServerWith(firstrow);
        return this.getMiniHBaseCluster().getRegionServerThreads().get(index).getRegionServer();
    }

    public void startMiniMapReduceCluster() throws IOException {
        this.startMiniMapReduceCluster(2);
    }

    public void startMiniMapReduceCluster(int servers) throws IOException {
        String schedulerAdress;
        LOG.info((Object)"Starting mini mapreduce cluster...");
        Configuration c = this.getConfiguration();
        String logDir = c.get("hadoop.log.dir");
        String tmpDir = c.get("hadoop.tmp.dir");
        if (logDir == null) {
            logDir = tmpDir;
        }
        System.setProperty("hadoop.log.dir", logDir);
        c.set("mapred.output.dir", tmpDir);
        this.mrCluster = new MiniMRCluster(servers, FileSystem.get((Configuration)this.conf).getUri().toString(), 1);
        LOG.info((Object)"Mini mapreduce cluster started");
        JobConf mrClusterJobConf = this.mrCluster.createJobConf();
        c.set("mapred.job.tracker", mrClusterJobConf.get("mapred.job.tracker"));
        this.conf.set("mapreduce.framework.name", "yarn");
        String rmAdress = mrClusterJobConf.get("yarn.resourcemanager.address");
        if (rmAdress != null) {
            this.conf.set("yarn.resourcemanager.address", rmAdress);
        }
        if ((schedulerAdress = mrClusterJobConf.get("yarn.resourcemanager.scheduler.address")) != null) {
            this.conf.set("yarn.resourcemanager.scheduler.address", schedulerAdress);
        }
    }

    public void shutdownMiniMapReduceCluster() {
        LOG.info((Object)"Stopping mini mapreduce cluster...");
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
            this.mrCluster = null;
        }
        this.conf.set("mapred.job.tracker", "local");
        LOG.info((Object)"Mini mapreduce cluster stopped");
    }

    public void enableDebug(Class<?> clazz) {
        Log l = LogFactory.getLog(clazz);
        if (l instanceof Log4JLogger) {
            ((Log4JLogger)l).getLogger().setLevel(org.apache.log4j.Level.DEBUG);
        } else if (l instanceof Jdk14Logger) {
            ((Jdk14Logger)l).getLogger().setLevel(Level.ALL);
        }
    }

    public void expireMasterSession() throws Exception {
        HMaster master = this.getMiniHBaseCluster().getMaster();
        this.expireSession(master.getZooKeeper(), false);
    }

    public void expireRegionServerSession(int index) throws Exception {
        HRegionServer rs = this.getMiniHBaseCluster().getRegionServer(index);
        this.expireSession(rs.getZooKeeper(), false);
        this.decrementMinRegionServerCount();
    }

    private void decrementMinRegionServerCount() {
        this.decrementMinRegionServerCount(this.getConfiguration());
        for (JVMClusterUtil.MasterThread master : this.getHBaseCluster().getMasterThreads()) {
            this.decrementMinRegionServerCount(master.getMaster().getConfiguration());
        }
    }

    private void decrementMinRegionServerCount(Configuration conf) {
        int currentCount = conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1);
        if (currentCount != -1) {
            conf.setInt("hbase.master.wait.on.regionservers.mintostart", Math.max(currentCount - 1, 1));
        }
    }

    public void expireSession(ZooKeeperWatcher nodeZK, boolean checkStatus) throws Exception {
        Configuration c = new Configuration(this.conf);
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 500;
        ZooKeeper zk = nodeZK.getRecoverableZooKeeper().getZooKeeper();
        byte[] password = zk.getSessionPasswd();
        long sessionID = zk.getSessionId();
        ZooKeeper monitor = new ZooKeeper(quorumServers, 1000, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                LOG.info((Object)("Monitor ZKW received event=" + watchedEvent));
            }
        }, sessionID, password);
        ZooKeeper newZK = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance, sessionID, password);
        newZK.close();
        LOG.info((Object)("ZK Closed Session 0x" + Long.toHexString(sessionID)));
        monitor.close();
        if (checkStatus) {
            new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME).close();
        }
    }

    public MiniHBaseCluster getHBaseCluster() {
        return this.getMiniHBaseCluster();
    }

    public HBaseCluster getHBaseClusterInterface() {
        return this.hbaseCluster;
    }

    public synchronized HBaseAdmin getHBaseAdmin() throws IOException {
        if (this.hbaseAdmin == null) {
            this.hbaseAdmin = new HBaseAdmin(new Configuration(this.getConfiguration()));
        }
        return this.hbaseAdmin;
    }

    public void closeRegion(String regionName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionName));
    }

    public void closeRegion(byte[] regionName) throws IOException {
        this.getHBaseAdmin().closeRegion(regionName, null);
    }

    public void closeRegionByRow(String row, HTable table) throws IOException {
        this.closeRegionByRow(Bytes.toBytes((String)row), table);
    }

    public void closeRegionByRow(byte[] row, HTable table) throws IOException {
        HRegionLocation hrl = table.getRegionLocation(row);
        this.closeRegion(hrl.getRegionInfo().getRegionName());
    }

    public MiniZooKeeperCluster getZkCluster() {
        return this.zkCluster;
    }

    public void setZkCluster(MiniZooKeeperCluster zkCluster) {
        this.passedZkCluster = true;
        this.zkCluster = zkCluster;
        this.conf.setInt("hbase.zookeeper.property.clientPort", zkCluster.getClientPort());
    }

    public MiniDFSCluster getDFSCluster() {
        return this.dfsCluster;
    }

    public void setDFSCluster(MiniDFSCluster cluster) throws IOException {
        if (this.dfsCluster != null && this.dfsCluster.isClusterUp()) {
            throw new IOException("DFSCluster is already running! Shut it down first.");
        }
        this.dfsCluster = cluster;
    }

    public FileSystem getTestFileSystem() throws IOException {
        return HFileSystem.get((Configuration)this.conf);
    }

    public boolean cleanupTestDir() throws IOException {
        if (this.dataTestDir == null) {
            return false;
        }
        boolean ret = this.deleteDir(this.getDataTestDir());
        this.dataTestDir = null;
        return ret;
    }

    public boolean cleanupTestDir(String subdir) throws IOException {
        if (this.dataTestDir == null) {
            return false;
        }
        return this.deleteDir(this.getDataTestDir(subdir));
    }

    public boolean deleteDir(Path dir) throws IOException {
        FileSystem fs = this.getTestFileSystem();
        if (fs.exists(dir)) {
            return fs.delete(this.getDataTestDir(), true);
        }
        return false;
    }

    public void waitTableAvailable(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        long startWait = System.currentTimeMillis();
        while (!this.getHBaseAdmin().isTableAvailable(table)) {
            Assert.assertTrue((String)("Timed out waiting for table to become available " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
    }

    public void waitTableEnabled(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        long startWait = System.currentTimeMillis();
        while (!this.getHBaseAdmin().isTableAvailable(table) && !this.getHBaseAdmin().isTableEnabled(table)) {
            Assert.assertTrue((String)("Timed out waiting for table to become available and enabled " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
    }

    public boolean ensureSomeRegionServersAvailable(int num) throws IOException {
        boolean startedServer = false;
        MiniHBaseCluster hbaseCluster = this.getMiniHBaseCluster();
        for (int i = hbaseCluster.getLiveRegionServerThreads().size(); i < num; ++i) {
            LOG.info((Object)("Started new server=" + hbaseCluster.startRegionServer()));
            startedServer = true;
        }
        return startedServer;
    }

    public boolean ensureSomeNonStoppedRegionServersAvailable(int num) throws IOException {
        boolean startedServer = this.ensureSomeRegionServersAvailable(num);
        int nonStoppedServers = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.isStopping() || hrs.isStopped()) {
                LOG.info((Object)("A region server is stopped or stopping:" + hrs));
                continue;
            }
            ++nonStoppedServers;
        }
        for (int i = nonStoppedServers; i < num; ++i) {
            LOG.info((Object)("Started new server=" + this.getMiniHBaseCluster().startRegionServer()));
            startedServer = true;
        }
        return startedServer;
    }

    public static User getDifferentUser(Configuration c, String differentiatingSuffix) throws IOException {
        FileSystem currentfs = FileSystem.get((Configuration)c);
        if (!(currentfs instanceof DistributedFileSystem)) {
            return User.getCurrent();
        }
        String username = User.getCurrent().getName() + differentiatingSuffix;
        User user = User.createUserForTesting((Configuration)c, (String)username, (String[])new String[]{"supergroup"});
        return user;
    }

    public static void setMaxRecoveryErrorCount(OutputStream stream, int max) {
        try {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = DFSClient.class.getDeclaredClasses()) {
                String className = clazz.getSimpleName();
                if (!className.equals("DFSOutputStream") || !clazz.isInstance(stream)) continue;
                Field maxRecoveryErrorCountField = stream.getClass().getDeclaredField("maxRecoveryErrorCount");
                maxRecoveryErrorCountField.setAccessible(true);
                maxRecoveryErrorCountField.setInt(stream, max);
                break;
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Could not set max recovery field", (Throwable)e);
        }
    }

    public void waitUntilAllRegionsAssigned(int countOfRegions) throws IOException {
        HTable meta = new HTable(this.getConfiguration(), HConstants.META_TABLE_NAME);
        while (true) {
            byte[] b;
            int rows = 0;
            Scan scan = new Scan();
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            ResultScanner s = meta.getScanner(scan);
            Result r = null;
            while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) != null && b.length > 0) {
                ++rows;
            }
            s.close();
            if (rows == countOfRegions) break;
            LOG.info((Object)("Found=" + rows));
            Threads.sleep((long)200L);
        }
    }

    public static List<KeyValue> getFromStoreFile(Store store, Get get) throws IOException {
        KeyValue kv;
        MultiVersionConsistencyControl.resetThreadReadPoint();
        Scan scan = new Scan(get);
        InternalScanner scanner = (InternalScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(store.getFamily().getName()));
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        scanner.next(result);
        if (!result.isEmpty() && !Bytes.equals((byte[])(kv = (KeyValue)result.get(0)).getRow(), (byte[])get.getRow())) {
            result.clear();
        }
        scanner.close();
        return result;
    }

    public static List<KeyValue> getFromStoreFile(Store store, byte[] row, NavigableSet<byte[]> columns) throws IOException {
        Get get = new Get(row);
        Map s = get.getFamilyMap();
        s.put(store.getFamily().getName(), columns);
        return HBaseTestingUtility.getFromStoreFile(store, get);
    }

    public static ZooKeeperWatcher getZooKeeperWatcher(HBaseTestingUtility TEST_UTIL) throws ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){
            boolean aborted = false;

            public void abort(String why, Throwable e) {
                this.aborted = true;
                throw new RuntimeException("Fatal ZK error, why=" + why, e);
            }

            public boolean isAborted() {
                return this.aborted;
            }
        });
        return zkw;
    }

    public static ZooKeeperWatcher createAndForceNodeToOpenedState(HBaseTestingUtility TEST_UTIL, HRegion region, ServerName serverName) throws ZooKeeperConnectionException, IOException, KeeperException, KeeperException.NodeExistsException {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName);
        int version = ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName);
        ZKAssign.transitionNodeOpened((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName, (int)version);
        return zkw;
    }

    public static void assertKVListsEqual(String additionalMsg, List<KeyValue> expected, List<KeyValue> actual) {
        int i;
        int eLen = expected.size();
        int aLen = actual.size();
        int minLen = Math.min(eLen, aLen);
        for (i = 0; i < minLen && KeyValue.COMPARATOR.compare(expected.get(i), actual.get(i)) == 0; ++i) {
        }
        if (additionalMsg == null) {
            additionalMsg = "";
        }
        if (!additionalMsg.isEmpty()) {
            additionalMsg = ". " + additionalMsg;
        }
        if (eLen != aLen || i != minLen) {
            throw new AssertionError((Object)("Expected and actual KV arrays differ at position " + i + ": " + HBaseTestingUtility.safeGetAsStr(expected, i) + " (length " + eLen + ") vs. " + HBaseTestingUtility.safeGetAsStr(actual, i) + " (length " + aLen + ")" + additionalMsg));
        }
    }

    private static <T> String safeGetAsStr(List<T> lst, int i) {
        if (0 <= i && i < lst.size()) {
            return lst.get(i).toString();
        }
        return "<out_of_range>";
    }

    public String getClusterKey() {
        return this.conf.get("hbase.zookeeper.quorum") + ":" + this.conf.get("hbase.zookeeper.property.clientPort") + ":" + this.conf.get("zookeeper.znode.parent", "/hbase");
    }

    public HTable createRandomTable(String tableName, Collection<String> families, int maxVersions, int numColsPerRow, int numFlushes, int numRegions, int numRowsPerFlush) throws IOException, InterruptedException {
        LOG.info((Object)("\n\nCreating random table " + tableName + " with " + numRegions + " regions, " + numFlushes + " storefiles per region, " + numRowsPerFlush + " rows per flush, maxVersions=" + maxVersions + "\n"));
        Random rand = new Random((long)tableName.hashCode() * 17L + 12938197137L);
        int numCF = families.size();
        byte[][] cfBytes = new byte[numCF][];
        byte[] tableNameBytes = Bytes.toBytes((String)tableName);
        int cfIndex = 0;
        for (String cf : families) {
            cfBytes[cfIndex++] = Bytes.toBytes((String)cf);
        }
        boolean actualStartKey = false;
        int actualEndKey = Integer.MAX_VALUE;
        int keysPerRegion = Integer.MAX_VALUE / numRegions;
        int splitStartKey = 0 + keysPerRegion;
        int splitEndKey = Integer.MAX_VALUE - keysPerRegion;
        String keyFormat = "%08x";
        HTable table = this.createTable(tableNameBytes, cfBytes, maxVersions, Bytes.toBytes((String)String.format("%08x", splitStartKey)), Bytes.toBytes((String)String.format("%08x", splitEndKey)), numRegions);
        if (this.hbaseCluster != null) {
            this.getMiniHBaseCluster().flushcache(HConstants.META_TABLE_NAME);
        }
        for (int iFlush = 0; iFlush < numFlushes; ++iFlush) {
            for (int iRow = 0; iRow < numRowsPerFlush; ++iRow) {
                byte[] row = Bytes.toBytes((String)String.format("%08x", 0 + rand.nextInt(Integer.MAX_VALUE)));
                Put put = new Put(row);
                Delete del = new Delete(row);
                for (int iCol = 0; iCol < numColsPerRow; ++iCol) {
                    byte[] cf = cfBytes[rand.nextInt(numCF)];
                    long ts = rand.nextInt();
                    byte[] qual = Bytes.toBytes((String)("col" + iCol));
                    if (rand.nextBoolean()) {
                        byte[] value = Bytes.toBytes((String)("value_for_row_" + iRow + "_cf_" + Bytes.toStringBinary((byte[])cf) + "_col_" + iCol + "_ts_" + ts + "_random_" + rand.nextLong()));
                        put.add(cf, qual, ts, value);
                        continue;
                    }
                    if (rand.nextDouble() < 0.8) {
                        del.deleteColumn(cf, qual, ts);
                        continue;
                    }
                    del.deleteColumns(cf, qual, ts);
                }
                if (!put.isEmpty()) {
                    table.put(put);
                }
                if (del.isEmpty()) continue;
                table.delete(del);
            }
            LOG.info((Object)("Initiating flush #" + iFlush + " for table " + tableName));
            table.flushCommits();
            if (this.hbaseCluster == null) continue;
            this.getMiniHBaseCluster().flushcache(tableNameBytes);
        }
        return table;
    }

    public static int randomPort() {
        return 49152 + new Random().nextInt(16382);
    }

    public static int randomFreePort() {
        int port = 0;
        do {
            port = HBaseTestingUtility.randomPort();
            try {
                ServerSocket sock = new ServerSocket(port);
                sock.close();
            }
            catch (IOException ex) {
                port = 0;
            }
        } while (port == 0);
        return port;
    }

    public static void waitForHostPort(String host, int port) throws IOException {
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        IOException savedException = null;
        LOG.info((Object)("Waiting for server at " + host + ":" + port));
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                Socket sock = new Socket(InetAddress.getByName(host), port);
                sock.close();
                savedException = null;
                LOG.info((Object)("Server at " + host + ":" + port + " is available"));
                break;
            }
            catch (UnknownHostException e) {
                throw new IOException("Failed to look up " + host, e);
            }
            catch (IOException e) {
                savedException = e;
                Threads.sleepWithoutInterrupt((long)200L);
                continue;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
    }

    public static int createPreSplitLoadTestTable(Configuration conf, byte[] tableName, byte[] columnFamily, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
        hcd.setDataBlockEncoding(dataBlockEncoding);
        hcd.setCompressionType(compression);
        desc.addFamily(hcd);
        int totalNumberOfRegions = 0;
        try {
            HBaseAdmin admin = new HBaseAdmin(conf);
            int numberOfServers = admin.getClusterStatus().getServers().size();
            if (numberOfServers == 0) {
                throw new IllegalStateException("No live regionservers");
            }
            totalNumberOfRegions = numberOfServers * DEFAULT_REGIONS_PER_SERVER;
            LOG.info((Object)("Number of live regionservers: " + numberOfServers + ", " + "pre-splitting table into " + totalNumberOfRegions + " regions " + "(default regions per server: " + DEFAULT_REGIONS_PER_SERVER + ")"));
            byte[][] splits = new RegionSplitter.HexStringSplit().split(totalNumberOfRegions);
            admin.createTable(desc, splits);
            admin.close();
        }
        catch (MasterNotRunningException e) {
            LOG.error((Object)"Master not running", (Throwable)e);
            throw new IOException(e);
        }
        catch (TableExistsException e) {
            LOG.warn((Object)("Table " + Bytes.toStringBinary((byte[])tableName) + " already exists, continuing"));
        }
        return totalNumberOfRegions;
    }

    public static int getMetaRSPort(Configuration conf) throws IOException {
        HTable table = new HTable(conf, HConstants.META_TABLE_NAME);
        HRegionLocation hloc = table.getRegionLocation(Bytes.toBytes((String)""));
        table.close();
        return hloc.getPort();
    }

    public HRegion createTestRegion(String tableName, HColumnDescriptor hcd) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(Bytes.toBytes((String)tableName), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)this.getDataTestDir(), (Configuration)this.getConfiguration(), (HTableDescriptor)htd);
        return region;
    }
}

