/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.DistributedHBaseCluster;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.util.ReflectionUtils;

public class IntegrationTestingUtility
extends HBaseTestingUtility {
    public static final String IS_DISTRIBUTED_CLUSTER = "hbase.test.cluster.distributed";

    public IntegrationTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public IntegrationTestingUtility(Configuration conf) {
        super(conf);
    }

    public void initializeCluster(int numSlaves) throws Exception {
        if (this.isDistributedCluster()) {
            this.createDistributedHBaseCluster();
            this.checkNodeCount(numSlaves);
        } else {
            this.startMiniCluster(numSlaves);
        }
    }

    public void checkNodeCount(int numSlaves) throws Exception {
        HBaseCluster cluster = this.getHBaseClusterInterface();
        if (cluster.getClusterStatus().getServers().size() < numSlaves) {
            throw new Exception("Cluster does not have enough nodes:" + numSlaves);
        }
    }

    public void restoreCluster() throws IOException {
        if (this.isDistributedCluster()) {
            this.getHBaseClusterInterface().restoreInitialStatus();
        } else {
            this.getMiniHBaseCluster().shutdown();
        }
    }

    public static void setUseDistributedCluster(Configuration conf) {
        conf.setBoolean(IS_DISTRIBUTED_CLUSTER, true);
        System.setProperty(IS_DISTRIBUTED_CLUSTER, "true");
    }

    private boolean isDistributedCluster() {
        Configuration conf = this.getConfiguration();
        boolean isDistributedCluster = false;
        isDistributedCluster = Boolean.parseBoolean(System.getProperty(IS_DISTRIBUTED_CLUSTER, "false"));
        if (!isDistributedCluster) {
            isDistributedCluster = conf.getBoolean(IS_DISTRIBUTED_CLUSTER, false);
        }
        return isDistributedCluster;
    }

    private void createDistributedHBaseCluster() throws IOException {
        Configuration conf = this.getConfiguration();
        Class clusterManagerClass = conf.getClass("hbase.it.clustermanager.class", HBaseClusterManager.class, ClusterManager.class);
        ClusterManager clusterManager = (ClusterManager)((Object)ReflectionUtils.newInstance((Class)clusterManagerClass, (Configuration)conf));
        this.setHBaseCluster(new DistributedHBaseCluster(conf, clusterManager));
        this.getHBaseAdmin();
    }
}

