/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.hadoop.hbase.ClassFinder;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClassFinder {
    private static final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private static final String BASEPKG = "tfcpkg";
    private static AtomicLong testCounter = new AtomicLong(0L);
    private static AtomicLong jarCounter = new AtomicLong(0L);
    private static String basePath = null;
    private static final ClassFinder.FileNameFilter trueNameFilter = new ClassFinder.FileNameFilter(){

        @Override
        public boolean isCandidateFile(String fileName, String absFilePath) {
            return true;
        }
    };
    private static final ClassFinder.ClassFilter trueClassFilter = new ClassFinder.ClassFilter(){

        @Override
        public boolean isCandidateClass(Class<?> c) {
            return true;
        }
    };

    @BeforeClass
    public static void createTestDir() throws IOException {
        File testDir;
        basePath = testUtil.getDataTestDir(TestClassFinder.class.getSimpleName()).toString();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if ((testDir = new File(basePath)).exists()) {
            TestClassFinder.deleteTestDir();
        }
        Assert.assertTrue((boolean)testDir.mkdirs());
    }

    @AfterClass
    public static void deleteTestDir() throws IOException {
        testUtil.cleanupTestDir(TestClassFinder.class.getSimpleName());
    }

    @Test
    public void testClassFinderCanFindClassesInJars() throws Exception {
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, ".nested", "c2");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, "", "c3");
        TestClassFinder.packageAndLoadJar(c1, c3);
        TestClassFinder.packageAndLoadJar(c2);
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)3L, (long)allClasses.size());
    }

    @Test
    public void testClassFinderHandlesConflicts() throws Exception {
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, "", "c2");
        TestClassFinder.packageAndLoadJar(c1, c2);
        TestClassFinder.packageAndLoadJar(c1);
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)2L, (long)allClasses.size());
    }

    @Test
    public void testClassFinderHandlesNestedPackages() throws Exception {
        String NESTED = ".nested";
        String CLASSNAME1 = "c2";
        String CLASSNAME2 = "c3";
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, ".nested", "c2");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, ".nested", "c3");
        TestClassFinder.packageAndLoadJar(c1, c2);
        TestClassFinder.packageAndLoadJar(c3);
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> nestedClasses = allClassesFinder.findClasses(TestClassFinder.makePackageName(".nested", counter), false);
        Assert.assertEquals((long)2L, (long)nestedClasses.size());
        Class<?> nestedClass1 = TestClassFinder.makeClass(".nested", "c2", counter);
        Assert.assertTrue((boolean)nestedClasses.contains(nestedClass1));
        Class<?> nestedClass2 = TestClassFinder.makeClass(".nested", "c3", counter);
        Assert.assertTrue((boolean)nestedClasses.contains(nestedClass2));
    }

    @Test
    public void testClassFinderFiltersByNameInJar() throws Exception {
        String CLASSNAME = "c1";
        String CLASSNAMEEXCPREFIX = "c2";
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, "", "c21");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, "", "c22");
        TestClassFinder.packageAndLoadJar(c1, c2, c3);
        ClassFinder.FileNameFilter notExcNameFilter = new ClassFinder.FileNameFilter(){

            @Override
            public boolean isCandidateFile(String fileName, String absFilePath) {
                return !fileName.startsWith("c2");
            }
        };
        ClassFinder incClassesFinder = new ClassFinder(notExcNameFilter, trueClassFilter);
        Set<Class<?>> incClasses = incClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)1L, (long)incClasses.size());
        Class<?> incClass = TestClassFinder.makeClass("", "c1", counter);
        Assert.assertTrue((boolean)incClasses.contains(incClass));
    }

    @Test
    public void testClassFinderFiltersByClassInJar() throws Exception {
        String CLASSNAME = "c1";
        String CLASSNAMEEXCPREFIX = "c2";
        long counter = testCounter.incrementAndGet();
        FileAndPath c1 = TestClassFinder.compileTestClass(counter, "", "c1");
        FileAndPath c2 = TestClassFinder.compileTestClass(counter, "", "c21");
        FileAndPath c3 = TestClassFinder.compileTestClass(counter, "", "c22");
        TestClassFinder.packageAndLoadJar(c1, c2, c3);
        ClassFinder.ClassFilter notExcClassFilter = new ClassFinder.ClassFilter(){

            @Override
            public boolean isCandidateClass(Class<?> c) {
                return !c.getSimpleName().startsWith("c2");
            }
        };
        ClassFinder incClassesFinder = new ClassFinder(trueNameFilter, notExcClassFilter);
        Set<Class<?>> incClasses = incClassesFinder.findClasses(TestClassFinder.makePackageName("", counter), false);
        Assert.assertEquals((long)1L, (long)incClasses.size());
        Class<?> incClass = TestClassFinder.makeClass("", "c1", counter);
        Assert.assertTrue((boolean)incClasses.contains(incClass));
    }

    @Test
    public void testClassFinderCanFindClassesInDirs() throws Exception {
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(this.getClass().getPackage().getName(), false);
        Assert.assertTrue((boolean)allClasses.contains(this.getClass()));
        Assert.assertTrue((boolean)allClasses.contains(ClassFinder.class));
    }

    @Test
    public void testClassFinderFiltersByNameInDirs() throws Exception {
        final String thisName = this.getClass().getSimpleName();
        ClassFinder.FileNameFilter notThisFilter = new ClassFinder.FileNameFilter(){

            @Override
            public boolean isCandidateFile(String fileName, String absFilePath) {
                return !fileName.equals(thisName + ".class");
            }
        };
        String thisPackage = this.getClass().getPackage().getName();
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(thisPackage, false);
        ClassFinder notThisClassFinder = new ClassFinder(notThisFilter, trueClassFilter);
        Set<Class<?>> notAllClasses = notThisClassFinder.findClasses(thisPackage, false);
        Assert.assertFalse((boolean)notAllClasses.contains(this.getClass()));
        Assert.assertEquals((long)(allClasses.size() - 1), (long)notAllClasses.size());
    }

    @Test
    public void testClassFinderFiltersByClassInDirs() throws Exception {
        ClassFinder.ClassFilter notThisFilter = new ClassFinder.ClassFilter(){

            @Override
            public boolean isCandidateClass(Class<?> c) {
                return c != TestClassFinder.class;
            }
        };
        String thisPackage = this.getClass().getPackage().getName();
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> allClasses = allClassesFinder.findClasses(thisPackage, false);
        ClassFinder notThisClassFinder = new ClassFinder(trueNameFilter, notThisFilter);
        Set<Class<?>> notAllClasses = notThisClassFinder.findClasses(thisPackage, false);
        Assert.assertFalse((boolean)notAllClasses.contains(this.getClass()));
        Assert.assertEquals((long)(allClasses.size() - 1), (long)notAllClasses.size());
    }

    @Test
    public void testClassFinderDefaultsToOwnPackage() throws Exception {
        ClassFinder allClassesFinder = new ClassFinder(trueNameFilter, trueClassFilter);
        Set<Class<?>> pkgClasses = allClassesFinder.findClasses(ClassFinder.class.getPackage().getName(), false);
        Set<Class<?>> defaultClasses = allClassesFinder.findClasses(false);
        Assert.assertArrayEquals((Object[])pkgClasses.toArray(), (Object[])defaultClasses.toArray());
    }

    private static Class<?> makeClass(String nestedPkgSuffix, String className, long counter) throws ClassNotFoundException {
        return Class.forName(TestClassFinder.makePackageName(nestedPkgSuffix, counter) + "." + className + counter);
    }

    private static String makePackageName(String nestedSuffix, long counter) {
        return BASEPKG + counter + nestedSuffix;
    }

    private static FileAndPath compileTestClass(long counter, String packageNameSuffix, String classNamePrefix) throws Exception {
        classNamePrefix = classNamePrefix + counter;
        String packageName = TestClassFinder.makePackageName(packageNameSuffix, counter);
        String javaPath = basePath + classNamePrefix + ".java";
        String classPath = basePath + classNamePrefix + ".class";
        PrintStream source = new PrintStream(javaPath);
        source.println("package " + packageName + ";");
        source.println("public class " + classNamePrefix + " { public static void main(String[] args) { } };");
        source.close();
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        int result = jc.run(null, null, null, javaPath);
        Assert.assertEquals((long)0L, (long)result);
        File classFile = new File(classPath);
        Assert.assertTrue((boolean)classFile.exists());
        return new FileAndPath(packageName.replace('.', '/') + '/', classFile);
    }

    private static void packageAndLoadJar(FileAndPath ... filesInJar) throws Exception {
        String path = basePath + "jar" + jarCounter.incrementAndGet() + ".jar";
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        FileOutputStream fos = new FileOutputStream(path);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fos, manifest);
        HashSet<String> pathsInJar = new HashSet<String>();
        for (FileAndPath fileAndPath : filesInJar) {
            int ix;
            String pathToAdd = fileAndPath.path;
            while (pathsInJar.add(pathToAdd) && (ix = pathToAdd.lastIndexOf(47, pathToAdd.length() - 2)) >= 0) {
                pathToAdd = pathToAdd.substring(0, ix);
            }
        }
        for (String pathInJar : pathsInJar) {
            jarOutputStream.putNextEntry(new JarEntry(pathInJar));
            jarOutputStream.closeEntry();
        }
        for (FileAndPath fileAndPath : filesInJar) {
            File file = fileAndPath.file;
            jarOutputStream.putNextEntry(new JarEntry(fileAndPath.path + file.getName()));
            byte[] allBytes = new byte[(int)file.length()];
            FileInputStream fis = new FileInputStream(file);
            fis.read(allBytes);
            fis.close();
            jarOutputStream.write(allBytes);
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        fos.close();
        File jarFile = new File(path);
        Assert.assertTrue((boolean)jarFile.exists());
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, jarFile.toURI().toURL());
    }

    private static class FileAndPath {
        String path;
        File file;

        public FileAndPath(String path, File file) {
            this.file = file;
            this.path = path;
        }
    }
}

