/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDrainingServer {
    private static final Log LOG = LogFactory.getLog(TestDrainingServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes((String)"t");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final int COUNT_OF_REGIONS = HBaseTestingUtility.KEYS.length;
    private static final int NB_SLAVES = 5;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(5);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        htd.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htd, HBaseTestingUtility.KEYS);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        FSTableDescriptors.createTableDescriptor((FileSystem)fs, (Path)FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), (HTableDescriptor)htd);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        admin.disableTable(TABLENAME);
        admin.enableTable(TABLENAME);
        boolean ready = false;
        while (!ready) {
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
            ready = true;
            for (int i = 0; i < 5; ++i) {
                HRegionServer hrs = cluster.getRegionServer(i);
                if (!hrs.getOnlineRegions().isEmpty()) continue;
                ready = false;
                break;
            }
            if (ready) continue;
            admin.balancer();
            Thread.sleep(100L);
        }
    }

    private static HRegionServer setDrainingServer(HRegionServer hrs) throws KeeperException {
        LOG.info((Object)("Making " + hrs.getServerName() + " the draining server; " + "it has " + hrs.getNumberOfOnlineRegions() + " online regions"));
        ZooKeeperWatcher zkw = hrs.getZooKeeper();
        String hrsDrainingZnode = ZKUtil.joinZNode((String)zkw.drainingZNode, (String)hrs.getServerName().toString());
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)hrsDrainingZnode);
        return hrs;
    }

    private static HRegionServer unsetDrainingServer(HRegionServer hrs) throws KeeperException {
        ZooKeeperWatcher zkw = hrs.getZooKeeper();
        String hrsDrainingZnode = ZKUtil.joinZNode((String)zkw.drainingZNode, (String)hrs.getServerName().toString());
        ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)hrsDrainingZnode);
        return hrs;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDrainingServerOffloading() throws IOException, KeeperException {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        HRegionInfo hriToMoveBack = null;
        HRegionServer drainingServer = TestDrainingServer.setDrainingServer(TEST_UTIL.getMiniHBaseCluster().getRegionServer(0));
        try {
            int regionsOnDrainingServer = drainingServer.getNumberOfOnlineRegions();
            Assert.assertTrue((regionsOnDrainingServer > 0 ? 1 : 0) != 0);
            List hris = drainingServer.getOnlineRegions();
            for (HRegionInfo hri : hris) {
                master.move(hri.getEncodedNameAsBytes(), null);
                hriToMoveBack = hri;
            }
            this.waitForAllRegionsOnline();
            Assert.assertEquals((int)0, (int)drainingServer.getNumberOfOnlineRegions());
        }
        finally {
            TestDrainingServer.unsetDrainingServer(drainingServer);
        }
        master.move(hriToMoveBack.getEncodedNameAsBytes(), Bytes.toBytes((String)drainingServer.getServerName().toString()));
        this.waitForAllRegionsOnline();
        Assert.assertEquals((int)1, (int)drainingServer.getNumberOfOnlineRegions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDrainingServerWithAbort() throws KeeperException, IOException {
        HRegionServer drainingServer = TestDrainingServer.setDrainingServer(TEST_UTIL.getMiniHBaseCluster().getRegionServer(0));
        try {
            int regionsOnDrainingServer = drainingServer.getNumberOfOnlineRegions();
            Assert.assertTrue((regionsOnDrainingServer > 0 ? 1 : 0) != 0);
            int aborted = 0;
            int numberToAbort = 2;
            int i = 1;
            while ((long)i < TEST_UTIL.getMiniHBaseCluster().countServedRegions()) {
                HRegionServer hrs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(i);
                if (!hrs.getServerName().equals((Object)drainingServer.getServerName())) {
                    hrs.abort("Aborting");
                    if (++aborted >= 2) break;
                }
                ++i;
            }
            this.waitForAllRegionsOnline();
            Assert.assertEquals((int)regionsOnDrainingServer, (int)drainingServer.getNumberOfOnlineRegions());
        }
        finally {
            TestDrainingServer.unsetDrainingServer(drainingServer);
        }
    }

    private void waitForAllRegionsOnline() {
        while (TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().isRegionsInTransition()) {
            Threads.sleep((long)10L);
        }
        while (!this.isAllRegionsOnline()) {
            Threads.sleep((long)10L);
        }
    }

    private boolean isAllRegionsOnline() {
        return TEST_UTIL.getMiniHBaseCluster().countServedRegions() == (long)(COUNT_OF_REGIONS + 2);
    }
}

