/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHTableDescriptor {
    static final Log LOG = LogFactory.getLog(TestHTableDescriptor.class);
    String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok"};
    String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok"};

    @Test
    public void testGetSetRemoveCP() throws Exception {
        HTableDescriptor desc = new HTableDescriptor("table");
        String className = BaseRegionObserver.class.getName();
        desc.addCoprocessor(className);
        Assert.assertTrue((boolean)desc.hasCoprocessor(className));
        desc.removeCoprocessor(className);
        Assert.assertFalse((boolean)desc.hasCoprocessor(className));
    }

    @Test
    public void testSetListRemoveCP() throws Exception {
        HTableDescriptor desc = new HTableDescriptor("testGetSetRemoveCP");
        String className1 = BaseRegionObserver.class.getName();
        String className2 = SampleRegionWALObserver.class.getName();
        Assert.assertTrue((desc.getCoprocessors().size() == 0 ? 1 : 0) != 0);
        desc.addCoprocessor(className1);
        Assert.assertTrue((desc.getCoprocessors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className1));
        desc.addCoprocessor(className2);
        Assert.assertTrue((desc.getCoprocessors().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className2));
        desc.removeCoprocessor(className1);
        Assert.assertTrue((desc.getCoprocessors().size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className1));
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className2));
        desc.removeCoprocessor(className2);
        Assert.assertTrue((desc.getCoprocessors().size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className1));
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className2));
    }

    @Test
    public void testRemoveString() throws Exception {
        HTableDescriptor desc = new HTableDescriptor("table");
        String key = "Some";
        String value = "value";
        desc.setValue(key, value);
        Assert.assertEquals((Object)value, (Object)desc.getValue(key));
        desc.remove(key);
        Assert.assertEquals(null, (Object)desc.getValue(key));
    }

    @Test
    public void testGetMaxFileSize() {
        HTableDescriptor desc = new HTableDescriptor("table");
        Assert.assertEquals((long)-1L, (long)desc.getMaxFileSize());
        desc.setMaxFileSize(1111L);
        Assert.assertEquals((long)1111L, (long)desc.getMaxFileSize());
    }

    @Test
    public void testGetMemStoreFlushSize() {
        HTableDescriptor desc = new HTableDescriptor("table");
        Assert.assertEquals((long)-1L, (long)desc.getMemStoreFlushSize());
        desc.setMemStoreFlushSize(1111L);
        Assert.assertEquals((long)1111L, (long)desc.getMemStoreFlushSize());
    }

    @Test
    public void testLegalHTableNames() {
        for (String tn : this.legalTableNames) {
            HTableDescriptor.isLegalTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalHTableNames() {
        for (String tn : this.illegalTableNames) {
            try {
                HTableDescriptor.isLegalTableName((byte[])Bytes.toBytes((String)tn));
                Assert.fail((String)("invalid tablename " + tn + " should have failed"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLegalHTableNamesRegex() {
        for (String tn : this.legalTableNames) {
            LOG.info((Object)("Testing: '" + tn + "'"));
            Assert.assertTrue((boolean)Pattern.matches("(?:[a-zA-Z_0-9][a-zA-Z_0-9.-]*)", tn));
        }
    }

    @Test
    public void testIllegalHTableNamesRegex() {
        for (String tn : this.illegalTableNames) {
            LOG.info((Object)("Testing: '" + tn + "'"));
            Assert.assertFalse((boolean)Pattern.matches("(?:[a-zA-Z_0-9][a-zA-Z_0-9.-]*)", tn));
        }
    }
}

