/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCatalogTracker {
    private static final Log LOG = LogFactory.getLog(TestCatalogTracker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final ServerName SN = new ServerName("example.org", 1234, System.currentTimeMillis());
    private ZooKeeperWatcher watcher;
    private Abortable abortable;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 3);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        this.watcher = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable, true);
    }

    @After
    public void after() {
        this.watcher.close();
    }

    private CatalogTracker constructAndStartCatalogTracker(HConnection c) throws IOException, InterruptedException {
        CatalogTracker ct = new CatalogTracker(this.watcher, UTIL.getConfiguration(), c, this.abortable);
        ct.start();
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatIfMETAMovesWeAreNotified() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        this.constructAndStartCatalogTracker(connection);
        try {
            RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (ServerName)new ServerName("example.com", 1234, System.currentTimeMillis()));
        }
        finally {
            RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptWaitOnMetaAndRoot() throws IOException, InterruptedException {
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        HConnection connection = this.mockConnection(implementation);
        try {
            final CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
            ServerName hsa = ct.getRootLocation();
            junit.framework.Assert.assertNull((Object)hsa);
            ServerName meta = ct.getMetaLocation();
            junit.framework.Assert.assertNull((Object)meta);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        ct.waitForMeta();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted", e);
                    }
                }
            };
            t.start();
            while (!t.isAlive()) {
                Threads.sleep((long)1L);
            }
            Threads.sleep((long)1L);
            Assert.assertTrue((boolean)t.isAlive());
            ct.stop();
            t.join();
        }
        finally {
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerNotRunningIOException() throws IOException, InterruptedException, KeeperException {
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        HConnection connection = this.mockConnection(implementation);
        try {
            Mockito.when((Object)implementation.getRegionInfo((byte[])Mockito.any())).thenThrow(new Throwable[]{new IOException("Server not running, aborting")}).thenReturn((Object)new HRegionInfo());
            Mockito.when((Object)connection.getRegionServerWithRetries((ServerCallable)Mockito.any())).thenReturn((Object)this.getMetaTableRowResult());
            final CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
            try {
                RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (ServerName)SN);
                ct.setMetaLocation(SN);
                final AtomicBoolean metaSet = new AtomicBoolean(false);
                final CountDownLatch latch = new CountDownLatch(1);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            latch.countDown();
                            metaSet.set(ct.waitForMeta(100000L) != null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                t.start();
                latch.await();
                Threads.sleep((long)1L);
                ct.setMetaLocation(SN);
                t.join();
                junit.framework.Assert.assertTrue((boolean)metaSet.get());
            }
            finally {
                ct.resetMetaLocation();
                RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
            }
        }
        finally {
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVerifyMetaRegionLocationWithException(Exception ex) throws IOException, InterruptedException, KeeperException {
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        HConnection connection = this.mockConnection(implementation);
        try {
            Mockito.when((Object)implementation.get((byte[])Mockito.any(), (Get)Mockito.any())).thenThrow(new Throwable[]{ex});
            CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
            try {
                RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (ServerName)SN);
                long timeout = UTIL.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
                junit.framework.Assert.assertFalse((boolean)ct.verifyMetaRegionLocation(timeout));
            }
            finally {
                RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
            }
        }
        finally {
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        }
    }

    @Test
    public void testGetMetaServerConnectionFails() throws IOException, InterruptedException, KeeperException {
        this.testVerifyMetaRegionLocationWithException(new ConnectException("Connection refused"));
    }

    @Test
    public void testVerifyMetaRegionServerNotRunning() throws IOException, InterruptedException, KeeperException {
        this.testVerifyMetaRegionLocationWithException((Exception)new ServerNotRunningYetException("mock"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyRootRegionLocationFails() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        ConnectException connectException = new ConnectException("Connection refused");
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Mockito.when((Object)implementation.getRegionInfo((byte[])Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getHRegionConnection(Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean())).thenReturn((Object)implementation);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        try {
            RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (ServerName)new ServerName("example.com", 1234, System.currentTimeMillis()));
            junit.framework.Assert.assertFalse((boolean)ct.verifyRootRegionLocation(100L));
        }
        finally {
            RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
        }
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForRoot() throws IOException, InterruptedException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        ct.waitForRoot(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RetriesExhaustedException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        HConnection connection = HConnectionTestingUtility.getMockedConnection(UTIL.getConfiguration());
        try {
            CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
            ct.waitForMeta(100L);
        }
        finally {
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        }
    }

    @Test
    public void testNoTimeoutWaitForRoot() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        ServerName hsa = ct.getRootLocation();
        junit.framework.Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread(ct);
        this.startWaitAliveThenWaitItLives(t, 1000);
        hsa = this.setRootLocation();
        t.join();
        junit.framework.Assert.assertTrue((boolean)ct.getRootLocation().equals((Object)hsa));
    }

    private ServerName setRootLocation() throws KeeperException {
        RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (ServerName)SN);
        return SN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testNoTimeoutWaitForMeta() throws Exception {
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        HConnection connection = this.mockConnection(implementation);
        try {
            Result result = this.getMetaTableRowResult();
            Mockito.when((Object)connection.getRegionServerWithRetries((ServerCallable)Mockito.any())).thenReturn((Object)result);
            Mockito.when((Object)implementation.getRegionInfo((byte[])Mockito.any())).thenReturn((Object)HRegionInfo.FIRST_META_REGIONINFO);
            CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
            ServerName hsa = ct.getMetaLocation();
            junit.framework.Assert.assertNull((Object)hsa);
            WaitOnMetaThread t = new WaitOnMetaThread(ct){

                @Override
                void doWaiting() throws InterruptedException {
                    this.ct.waitForMeta();
                }
            };
            this.startWaitAliveThenWaitItLives(t, 1000);
            String node = ct.getMetaNodeTracker().getNode();
            ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)node);
            MetaEditor.updateMetaLocation((CatalogTracker)ct, (HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (ServerName)SN);
            ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)node);
            junit.framework.Assert.assertTrue((boolean)ct.waitForMeta(10000L).equals((Object)SN));
            t.join();
            junit.framework.Assert.assertTrue((boolean)ct.waitForMeta(10000L).equals((Object)SN));
        }
        finally {
            HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        }
    }

    private HConnection mockConnection(HRegionInterface implementation) throws IOException {
        HConnection connection = HConnectionTestingUtility.getMockedConnection(UTIL.getConfiguration());
        ((HConnection)Mockito.doNothing().when((Object)connection)).close();
        HRegionLocation anyLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, SN.getHostname(), SN.getPort());
        Mockito.when((Object)connection.getRegionLocation((byte[])Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)anyLocation);
        Mockito.when((Object)connection.locateRegion((byte[])Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)anyLocation);
        if (implementation != null) {
            Mockito.when((Object)connection.getHRegionConnection(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)implementation);
        }
        return connection;
    }

    private Result getMetaTableRowResult() throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)HRegionInfo.FIRST_META_REGIONINFO)));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)SN.getHostAndPort())));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)SN.getStartcode())));
        return new Result(kvs);
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        while (!t.isAlive()) {
        }
        Threads.sleep((long)ms);
        junit.framework.Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        final CatalogTracker ct;

        WaitOnMetaThread(CatalogTracker ct) {
            super("WaitOnMeta");
            this.ct = ct;
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info((Object)("Exiting " + this.getName()));
        }

        void doWaiting() throws InterruptedException {
            this.ct.waitForRoot();
        }
    }

    class CountingProgressable
    implements Progressable {
        final AtomicInteger counter = new AtomicInteger(0);

        CountingProgressable() {
        }

        public void progress() {
            this.counter.incrementAndGet();
        }
    }
}

