/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PoolMap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestHTableReusablePool.class, TestHTableThreadLocalPool.class})
@Category(value={MediumTests.class})
public class TestHTablePool {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes((String)"TestHTablePool");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLENAME, HConstants.CATALOG_FAMILY);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Category(value={MediumTests.class})
    public static class TestHTableThreadLocalPool
    extends TestHTablePoolType {
        @Override
        protected PoolMap.PoolType getPoolType() {
            return PoolMap.PoolType.ThreadLocal;
        }

        @Test
        public void testTableWithMaxSize() throws Exception {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 2, this.getPoolType());
            HTableInterface table1 = pool.getTable(TABLENAME);
            HTableInterface table2 = pool.getTable(TABLENAME);
            HTableInterface table3 = pool.getTable(TABLENAME);
            table1.close();
            table2.close();
            table3.close();
            HTableInterface sameTable1 = pool.getTable(TABLENAME);
            HTableInterface sameTable2 = pool.getTable(TABLENAME);
            HTableInterface sameTable3 = pool.getTable(TABLENAME);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table3).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable1).getWrappedTable());
            Assert.assertSame((Object)((HTablePool.PooledHTable)table3).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable2).getWrappedTable());
            Assert.assertSame((Object)((HTablePool.PooledHTable)table3).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable3).getWrappedTable());
        }

        @Test
        public void testCloseTablePool() throws IOException {
            int i;
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 4, this.getPoolType());
            HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            if (admin.tableExists(TABLENAME)) {
                admin.disableTable(TABLENAME);
                admin.deleteTable(TABLENAME);
            }
            HTableDescriptor tableDescriptor = new HTableDescriptor(TABLENAME);
            tableDescriptor.addFamily(new HColumnDescriptor("randomFamily"));
            admin.createTable(tableDescriptor);
            HTableInterface[] tables = new HTableInterface[4];
            for (i = 0; i < 4; ++i) {
                tables[i] = pool.getTable(TABLENAME);
            }
            pool.closeTablePool(TABLENAME);
            for (i = 0; i < 4; ++i) {
                tables[i].close();
            }
            Assert.assertEquals((int)1, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
            pool.closeTablePool(TABLENAME);
            Assert.assertEquals((int)0, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
        }
    }

    @Category(value={MediumTests.class})
    public static class TestHTableReusablePool
    extends TestHTablePoolType {
        @Override
        protected PoolMap.PoolType getPoolType() {
            return PoolMap.PoolType.Reusable;
        }

        @Test
        public void testTableWithMaxSize() throws Exception {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 2, this.getPoolType());
            HTableInterface table1 = pool.getTable(TABLENAME);
            HTableInterface table2 = pool.getTable(TABLENAME);
            HTableInterface table3 = pool.getTable(TABLENAME);
            table1.close();
            table2.close();
            table3.close();
            HTableInterface sameTable1 = pool.getTable(TABLENAME);
            HTableInterface sameTable2 = pool.getTable(TABLENAME);
            HTableInterface sameTable3 = pool.getTable(TABLENAME);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table1).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable1).getWrappedTable());
            Assert.assertSame((Object)((HTablePool.PooledHTable)table2).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable2).getWrappedTable());
            Assert.assertNotSame((Object)((HTablePool.PooledHTable)table3).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable3).getWrappedTable());
        }

        @Test
        public void testCloseTablePool() throws IOException {
            int i;
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 4, this.getPoolType());
            HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            if (admin.tableExists(TABLENAME)) {
                admin.disableTable(TABLENAME);
                admin.deleteTable(TABLENAME);
            }
            HTableDescriptor tableDescriptor = new HTableDescriptor(TABLENAME);
            tableDescriptor.addFamily(new HColumnDescriptor("randomFamily"));
            admin.createTable(tableDescriptor);
            HTableInterface[] tables = new HTableInterface[4];
            for (i = 0; i < 4; ++i) {
                tables[i] = pool.getTable(TABLENAME);
            }
            pool.closeTablePool(TABLENAME);
            for (i = 0; i < 4; ++i) {
                tables[i].close();
            }
            Assert.assertEquals((int)4, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
            pool.closeTablePool(TABLENAME);
            Assert.assertEquals((int)0, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
        }
    }

    public static abstract class TestHTablePoolType
    extends TestCase {
        protected abstract PoolMap.PoolType getPoolType();

        @Test
        public void testTableWithStringName() throws Exception {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE, this.getPoolType());
            String tableName = Bytes.toString((byte[])TABLENAME);
            HTableInterface table = pool.getTable(tableName);
            Assert.assertNotNull((Object)table);
            table.close();
            HTableInterface sameTable = pool.getTable(tableName);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable).getWrappedTable());
        }

        @Test
        public void testTableWithByteArrayName() throws IOException {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE, this.getPoolType());
            HTableInterface table = pool.getTable(TABLENAME);
            Assert.assertNotNull((Object)table);
            table.close();
            HTableInterface sameTable = pool.getTable(TABLENAME);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable).getWrappedTable());
        }

        @Test
        public void testTablesWithDifferentNames() throws IOException {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE, this.getPoolType());
            byte[] otherTable = Bytes.toBytes((String)("OtherTable_" + ((Object)((Object)this)).getClass().getSimpleName()));
            TEST_UTIL.createTable(otherTable, HConstants.CATALOG_FAMILY);
            HTableInterface table1 = pool.getTable(TABLENAME);
            HTableInterface table2 = pool.getTable(otherTable);
            Assert.assertNotNull((Object)table2);
            table1.close();
            table2.close();
            HTableInterface sameTable1 = pool.getTable(TABLENAME);
            HTableInterface sameTable2 = pool.getTable(otherTable);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table1).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable1).getWrappedTable());
            Assert.assertSame((Object)((HTablePool.PooledHTable)table2).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable2).getWrappedTable());
        }

        @Test
        public void testProxyImplementationReturned() {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
            String tableName = Bytes.toString((byte[])TABLENAME);
            HTableInterface table = pool.getTable(tableName);
            Assert.assertTrue((boolean)(table instanceof HTablePool.PooledHTable));
        }

        @Test
        public void testDeprecatedUsagePattern() throws IOException {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
            String tableName = Bytes.toString((byte[])TABLENAME);
            HTableInterface table = pool.getTable(tableName);
            pool.putTable(table);
            HTableInterface sameTable = pool.getTable(tableName);
            Assert.assertSame((Object)((HTablePool.PooledHTable)table).getWrappedTable(), (Object)((HTablePool.PooledHTable)sameTable).getWrappedTable());
        }

        @Test
        public void testReturnDifferentTable() throws IOException {
            HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
            String tableName = Bytes.toString((byte[])TABLENAME);
            HTableInterface table = pool.getTable(tableName);
            HTable alienTable = new HTable(TEST_UTIL.getConfiguration(), TABLENAME){};
            try {
                pool.putTable((HTableInterface)alienTable);
                Assert.fail((String)"alien table accepted in pool");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((String)"alien table rejected", (boolean)true);
            }
        }
    }
}

