/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMigrationRemovingHTD;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.migration.HRegionInfo090x;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMetaMigrationRemovingHTD {
    static final Log LOG = LogFactory.getLog(TestMetaMigrationRemovingHTD.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TESTTABLE = "TestTable";
    private static final int ROWCOUNT = 100;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        Path testdir = TEST_UTIL.getDataTestDir("TestMetaMigrationRemovingHTD");
        File untar = TestMetaMigrationRemovingHTD.untar(new File(testdir.toString()));
        Configuration conf = TEST_UTIL.getConfiguration();
        FsShell shell = new FsShell(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        if (!fs.isDirectory(hbaseRootDir.getParent())) {
            fs.mkdirs(hbaseRootDir.getParent());
        }
        TestMetaMigrationRemovingHTD.doFsCommand(shell, new String[]{"-put", untar.toURI().toString(), hbaseRootDir.toString()});
        TestMetaMigrationRemovingHTD.doFsCommand(shell, new String[]{"-lsr", "/"});
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TESTTABLE);
        ResultScanner scanner = t.getScanner(new Scan());
        int count = 0;
        while (scanner.next() != null) {
            ++count;
        }
        junit.framework.Assert.assertEquals((int)100, (int)count);
        scanner.close();
        t.close();
    }

    private static File untar(File testdir) throws IOException {
        String datafile = "hbase-4388-root.dir";
        String srcTarFile = System.getProperty("project.build.testSourceDirectory", "src/test") + File.separator + "data" + File.separator + "hbase-4388-root.dir" + ".tgz";
        File homedir = new File(testdir.toString());
        File tgtUntarDir = new File(homedir, "hbase-4388-root.dir");
        if (tgtUntarDir.exists() && !FileUtil.fullyDelete((File)tgtUntarDir)) {
            throw new IOException("Failed delete of " + tgtUntarDir.toString());
        }
        LOG.info((Object)("Untarring " + srcTarFile + " into " + homedir.toString()));
        FileUtil.unTar((File)new File(srcTarFile), (File)homedir);
        junit.framework.Assert.assertTrue((boolean)tgtUntarDir.exists());
        return tgtUntarDir;
    }

    private static void doFsCommand(FsShell shell, String[] args) throws Exception {
        int errcode = shell.run(args);
        if (errcode != 0) {
            throw new IOException("Failed put; errcode=" + errcode);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaUpdatedFlagInROOT() throws Exception {
        boolean metaUpdated = MetaMigrationRemovingHTD.isMetaHRIUpdated((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        TestMetaMigrationRemovingHTD.assertEquals(true, metaUpdated);
    }

    @Test
    public void testMetaMigration() throws Exception {
        LOG.info((Object)"Starting testMetaWithLegacyHRI");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HTableDescriptor htd = new HTableDescriptor("testMetaMigration");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        Configuration conf = TEST_UTIL.getConfiguration();
        this.createMultiRegionsWithLegacyHRI(conf, htd, FAMILY, new byte[][]{HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"region_a"), Bytes.toBytes((String)"region_b")});
        CatalogTracker ct = TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker();
        this.undoVersionInMeta();
        MetaReader.fullScanMetaAndPrint((CatalogTracker)ct);
        LOG.info((Object)"Meta Print completed.testUpdatesOnMetaWithLegacyHRI");
        Set htds = MetaMigrationRemovingHTD.updateMetaWithNewRegionInfo((MasterServices)TEST_UTIL.getHBaseCluster().getMaster());
        MetaReader.fullScanMetaAndPrint((CatalogTracker)ct);
        TestMetaMigrationRemovingHTD.assertEquals(1, htds.size());
        Assert.assertTrue((boolean)htds.contains(htd));
        boolean metaUpdated = MetaMigrationRemovingHTD.isMetaHRIUpdated((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        TestMetaMigrationRemovingHTD.assertEquals(true, metaUpdated);
    }

    @Test
    public void testMasterCrashDuringMetaMigration() throws Exception {
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HTableDescriptor htd = new HTableDescriptor("testMasterCrashDuringMetaMigration");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        Configuration conf = TEST_UTIL.getConfiguration();
        this.createMultiRegionsWithNewHRI(conf, htd, FAMILY, 10);
        this.createMultiRegionsWithLegacyHRI(conf, htd, FAMILY, 10);
        CatalogTracker ct = TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker();
        this.undoVersionInMeta();
        MetaMigrationRemovingHTD.updateRootWithMetaMigrationStatus((CatalogTracker)ct);
        LOG.info((Object)"Meta Print completed.testUpdatesOnMetaWithLegacyHRI");
        Set htds = MetaMigrationRemovingHTD.updateMetaWithNewRegionInfo((MasterServices)TEST_UTIL.getHBaseCluster().getMaster());
        TestMetaMigrationRemovingHTD.assertEquals(1, htds.size());
        Assert.assertTrue((boolean)htds.contains(htd));
        boolean metaUpdated = MetaMigrationRemovingHTD.isMetaHRIUpdated((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        TestMetaMigrationRemovingHTD.assertEquals(true, metaUpdated);
        LOG.info((Object)"END testMetaWithLegacyHRI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoVersionInMeta() throws IOException {
        Delete d = new Delete(HRegionInfo.ROOT_REGIONINFO.getRegionName());
        d.deleteColumn(HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER);
        HTable rootTable = new HTable(TEST_UTIL.getConfiguration(), HConstants.ROOT_TABLE_NAME);
        try {
            rootTable.delete(d);
        }
        finally {
            rootTable.close();
        }
    }

    public static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new AssertionFailedError("expected:<" + expected + "> but was:<" + actual + ">");
        }
    }

    public static void assertEquals(boolean expected, boolean actual) {
        if (expected != actual) {
            throw new AssertionFailedError("expected:<" + expected + "> but was:<" + actual + ">");
        }
    }

    public int createMultiRegionsWithLegacyHRI(Configuration c, HTableDescriptor htd, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegionsWithLegacyHRI(c, htd, family, regionStartKeys);
    }

    public int createMultiRegionsWithLegacyHRI(Configuration c, HTableDescriptor htd, byte[] columnFamily, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, HConstants.META_TABLE_NAME);
        if (!htd.hasFamily(columnFamily)) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
            htd.addFamily(hcd);
        }
        ArrayList<HRegionInfo090x> newRegions = new ArrayList<HRegionInfo090x>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo090x hri = new HRegionInfo090x(htd, startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.setWriteToWAL(false);
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegions: PUT inserted " + hri.toString()));
            newRegions.add(hri);
            ++count;
        }
        meta.close();
        return count;
    }

    int createMultiRegionsWithNewHRI(Configuration c, HTableDescriptor htd, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegionsWithNewHRI(c, htd, family, regionStartKeys);
    }

    int createMultiRegionsWithNewHRI(Configuration c, HTableDescriptor htd, byte[] columnFamily, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, HConstants.META_TABLE_NAME);
        if (!htd.hasFamily(columnFamily)) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
            htd.addFamily(hcd);
        }
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(htd.getName(), startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.setWriteToWAL(false);
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegions: PUT inserted " + hri.toString()));
            newRegions.add(hri);
            ++count;
        }
        meta.close();
        return count;
    }
}

